/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.vmm.vmm.v4.images.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.vmm.common.v1.response.ApiLink;
import com.nutanix.dp1.vmm.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.vmm.deserializers.VmmObjectTypeTypedObject;
import com.nutanix.dp1.vmm.vmm.v4.images.config.Filter;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.List;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateLimitPolicy
extends ExternalizableAbstractModel
implements Serializable,
VmmObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(RateLimitPolicy.class);
    private OffsetDateTime createTime = null;
    private OffsetDateTime lastUpdateTime = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    private @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String ownerExtId = null;
    @Size(min=0, max=200)
    private @Size(min=0, max=200) List<String> matchingClusterExtIds = null;
    @Size(min=1, max=256)
    @JsonProperty(value="name")
    public @Size(min=1, max=256) String name = null;
    @Size(max=1000)
    @JsonProperty(value="description")
    public @Size(max=1000) String description = null;
    @Max(value=0x100000000L)
    @Min(value=1L)
    @JsonProperty(value="rateLimitKbps")
    public @Max(value=0x100000000L) @Min(value=1L) Long rateLimitKbps = null;
    @JsonProperty(value="clusterEntityFilter")
    public Filter clusterEntityFilter = null;

    public RateLimitPolicy() {
    }

    public RateLimitPolicy(String tenantId, String extId, List<ApiLink> links, String name, String description, Long rateLimitKbps, Filter clusterEntityFilter, OffsetDateTime createTime, OffsetDateTime lastUpdateTime, String ownerExtId, List<String> matchingClusterExtIds) {
        super(tenantId, extId, links);
        this.setName(name);
        this.setDescription(description);
        this.setRateLimitKbps(rateLimitKbps);
        this.setClusterEntityFilter(clusterEntityFilter);
        this.setCreateTime(createTime);
        this.setLastUpdateTime(lastUpdateTime);
        this.setOwnerExtId(ownerExtId);
        this.setMatchingClusterExtIds(matchingClusterExtIds);
    }

    @Override
    protected String initialize$objectType() {
        return "vmm.v4.images.config.RateLimitPolicy";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setCreateTime(OffsetDateTime createTime) {
        if (this.createTime == null) {
            this.createTime = createTime;
        } else {
            log.warn("Read-only property createTime already contains a non-null value and cannot be set again");
        }
    }

    public void setLastUpdateTime(OffsetDateTime lastUpdateTime) {
        if (this.lastUpdateTime == null) {
            this.lastUpdateTime = lastUpdateTime;
        } else {
            log.warn("Read-only property lastUpdateTime already contains a non-null value and cannot be set again");
        }
    }

    public void setOwnerExtId(String ownerExtId) {
        if (this.ownerExtId == null) {
            this.ownerExtId = ownerExtId;
        } else {
            log.warn("Read-only property ownerExtId already contains a non-null value and cannot be set again");
        }
    }

    public void setMatchingClusterExtIds(List<String> matchingClusterExtIds) {
        if (this.matchingClusterExtIds == null) {
            this.matchingClusterExtIds = matchingClusterExtIds;
        } else {
            log.warn("Read-only property matchingClusterExtIds already contains a non-null value and cannot be set again");
        }
    }

    public static RateLimitPolicyBuilder RateLimitPolicyBuilder() {
        return new RateLimitPolicyBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RateLimitPolicy)) {
            return false;
        }
        RateLimitPolicy other = (RateLimitPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OffsetDateTime this$createTime = this.getCreateTime();
        OffsetDateTime other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        OffsetDateTime this$lastUpdateTime = this.getLastUpdateTime();
        OffsetDateTime other$lastUpdateTime = other.getLastUpdateTime();
        if (this$lastUpdateTime == null ? other$lastUpdateTime != null : !((Object)this$lastUpdateTime).equals(other$lastUpdateTime)) {
            return false;
        }
        String this$ownerExtId = this.getOwnerExtId();
        String other$ownerExtId = other.getOwnerExtId();
        if (this$ownerExtId == null ? other$ownerExtId != null : !this$ownerExtId.equals(other$ownerExtId)) {
            return false;
        }
        List<String> this$matchingClusterExtIds = this.getMatchingClusterExtIds();
        List<String> other$matchingClusterExtIds = other.getMatchingClusterExtIds();
        if (this$matchingClusterExtIds == null ? other$matchingClusterExtIds != null : !((Object)this$matchingClusterExtIds).equals(other$matchingClusterExtIds)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Long this$rateLimitKbps = this.getRateLimitKbps();
        Long other$rateLimitKbps = other.getRateLimitKbps();
        if (this$rateLimitKbps == null ? other$rateLimitKbps != null : !((Object)this$rateLimitKbps).equals(other$rateLimitKbps)) {
            return false;
        }
        Filter this$clusterEntityFilter = this.getClusterEntityFilter();
        Filter other$clusterEntityFilter = other.getClusterEntityFilter();
        return !(this$clusterEntityFilter == null ? other$clusterEntityFilter != null : !((Object)this$clusterEntityFilter).equals(other$clusterEntityFilter));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RateLimitPolicy;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        OffsetDateTime $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        OffsetDateTime $lastUpdateTime = this.getLastUpdateTime();
        result = result * 59 + ($lastUpdateTime == null ? 43 : ((Object)$lastUpdateTime).hashCode());
        String $ownerExtId = this.getOwnerExtId();
        result = result * 59 + ($ownerExtId == null ? 43 : $ownerExtId.hashCode());
        List<String> $matchingClusterExtIds = this.getMatchingClusterExtIds();
        result = result * 59 + ($matchingClusterExtIds == null ? 43 : ((Object)$matchingClusterExtIds).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Long $rateLimitKbps = this.getRateLimitKbps();
        result = result * 59 + ($rateLimitKbps == null ? 43 : ((Object)$rateLimitKbps).hashCode());
        Filter $clusterEntityFilter = this.getClusterEntityFilter();
        result = result * 59 + ($clusterEntityFilter == null ? 43 : ((Object)$clusterEntityFilter).hashCode());
        return result;
    }

    public OffsetDateTime getCreateTime() {
        return this.createTime;
    }

    public OffsetDateTime getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public String getOwnerExtId() {
        return this.ownerExtId;
    }

    public List<String> getMatchingClusterExtIds() {
        return this.matchingClusterExtIds;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getRateLimitKbps() {
        return this.rateLimitKbps;
    }

    public Filter getClusterEntityFilter() {
        return this.clusterEntityFilter;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="rateLimitKbps")
    public void setRateLimitKbps(Long rateLimitKbps) {
        this.rateLimitKbps = rateLimitKbps;
    }

    @JsonProperty(value="clusterEntityFilter")
    public void setClusterEntityFilter(Filter clusterEntityFilter) {
        this.clusterEntityFilter = clusterEntityFilter;
    }

    @Override
    public String toString() {
        return "RateLimitPolicy(createTime=" + this.getCreateTime() + ", lastUpdateTime=" + this.getLastUpdateTime() + ", ownerExtId=" + this.getOwnerExtId() + ", matchingClusterExtIds=" + this.getMatchingClusterExtIds() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", rateLimitKbps=" + this.getRateLimitKbps() + ", clusterEntityFilter=" + this.getClusterEntityFilter() + ")";
    }

    public static class RateLimitPolicyBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String name;
        private String description;
        private Long rateLimitKbps;
        private Filter clusterEntityFilter;
        private OffsetDateTime createTime;
        private OffsetDateTime lastUpdateTime;
        private String ownerExtId;
        private List<String> matchingClusterExtIds;

        RateLimitPolicyBuilder() {
        }

        public RateLimitPolicyBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public RateLimitPolicyBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public RateLimitPolicyBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public RateLimitPolicyBuilder name(String name) {
            this.name = name;
            return this;
        }

        public RateLimitPolicyBuilder description(String description) {
            this.description = description;
            return this;
        }

        public RateLimitPolicyBuilder rateLimitKbps(Long rateLimitKbps) {
            this.rateLimitKbps = rateLimitKbps;
            return this;
        }

        public RateLimitPolicyBuilder clusterEntityFilter(Filter clusterEntityFilter) {
            this.clusterEntityFilter = clusterEntityFilter;
            return this;
        }

        public RateLimitPolicyBuilder createTime(OffsetDateTime createTime) {
            this.createTime = createTime;
            return this;
        }

        public RateLimitPolicyBuilder lastUpdateTime(OffsetDateTime lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public RateLimitPolicyBuilder ownerExtId(String ownerExtId) {
            this.ownerExtId = ownerExtId;
            return this;
        }

        public RateLimitPolicyBuilder matchingClusterExtIds(List<String> matchingClusterExtIds) {
            this.matchingClusterExtIds = matchingClusterExtIds;
            return this;
        }

        public RateLimitPolicy build() {
            return new RateLimitPolicy(this.tenantId, this.extId, this.links, this.name, this.description, this.rateLimitKbps, this.clusterEntityFilter, this.createTime, this.lastUpdateTime, this.ownerExtId, this.matchingClusterExtIds);
        }

        public String toString() {
            return "RateLimitPolicy.RateLimitPolicyBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", name=" + this.name + ", description=" + this.description + ", rateLimitKbps=" + this.rateLimitKbps + ", clusterEntityFilter=" + this.clusterEntityFilter + ", createTime=" + this.createTime + ", lastUpdateTime=" + this.lastUpdateTime + ", ownerExtId=" + this.ownerExtId + ", matchingClusterExtIds=" + this.matchingClusterExtIds + ")";
        }
    }
}

