/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.vmm.vmm.v4.content;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.vmm.common.v1.response.ApiLink;
import com.nutanix.dp1.vmm.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.vmm.deserializers.VmmObjectTypeTypedObject;
import com.nutanix.dp1.vmm.vmm.v4.content.GuestUpdateStatus;
import com.nutanix.dp1.vmm.vmm.v4.content.TemplateUser;
import com.nutanix.dp1.vmm.vmm.v4.content.TemplateVersionSpec;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.List;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Template
extends ExternalizableAbstractModel
implements Serializable,
VmmObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(Template.class);
    private OffsetDateTime createTime = null;
    private OffsetDateTime updateTime = null;
    @Size(min=1, max=256)
    @JsonProperty(value="templateName")
    public @Size(min=1, max=256) String templateName = null;
    @Size(max=1000)
    @JsonProperty(value="templateDescription")
    public @Size(max=1000) String templateDescription = null;
    @JsonProperty(value="templateVersionSpec")
    public TemplateVersionSpec templateVersionSpec = null;
    @JsonProperty(value="guestUpdateStatus")
    public GuestUpdateStatus guestUpdateStatus = null;
    @JsonProperty(value="createdBy")
    public TemplateUser createdBy = null;
    @JsonProperty(value="updatedBy")
    public TemplateUser updatedBy = null;

    public Template() {
    }

    public Template(String tenantId, String extId, List<ApiLink> links, String templateName, String templateDescription, TemplateVersionSpec templateVersionSpec, GuestUpdateStatus guestUpdateStatus, OffsetDateTime createTime, OffsetDateTime updateTime, TemplateUser createdBy, TemplateUser updatedBy) {
        super(tenantId, extId, links);
        this.setTemplateName(templateName);
        this.setTemplateDescription(templateDescription);
        this.setTemplateVersionSpec(templateVersionSpec);
        this.setGuestUpdateStatus(guestUpdateStatus);
        this.setCreateTime(createTime);
        this.setUpdateTime(updateTime);
        this.setCreatedBy(createdBy);
        this.setUpdatedBy(updatedBy);
    }

    @Override
    protected String initialize$objectType() {
        return "vmm.v4.content.Template";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setCreateTime(OffsetDateTime createTime) {
        if (this.createTime == null) {
            this.createTime = createTime;
        } else {
            log.warn("Read-only property createTime already contains a non-null value and cannot be set again");
        }
    }

    public void setUpdateTime(OffsetDateTime updateTime) {
        if (this.updateTime == null) {
            this.updateTime = updateTime;
        } else {
            log.warn("Read-only property updateTime already contains a non-null value and cannot be set again");
        }
    }

    public static TemplateBuilder TemplateBuilder() {
        return new TemplateBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Template)) {
            return false;
        }
        Template other = (Template)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OffsetDateTime this$createTime = this.getCreateTime();
        OffsetDateTime other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        OffsetDateTime this$updateTime = this.getUpdateTime();
        OffsetDateTime other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        String this$templateName = this.getTemplateName();
        String other$templateName = other.getTemplateName();
        if (this$templateName == null ? other$templateName != null : !this$templateName.equals(other$templateName)) {
            return false;
        }
        String this$templateDescription = this.getTemplateDescription();
        String other$templateDescription = other.getTemplateDescription();
        if (this$templateDescription == null ? other$templateDescription != null : !this$templateDescription.equals(other$templateDescription)) {
            return false;
        }
        TemplateVersionSpec this$templateVersionSpec = this.getTemplateVersionSpec();
        TemplateVersionSpec other$templateVersionSpec = other.getTemplateVersionSpec();
        if (this$templateVersionSpec == null ? other$templateVersionSpec != null : !((Object)this$templateVersionSpec).equals(other$templateVersionSpec)) {
            return false;
        }
        GuestUpdateStatus this$guestUpdateStatus = this.getGuestUpdateStatus();
        GuestUpdateStatus other$guestUpdateStatus = other.getGuestUpdateStatus();
        if (this$guestUpdateStatus == null ? other$guestUpdateStatus != null : !((Object)this$guestUpdateStatus).equals(other$guestUpdateStatus)) {
            return false;
        }
        TemplateUser this$createdBy = this.getCreatedBy();
        TemplateUser other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !((Object)this$createdBy).equals(other$createdBy)) {
            return false;
        }
        TemplateUser this$updatedBy = this.getUpdatedBy();
        TemplateUser other$updatedBy = other.getUpdatedBy();
        return !(this$updatedBy == null ? other$updatedBy != null : !((Object)this$updatedBy).equals(other$updatedBy));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Template;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        OffsetDateTime $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        OffsetDateTime $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        String $templateName = this.getTemplateName();
        result = result * 59 + ($templateName == null ? 43 : $templateName.hashCode());
        String $templateDescription = this.getTemplateDescription();
        result = result * 59 + ($templateDescription == null ? 43 : $templateDescription.hashCode());
        TemplateVersionSpec $templateVersionSpec = this.getTemplateVersionSpec();
        result = result * 59 + ($templateVersionSpec == null ? 43 : ((Object)$templateVersionSpec).hashCode());
        GuestUpdateStatus $guestUpdateStatus = this.getGuestUpdateStatus();
        result = result * 59 + ($guestUpdateStatus == null ? 43 : ((Object)$guestUpdateStatus).hashCode());
        TemplateUser $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : ((Object)$createdBy).hashCode());
        TemplateUser $updatedBy = this.getUpdatedBy();
        result = result * 59 + ($updatedBy == null ? 43 : ((Object)$updatedBy).hashCode());
        return result;
    }

    public OffsetDateTime getCreateTime() {
        return this.createTime;
    }

    public OffsetDateTime getUpdateTime() {
        return this.updateTime;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public String getTemplateDescription() {
        return this.templateDescription;
    }

    public TemplateVersionSpec getTemplateVersionSpec() {
        return this.templateVersionSpec;
    }

    public GuestUpdateStatus getGuestUpdateStatus() {
        return this.guestUpdateStatus;
    }

    public TemplateUser getCreatedBy() {
        return this.createdBy;
    }

    public TemplateUser getUpdatedBy() {
        return this.updatedBy;
    }

    @JsonProperty(value="templateName")
    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    @JsonProperty(value="templateDescription")
    public void setTemplateDescription(String templateDescription) {
        this.templateDescription = templateDescription;
    }

    @JsonProperty(value="templateVersionSpec")
    public void setTemplateVersionSpec(TemplateVersionSpec templateVersionSpec) {
        this.templateVersionSpec = templateVersionSpec;
    }

    @JsonProperty(value="guestUpdateStatus")
    public void setGuestUpdateStatus(GuestUpdateStatus guestUpdateStatus) {
        this.guestUpdateStatus = guestUpdateStatus;
    }

    @JsonProperty(value="createdBy")
    public void setCreatedBy(TemplateUser createdBy) {
        this.createdBy = createdBy;
    }

    @JsonProperty(value="updatedBy")
    public void setUpdatedBy(TemplateUser updatedBy) {
        this.updatedBy = updatedBy;
    }

    @Override
    public String toString() {
        return "Template(createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ", templateName=" + this.getTemplateName() + ", templateDescription=" + this.getTemplateDescription() + ", templateVersionSpec=" + this.getTemplateVersionSpec() + ", guestUpdateStatus=" + this.getGuestUpdateStatus() + ", createdBy=" + this.getCreatedBy() + ", updatedBy=" + this.getUpdatedBy() + ")";
    }

    public static class TemplateBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String templateName;
        private String templateDescription;
        private TemplateVersionSpec templateVersionSpec;
        private GuestUpdateStatus guestUpdateStatus;
        private OffsetDateTime createTime;
        private OffsetDateTime updateTime;
        private TemplateUser createdBy;
        private TemplateUser updatedBy;

        TemplateBuilder() {
        }

        public TemplateBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public TemplateBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public TemplateBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public TemplateBuilder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public TemplateBuilder templateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
            return this;
        }

        public TemplateBuilder templateVersionSpec(TemplateVersionSpec templateVersionSpec) {
            this.templateVersionSpec = templateVersionSpec;
            return this;
        }

        public TemplateBuilder guestUpdateStatus(GuestUpdateStatus guestUpdateStatus) {
            this.guestUpdateStatus = guestUpdateStatus;
            return this;
        }

        public TemplateBuilder createTime(OffsetDateTime createTime) {
            this.createTime = createTime;
            return this;
        }

        public TemplateBuilder updateTime(OffsetDateTime updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public TemplateBuilder createdBy(TemplateUser createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public TemplateBuilder updatedBy(TemplateUser updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public Template build() {
            return new Template(this.tenantId, this.extId, this.links, this.templateName, this.templateDescription, this.templateVersionSpec, this.guestUpdateStatus, this.createTime, this.updateTime, this.createdBy, this.updatedBy);
        }

        public String toString() {
            return "Template.TemplateBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", templateName=" + this.templateName + ", templateDescription=" + this.templateDescription + ", templateVersionSpec=" + this.templateVersionSpec + ", guestUpdateStatus=" + this.guestUpdateStatus + ", createTime=" + this.createTime + ", updateTime=" + this.updateTime + ", createdBy=" + this.createdBy + ", updatedBy=" + this.updatedBy + ")";
        }
    }
}

