/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.vmm.vmm.v4.ahv.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.vmm.common.v1.response.ApiLink;
import com.nutanix.dp1.vmm.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.vmm.deserializers.VmmObjectTypeTypedObject;
import com.nutanix.dp1.vmm.vmm.v4.ahv.config.GpuMode;
import com.nutanix.dp1.vmm.vmm.v4.ahv.config.GpuVendor;
import com.nutanix.dp1.vmm.vmm.v4.ahv.config.SBDF;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Gpu
extends ExternalizableAbstractModel
implements Serializable,
VmmObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(Gpu.class);
    @Size(max=128)
    private @Size(max=128) String guestDriverVersion = null;
    @Size(max=128)
    private @Size(max=128) String name = null;
    private Long frameBufferSizeBytes = null;
    private Integer numVirtualDisplayHeads = null;
    private Integer fraction = null;
    @JsonProperty(value="mode")
    public GpuMode mode = null;
    @JsonProperty(value="deviceId")
    public Integer deviceId = null;
    @JsonProperty(value="vendor")
    public GpuVendor vendor = null;
    @JsonProperty(value="pciAddress")
    public SBDF pciAddress = null;

    public Gpu() {
    }

    public Gpu(String tenantId, String extId, List<ApiLink> links, GpuMode mode, Integer deviceId, GpuVendor vendor, SBDF pciAddress, String guestDriverVersion, String name, Long frameBufferSizeBytes, Integer numVirtualDisplayHeads, Integer fraction) {
        super(tenantId, extId, links);
        this.setMode(mode);
        this.setDeviceId(deviceId);
        this.setVendor(vendor);
        this.setPciAddress(pciAddress);
        this.setGuestDriverVersion(guestDriverVersion);
        this.setName(name);
        this.setFrameBufferSizeBytes(frameBufferSizeBytes);
        this.setNumVirtualDisplayHeads(numVirtualDisplayHeads);
        this.setFraction(fraction);
    }

    @Override
    protected String initialize$objectType() {
        return "vmm.v4.ahv.config.Gpu";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setGuestDriverVersion(String guestDriverVersion) {
        if (this.guestDriverVersion == null) {
            this.guestDriverVersion = guestDriverVersion;
        } else {
            log.warn("Read-only property guestDriverVersion already contains a non-null value and cannot be set again");
        }
    }

    public void setName(String name) {
        if (this.name == null) {
            this.name = name;
        } else {
            log.warn("Read-only property name already contains a non-null value and cannot be set again");
        }
    }

    public void setFrameBufferSizeBytes(Long frameBufferSizeBytes) {
        if (this.frameBufferSizeBytes == null) {
            this.frameBufferSizeBytes = frameBufferSizeBytes;
        } else {
            log.warn("Read-only property frameBufferSizeBytes already contains a non-null value and cannot be set again");
        }
    }

    public void setNumVirtualDisplayHeads(Integer numVirtualDisplayHeads) {
        if (this.numVirtualDisplayHeads == null) {
            this.numVirtualDisplayHeads = numVirtualDisplayHeads;
        } else {
            log.warn("Read-only property numVirtualDisplayHeads already contains a non-null value and cannot be set again");
        }
    }

    public void setFraction(Integer fraction) {
        if (this.fraction == null) {
            this.fraction = fraction;
        } else {
            log.warn("Read-only property fraction already contains a non-null value and cannot be set again");
        }
    }

    public static GpuBuilder GpuBuilder() {
        return new GpuBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Gpu)) {
            return false;
        }
        Gpu other = (Gpu)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$guestDriverVersion = this.getGuestDriverVersion();
        String other$guestDriverVersion = other.getGuestDriverVersion();
        if (this$guestDriverVersion == null ? other$guestDriverVersion != null : !this$guestDriverVersion.equals(other$guestDriverVersion)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Long this$frameBufferSizeBytes = this.getFrameBufferSizeBytes();
        Long other$frameBufferSizeBytes = other.getFrameBufferSizeBytes();
        if (this$frameBufferSizeBytes == null ? other$frameBufferSizeBytes != null : !((Object)this$frameBufferSizeBytes).equals(other$frameBufferSizeBytes)) {
            return false;
        }
        Integer this$numVirtualDisplayHeads = this.getNumVirtualDisplayHeads();
        Integer other$numVirtualDisplayHeads = other.getNumVirtualDisplayHeads();
        if (this$numVirtualDisplayHeads == null ? other$numVirtualDisplayHeads != null : !((Object)this$numVirtualDisplayHeads).equals(other$numVirtualDisplayHeads)) {
            return false;
        }
        Integer this$fraction = this.getFraction();
        Integer other$fraction = other.getFraction();
        if (this$fraction == null ? other$fraction != null : !((Object)this$fraction).equals(other$fraction)) {
            return false;
        }
        GpuMode this$mode = this.getMode();
        GpuMode other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode)) {
            return false;
        }
        Integer this$deviceId = this.getDeviceId();
        Integer other$deviceId = other.getDeviceId();
        if (this$deviceId == null ? other$deviceId != null : !((Object)this$deviceId).equals(other$deviceId)) {
            return false;
        }
        GpuVendor this$vendor = this.getVendor();
        GpuVendor other$vendor = other.getVendor();
        if (this$vendor == null ? other$vendor != null : !((Object)((Object)this$vendor)).equals((Object)other$vendor)) {
            return false;
        }
        SBDF this$pciAddress = this.getPciAddress();
        SBDF other$pciAddress = other.getPciAddress();
        return !(this$pciAddress == null ? other$pciAddress != null : !((Object)this$pciAddress).equals(other$pciAddress));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Gpu;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $guestDriverVersion = this.getGuestDriverVersion();
        result = result * 59 + ($guestDriverVersion == null ? 43 : $guestDriverVersion.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Long $frameBufferSizeBytes = this.getFrameBufferSizeBytes();
        result = result * 59 + ($frameBufferSizeBytes == null ? 43 : ((Object)$frameBufferSizeBytes).hashCode());
        Integer $numVirtualDisplayHeads = this.getNumVirtualDisplayHeads();
        result = result * 59 + ($numVirtualDisplayHeads == null ? 43 : ((Object)$numVirtualDisplayHeads).hashCode());
        Integer $fraction = this.getFraction();
        result = result * 59 + ($fraction == null ? 43 : ((Object)$fraction).hashCode());
        GpuMode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        Integer $deviceId = this.getDeviceId();
        result = result * 59 + ($deviceId == null ? 43 : ((Object)$deviceId).hashCode());
        GpuVendor $vendor = this.getVendor();
        result = result * 59 + ($vendor == null ? 43 : ((Object)((Object)$vendor)).hashCode());
        SBDF $pciAddress = this.getPciAddress();
        result = result * 59 + ($pciAddress == null ? 43 : ((Object)$pciAddress).hashCode());
        return result;
    }

    public String getGuestDriverVersion() {
        return this.guestDriverVersion;
    }

    public String getName() {
        return this.name;
    }

    public Long getFrameBufferSizeBytes() {
        return this.frameBufferSizeBytes;
    }

    public Integer getNumVirtualDisplayHeads() {
        return this.numVirtualDisplayHeads;
    }

    public Integer getFraction() {
        return this.fraction;
    }

    public GpuMode getMode() {
        return this.mode;
    }

    public Integer getDeviceId() {
        return this.deviceId;
    }

    public GpuVendor getVendor() {
        return this.vendor;
    }

    public SBDF getPciAddress() {
        return this.pciAddress;
    }

    @JsonProperty(value="mode")
    public void setMode(GpuMode mode) {
        this.mode = mode;
    }

    @JsonProperty(value="deviceId")
    public void setDeviceId(Integer deviceId) {
        this.deviceId = deviceId;
    }

    @JsonProperty(value="vendor")
    public void setVendor(GpuVendor vendor) {
        this.vendor = vendor;
    }

    @JsonProperty(value="pciAddress")
    public void setPciAddress(SBDF pciAddress) {
        this.pciAddress = pciAddress;
    }

    @Override
    public String toString() {
        return "Gpu(guestDriverVersion=" + this.getGuestDriverVersion() + ", name=" + this.getName() + ", frameBufferSizeBytes=" + this.getFrameBufferSizeBytes() + ", numVirtualDisplayHeads=" + this.getNumVirtualDisplayHeads() + ", fraction=" + this.getFraction() + ", mode=" + (Object)((Object)this.getMode()) + ", deviceId=" + this.getDeviceId() + ", vendor=" + (Object)((Object)this.getVendor()) + ", pciAddress=" + this.getPciAddress() + ")";
    }

    public static class GpuBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private GpuMode mode;
        private Integer deviceId;
        private GpuVendor vendor;
        private SBDF pciAddress;
        private String guestDriverVersion;
        private String name;
        private Long frameBufferSizeBytes;
        private Integer numVirtualDisplayHeads;
        private Integer fraction;

        GpuBuilder() {
        }

        public GpuBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public GpuBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public GpuBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public GpuBuilder mode(GpuMode mode) {
            this.mode = mode;
            return this;
        }

        public GpuBuilder deviceId(Integer deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public GpuBuilder vendor(GpuVendor vendor) {
            this.vendor = vendor;
            return this;
        }

        public GpuBuilder pciAddress(SBDF pciAddress) {
            this.pciAddress = pciAddress;
            return this;
        }

        public GpuBuilder guestDriverVersion(String guestDriverVersion) {
            this.guestDriverVersion = guestDriverVersion;
            return this;
        }

        public GpuBuilder name(String name) {
            this.name = name;
            return this;
        }

        public GpuBuilder frameBufferSizeBytes(Long frameBufferSizeBytes) {
            this.frameBufferSizeBytes = frameBufferSizeBytes;
            return this;
        }

        public GpuBuilder numVirtualDisplayHeads(Integer numVirtualDisplayHeads) {
            this.numVirtualDisplayHeads = numVirtualDisplayHeads;
            return this;
        }

        public GpuBuilder fraction(Integer fraction) {
            this.fraction = fraction;
            return this;
        }

        public Gpu build() {
            return new Gpu(this.tenantId, this.extId, this.links, this.mode, this.deviceId, this.vendor, this.pciAddress, this.guestDriverVersion, this.name, this.frameBufferSizeBytes, this.numVirtualDisplayHeads, this.fraction);
        }

        public String toString() {
            return "Gpu.GpuBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", mode=" + (Object)((Object)this.mode) + ", deviceId=" + this.deviceId + ", vendor=" + (Object)((Object)this.vendor) + ", pciAddress=" + this.pciAddress + ", guestDriverVersion=" + this.guestDriverVersion + ", name=" + this.name + ", frameBufferSizeBytes=" + this.frameBufferSizeBytes + ", numVirtualDisplayHeads=" + this.numVirtualDisplayHeads + ", fraction=" + this.fraction + ")";
        }
    }
}

