/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.iam.java.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.nutanix.iam.java.client.RFC3339DateFormat;
import com.nutanix.iam.java.client.auth.ApiKeyAuth;
import com.nutanix.iam.java.client.auth.Authentication;
import com.nutanix.iam.java.client.auth.HttpBasicAuth;
import com.nutanix.json.deserializers.ObjectTypeTypedObject;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.ParseException;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.FixedBackOffPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StreamUtils;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Component(value="com.nutanix.iam.java.client.ApiClient")
public class ApiClient {
    private static final Logger log = LoggerFactory.getLogger(ApiClient.class);
    private final int MAX_RETRY = 5;
    private final int RETRY_DELAY = 3000;
    private final long DEFAULT_READ_TIMEOUT = 30000L;
    private final long DEFAULT_CONNECT_TIMEOUT = 30000L;
    private final long MAX_DEFAULT_TIMEOUT = 10800000L;
    private boolean debugging = false;
    private HttpHeaders defaultHeaders = new HttpHeaders();
    private String cookie;
    private boolean refreshCookie = true;
    private String scheme = "https";
    private String host = "localhost";
    private int port = 9440;
    private RestTemplate restTemplate;
    private RetryTemplate retryTemplate;
    private int maxRetryAttempts = 5;
    private int retryInterval = 3000;
    private long readTimeout = 30000L;
    private long connectTimeout = 30000L;
    private Map<String, Authentication> authentications;
    private HttpStatus statusCode;
    private MultiValueMap<String, String> responseHeaders;
    private DateFormat dateFormat;
    private String downloadDirectory = Paths.get("", new String[0]).toAbsolutePath().toString();
    private final Set<String> binaryMediaTypes = new HashSet<String>(Arrays.asList("application/octet-stream", "application/pdf", "application/zip"));
    private final Set<String> textMediaTypes = new HashSet<String>(Arrays.asList("text/event-stream", "text/html", "text/xml", "text/csv", "text/javascript", "text/markdown", "text/vcard"));
    private boolean verifySsl = true;
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public ApiClient() {
        this.restTemplate = this.buildRestTemplate();
        this.retryTemplate = this.buildRetryTemplate();
        this.init();
    }

    @Autowired
    public ApiClient(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
        this.retryTemplate = this.buildRetryTemplate();
        this.init();
    }

    private void init() {
        this.dateFormat = new RFC3339DateFormat();
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.addDefaultHeader("User-Agent", "Nutanix-iam-java-client/4.0.1");
        this.authentications = new HashMap<String, Authentication>();
        this.authentications.put("apiKeyAuthScheme", new ApiKeyAuth("header", "X-ntnx-api-key"));
        this.authentications.put("basicAuthScheme", new HttpBasicAuth());
        this.authentications = Collections.unmodifiableMap(this.authentications);
    }

    public ApiClient setVerifySsl(boolean verifySsl) throws KeyStoreException, NoSuchAlgorithmException {
        this.verifySsl = verifySsl;
        this.restTemplate = this.buildRestTemplate();
        return this;
    }

    public String getScheme() {
        return this.scheme;
    }

    public ApiClient setScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public ApiClient setHost(String host) {
        this.host = host;
        return this;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public ApiClient setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
        this.restTemplate = this.buildRestTemplate();
        return this;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public ApiClient setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
        this.restTemplate = this.buildRestTemplate();
        return this;
    }

    private long getValidTimeout(long timeout, long defaultTimeout) {
        if (timeout <= 0L) {
            timeout = defaultTimeout;
        } else if (timeout > 10800000L) {
            timeout = 10800000L;
        }
        return timeout;
    }

    public int getPort() {
        return this.port;
    }

    public ApiClient setPort(int port) {
        this.port = port;
        return this;
    }

    public int getMaxRetryAttempts() {
        return this.maxRetryAttempts;
    }

    public ApiClient setMaxRetryAttempts(int maxRetryAttempts) {
        this.maxRetryAttempts = maxRetryAttempts;
        this.retryTemplate = this.buildRetryTemplate();
        return this;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public ApiClient setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
        this.retryTemplate = this.buildRetryTemplate();
        return this;
    }

    public void setDownloadDirectory(String path) {
        this.downloadDirectory = path;
    }

    public HttpStatus getStatusCode() {
        return this.statusCode;
    }

    public MultiValueMap<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public Map<String, Authentication> getAuthentications() {
        return this.authentications;
    }

    public Authentication getAuthentication(String authName) {
        return this.authentications.get(authName);
    }

    public void setApiKey(String apiKey) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)auth).setApiKey(apiKey);
            return;
        }
        throw new RuntimeException("No API key authentication is configured!");
    }

    public void setApiKeyPrefix(String apiKeyPrefix) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)auth).setApiKeyPrefix(apiKeyPrefix);
            return;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public void setUsername(String username) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)auth).setUsername(username);
            return;
        }
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public void setPassword(String password) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)auth).setPassword(password);
            return;
        }
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public ApiClient addDefaultHeader(String name, String value) {
        if ("Authorization".equals(name)) {
            this.cookie = null;
        }
        this.defaultHeaders.add(name, value);
        if (!"Authorization".equals(name)) {
            log.info("Default header {}:{} added to the api client", (Object)name, (Object)value);
        }
        return this;
    }

    public void setDebugging(boolean debugging) {
        ArrayList<ApiClientHttpRequestInterceptor> currentInterceptors = this.restTemplate.getInterceptors();
        if (debugging) {
            if (currentInterceptors == null) {
                currentInterceptors = new ArrayList<ApiClientHttpRequestInterceptor>();
            }
            ApiClientHttpRequestInterceptor interceptor = new ApiClientHttpRequestInterceptor();
            currentInterceptors.add(interceptor);
            this.restTemplate.setInterceptors(currentInterceptors);
        } else if (currentInterceptors != null && !currentInterceptors.isEmpty()) {
            Iterator iter = currentInterceptors.iterator();
            while (iter.hasNext()) {
                ClientHttpRequestInterceptor interceptor = (ClientHttpRequestInterceptor)iter.next();
                if (!(interceptor instanceof ApiClientHttpRequestInterceptor)) continue;
                iter.remove();
            }
            this.restTemplate.setInterceptors(currentInterceptors);
        }
        this.debugging = debugging;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public ApiClient setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }

    public Date parseDate(String str) {
        try {
            return this.dateFormat.parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String formatDate(Date date) {
        return this.dateFormat.format(date);
    }

    public String formatOffsetDateTime(OffsetDateTime dateTime) {
        DateTimeFormatter ISO_8601_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").withZone(ZoneId.of("UTC"));
        if (dateTime.getOffset().equals(ZoneOffset.UTC)) {
            return ISO_8601_FORMATTER.format(dateTime);
        }
        return dateTime.toString();
    }

    public String parameterToString(Object param) {
        if (param == null) {
            return "";
        }
        if (param instanceof OffsetDateTime) {
            return this.formatOffsetDateTime((OffsetDateTime)param);
        }
        if (param instanceof Date) {
            return this.formatDate((Date)param);
        }
        if (param instanceof Collection) {
            StringBuilder b = new StringBuilder();
            for (Object o : (Collection)param) {
                if (b.length() > 0) {
                    b.append(",");
                }
                b.append(String.valueOf(o));
            }
            return b.toString();
        }
        return String.valueOf(param);
    }

    public MultiValueMap<String, String> parameterToMultiValueMap(CollectionFormat collectionFormat, String name, Object value) {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        if (name == null || name.isEmpty() || value == null) {
            return params;
        }
        if (collectionFormat == null) {
            collectionFormat = CollectionFormat.CSV;
        }
        Collection valueCollection = null;
        if (!(value instanceof Collection)) {
            params.add((Object)name, (Object)this.parameterToString(value));
            return params;
        }
        valueCollection = (Collection)value;
        if (valueCollection.isEmpty()) {
            return params;
        }
        if (collectionFormat.equals((Object)CollectionFormat.MULTI)) {
            for (Object item : valueCollection) {
                params.add((Object)name, (Object)this.parameterToString(item));
            }
            return params;
        }
        ArrayList<String> values = new ArrayList<String>();
        for (Object o : valueCollection) {
            values.add(this.parameterToString(o));
        }
        params.add((Object)name, (Object)collectionFormat.collectionToString(values));
        return params;
    }

    public boolean isJsonMime(String mediaType) {
        if ("*/*".equals(mediaType)) {
            return true;
        }
        try {
            return this.isJsonMime(MediaType.parseMediaType((String)mediaType));
        }
        catch (InvalidMediaTypeException invalidMediaTypeException) {
            return false;
        }
    }

    public boolean isJsonMime(MediaType mediaType) {
        return mediaType != null && (MediaType.APPLICATION_JSON.isCompatibleWith(mediaType) || mediaType.getSubtype().matches("^.*\\+json[;]?\\s*$"));
    }

    public List<MediaType> selectHeaderAccept(String[] accepts) {
        if (accepts.length == 0) {
            return null;
        }
        return MediaType.parseMediaTypes((String)StringUtils.join((Object[])accepts, (String)","));
    }

    public MediaType selectHeaderContentType(String[] contentTypes) {
        if (contentTypes.length == 0) {
            return MediaType.APPLICATION_JSON;
        }
        for (String contentType : contentTypes) {
            MediaType mediaType = MediaType.parseMediaType((String)contentType);
            if (!this.isJsonMime(mediaType)) continue;
            return mediaType;
        }
        return MediaType.parseMediaType((String)contentTypes[0]);
    }

    protected Object selectBody(Object obj, MultiValueMap<String, Object> formParams, MediaType contentType) {
        boolean isForm = MediaType.MULTIPART_FORM_DATA.isCompatibleWith(contentType) || MediaType.APPLICATION_FORM_URLENCODED.isCompatibleWith(contentType);
        return isForm ? formParams : obj;
    }

    public <T> T invokeAPI(String path, HttpMethod method, MultiValueMap<String, String> queryParams, Object body, HttpHeaders headerParams, MultiValueMap<String, Object> formParams, List<MediaType> accept, MediaType contentType, String[] authNames, ParameterizedTypeReference<T> returnType) throws RestClientException {
        try {
            return this.invokeAPIInternal(path, method, queryParams, body, headerParams, formParams, accept, contentType, authNames, returnType);
        }
        catch (HttpClientErrorException e) {
            if (e.getStatusCode().equals((Object)HttpStatus.UNAUTHORIZED)) {
                log.error("Server responded with 401 status due to {message}.", (Object)e.getMessage());
                this.cookie = null;
                this.refreshCookie = true;
                log.debug("Retrying request with basic header as server responded with 401 status due to cookie expiration.");
                return this.invokeAPIInternal(path, method, queryParams, body, headerParams, formParams, accept, contentType, authNames, returnType);
            }
            log.error("Unable to make a successful request", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("Unable to make a successful request", (Throwable)e);
            throw e;
        }
    }

    private <T> T invokeAPIInternal(String path, HttpMethod method, MultiValueMap<String, String> queryParams, Object body, HttpHeaders headerParams, MultiValueMap<String, Object> formParams, List<MediaType> accept, MediaType contentType, String[] authNames, ParameterizedTypeReference<T> returnType) throws RestClientException {
        UriComponentsBuilder builder = UriComponentsBuilder.newInstance().scheme(this.scheme).host(this.host).port(this.port).path(path);
        if (queryParams != null) {
            builder.queryParams(queryParams);
        }
        RequestEntity.BodyBuilder requestBuilder = RequestEntity.method((HttpMethod)method, (URI)builder.build().toUri());
        if (accept != null && !headerParams.containsKey((Object)"Accept")) {
            requestBuilder.accept(accept.toArray(new MediaType[accept.size()]));
        }
        if (contentType != null && !headerParams.containsKey((Object)"Content-Type")) {
            requestBuilder.contentType(contentType);
        }
        if (this.defaultHeaders.getOrDefault((Object)"NTNX-Request-Id", null) == null && headerParams.getOrDefault((Object)"NTNX-Request-Id", null) == null) {
            UUID generatedID = UUID.randomUUID();
            headerParams.add("NTNX-Request-Id", String.valueOf(generatedID));
        }
        if (!headerParams.containsKey((Object)"If-Match")) {
            this.addEtagReferenceToHeader(body, requestBuilder);
        }
        headerParams.putAll((Map)this.defaultHeaders);
        if (this.cookie != null) {
            requestBuilder.header("Cookie", new String[]{this.cookie});
            if (headerParams.containsKey((Object)"Authorization")) {
                headerParams.remove((Object)"Authorization");
            }
        } else {
            this.updateParamsForAuth(authNames, queryParams, headerParams);
        }
        this.addHeadersToRequest(headerParams, requestBuilder);
        RequestEntity requestEntity = requestBuilder.body(this.selectBody(body, formParams, contentType));
        return this.sendRequest((RequestEntity<Object>)requestEntity, returnType);
    }

    private <T> T sendRequest(RequestEntity<Object> requestEntity, ParameterizedTypeReference<T> returnType) {
        List<HttpStatus> retryStatusList = Arrays.asList(HttpStatus.SERVICE_UNAVAILABLE, HttpStatus.GATEWAY_TIMEOUT, HttpStatus.REQUEST_TIMEOUT, HttpStatus.TOO_MANY_REQUESTS);
        AtomicReference body = new AtomicReference();
        this.retryTemplate.execute(context -> {
            try {
                this.restTemplate.getMessageConverters().removeIf(element -> element instanceof CustomTextHttpMessageConverter);
                this.restTemplate.getMessageConverters().add(new CustomTextHttpMessageConverter(returnType, this.textMediaTypes));
                ResponseEntity responseEntity = this.restTemplate.exchange(requestEntity, returnType);
                this.statusCode = responseEntity.getStatusCode();
                responseEntity = this.handleRedirection(responseEntity, requestEntity, returnType, body);
                if (responseEntity.getBody() instanceof OneOfBinaryResponseWrapper) {
                    OneOfBinaryResponseWrapper responseWrapper = (OneOfBinaryResponseWrapper)responseEntity.getBody();
                    responseWrapper.setResponseEntity(responseEntity);
                    body.set(responseWrapper);
                } else {
                    body.set(this.getResponseBody(responseEntity, returnType));
                }
            }
            catch (HttpStatusCodeException e) {
                if (!retryStatusList.contains(e.getStatusCode())) {
                    context.setExhaustedOnly();
                }
                log.error("Unable to make a successful request", (Throwable)e);
                throw e;
            }
            return null;
        });
        return (T)body.get();
    }

    private <T> ResponseEntity<T> handleRedirection(ResponseEntity<T> responseEntity, RequestEntity<Object> originalRequestEntity, ParameterizedTypeReference<T> returnType, AtomicReference<T> body) {
        if (this.statusCode.is3xxRedirection() && responseEntity.getHeaders() != null && responseEntity.getHeaders().getLocation() != null) {
            String location = responseEntity.getHeaders().getLocation().toString();
            log.info("Redirecting to {}", (Object)location);
            UriComponentsBuilder.newInstance();
            UriComponentsBuilder builder = UriComponentsBuilder.fromPath((String)location);
            builder.query(originalRequestEntity.getUrl().getQuery());
            RequestEntity.BodyBuilder requestBuilder = RequestEntity.method((HttpMethod)originalRequestEntity.getMethod(), (String)location, (Object[])new Object[0]);
            requestBuilder.body(originalRequestEntity.getBody());
            if (responseEntity.getHeaders().containsKey((Object)"X-Redirect-Token")) {
                log.info("Populating X-Redirect-Token header to Cookie");
                String cookie = responseEntity.getHeaders().get((Object)"X-Redirect-Token").toString();
                requestBuilder.header("Cookie", new String[]{cookie});
            }
            requestBuilder.headers(originalRequestEntity.getHeaders());
            responseEntity = this.restTemplate.exchange(requestBuilder.build(), returnType);
            this.statusCode = responseEntity.getStatusCode();
            log.debug("Redirected response status code: {}", (Object)this.statusCode);
        }
        return responseEntity;
    }

    public Map<String, Object> getFileDownloadResponse(Resource resource, HttpHeaders headers) throws IOException {
        String filename = String.format("downloaded_file_%s", System.currentTimeMillis());
        if (headers.containsKey((Object)"Content-Disposition")) {
            String contentDisposition = (String)headers.get((Object)"Content-Disposition").get(0);
            filename = contentDisposition.replaceFirst(".*filename=\\\"?([^\\\"]+)\\\"?.*", "$1");
            int index = filename.lastIndexOf(46);
            filename = String.format("%s_%s%s", filename.substring(0, index), System.currentTimeMillis(), filename.substring(index));
        } else {
            log.warn("{} header is missing, downloading file to {}", (Object)"Content-Disposition", (Object)filename);
        }
        Path path = Paths.get(this.downloadDirectory, filename);
        StreamUtils.copy((InputStream)resource.getInputStream(), (OutputStream)new FileOutputStream(path.toFile()));
        HashMap<String, Object> retVal = new HashMap<String, Object>();
        retVal.put("path", path);
        retVal.put("$objectType", path.getClass());
        return retVal;
    }

    public <T> T getResponseBody(ResponseEntity<T> responseEntity, ParameterizedTypeReference<T> returnType) {
        List responseCookies = responseEntity.getHeaders().get((Object)"Set-Cookie");
        if (this.refreshCookie && responseCookies != null && this.cookie == null) {
            StringBuilder sb = new StringBuilder();
            for (String responseCookie : responseCookies) {
                sb.append(responseCookie.split(";")[0]).append(";");
            }
            sb.deleteCharAt(sb.length() - 1);
            this.cookie = sb.toString();
            this.refreshCookie = false;
        }
        if (responseEntity.getStatusCode() == HttpStatus.NO_CONTENT) {
            return null;
        }
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            if (returnType == null) {
                return null;
            }
            if (responseEntity.getHeaders().getOrDefault((Object)"ETag", null) != null && responseEntity.getBody() instanceof ObjectTypeTypedObject) {
                ((ObjectTypeTypedObject)responseEntity.getBody()).get$reserved().put("ETag", responseEntity.getHeaders().get((Object)"ETag").get(0));
            }
            return (T)responseEntity.getBody();
        }
        this.cookie = null;
        String message = "API returned " + this.statusCode + " and it wasn't handled by the RestTemplate error handler";
        log.error(message);
        throw new RestClientException(message);
    }

    private void addEtagReferenceToHeader(Object body, RequestEntity.BodyBuilder requestBuilder) {
        ObjectTypeTypedObject bodyInstance;
        Map<String, Object> reservedFields;
        if (body instanceof ObjectTypeTypedObject && MapUtils.isNotEmpty(reservedFields = (bodyInstance = (ObjectTypeTypedObject)body).get$reserved()) && reservedFields.containsKey("ETag")) {
            String etagReference = String.valueOf(reservedFields.get("ETag"));
            requestBuilder.header("If-Match", new String[]{etagReference});
        }
    }

    public static String getEtag(Object object) {
        ObjectTypeTypedObject typedObject;
        String etag = null;
        if (object != null && object instanceof ObjectTypeTypedObject && MapUtils.isNotEmpty((typedObject = (ObjectTypeTypedObject)object).get$reserved())) {
            Optional<Map.Entry> etagEntry = typedObject.get$reserved().entrySet().stream().filter(x -> "ETag".toLowerCase().equals(((String)x.getKey()).toLowerCase())).findFirst();
            etag = etagEntry.isPresent() ? (String)etagEntry.get().getValue() : null;
        }
        return etag;
    }

    private void addHeadersToRequest(HttpHeaders headers, RequestEntity.BodyBuilder requestBuilder) {
        for (Map.Entry entry : headers.entrySet()) {
            List values = (List)entry.getValue();
            for (String value : values) {
                if (value == null) continue;
                requestBuilder.header((String)entry.getKey(), new String[]{value});
            }
        }
    }

    private RestTemplate buildRestTemplate() {
        RestTemplateBuilder restTemplateBuilder = new RestTemplateBuilder(new RestTemplateCustomizer[0]);
        if (!this.verifySsl) {
            try {
                TrustStrategy acceptingTrustStrategy = (chain, authType) -> true;
                SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)acceptingTrustStrategy).build();
                SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)new NoopHostnameVerifier());
                CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).disableCookieManagement().disableRedirectHandling().build();
                restTemplateBuilder = restTemplateBuilder.requestFactory(() -> new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient));
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                String message = "Cannot disable SSL Verification, perform setVerifySsl(true) or retry";
                log.error(message, (Throwable)e);
                throw new RestClientException(message, (Throwable)e);
            }
        } else {
            restTemplateBuilder = restTemplateBuilder.requestFactory(() -> ((RestTemplateBuilder)restTemplateBuilder).buildRequestFactory());
        }
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
        OBJECT_MAPPER.configure(MapperFeature.DEFAULT_VIEW_INCLUSION, true);
        OBJECT_MAPPER.setDefaultPropertyInclusion(JsonInclude.Include.NON_EMPTY);
        OBJECT_MAPPER.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        MappingJackson2HttpMessageConverter jacksonConverter = new MappingJackson2HttpMessageConverter(OBJECT_MAPPER);
        ResourceHttpMessageConverter resourceConverter = new ResourceHttpMessageConverter();
        CustomBinaryResponseMessageConverter customBinaryResponseConverter = new CustomBinaryResponseMessageConverter(jacksonConverter, resourceConverter, this.binaryMediaTypes);
        restTemplateBuilder = restTemplateBuilder.additionalMessageConverters(new HttpMessageConverter[]{jacksonConverter}).additionalMessageConverters(new HttpMessageConverter[]{resourceConverter});
        Duration readTimeoutDuration = Duration.ofMillis(this.getValidTimeout(this.readTimeout, 30000L));
        Duration connectTimeoutDuration = Duration.ofMillis(this.getValidTimeout(this.connectTimeout, 30000L));
        restTemplateBuilder = restTemplateBuilder.setConnectTimeout(connectTimeoutDuration).setReadTimeout(readTimeoutDuration);
        RestTemplate restTemplate = restTemplateBuilder.build();
        restTemplate.getMessageConverters().add(0, customBinaryResponseConverter);
        return restTemplate;
    }

    private RetryTemplate buildRetryTemplate() {
        SimpleRetryPolicy retryPolicy = new SimpleRetryPolicy();
        retryPolicy.setMaxAttempts(this.maxRetryAttempts);
        FixedBackOffPolicy backOffPolicy = new FixedBackOffPolicy();
        backOffPolicy.setBackOffPeriod((long)this.retryInterval);
        RetryTemplate template = new RetryTemplate();
        template.setRetryPolicy((RetryPolicy)retryPolicy);
        template.setBackOffPolicy((BackOffPolicy)backOffPolicy);
        return template;
    }

    private void updateParamsForAuth(String[] authNames, MultiValueMap<String, String> queryParams, HttpHeaders headerParams) {
        for (String authName : authNames) {
            Authentication auth = this.authentications.get(authName);
            if (auth == null) {
                log.error("Authentication undefined: {}", (Object)authName);
                throw new RestClientException("Authentication undefined: " + authName);
            }
            auth.applyToParams(queryParams, headerParams);
        }
    }

    public static class OneOfBinaryResponseWrapper {
        private String jsonObject;
        private Resource resourceObject;
        private boolean isBinary;
        private ResponseEntity responseEntity;

        public String getJsonObject() {
            return this.jsonObject;
        }

        public Resource getResourceObject() {
            return this.resourceObject;
        }

        public boolean isBinary() {
            return this.isBinary;
        }

        public ResponseEntity getResponseEntity() {
            return this.responseEntity;
        }

        public void setJsonObject(String jsonObject) {
            this.jsonObject = jsonObject;
        }

        public void setResourceObject(Resource resourceObject) {
            this.resourceObject = resourceObject;
        }

        public void setBinary(boolean isBinary) {
            this.isBinary = isBinary;
        }

        public void setResponseEntity(ResponseEntity responseEntity) {
            this.responseEntity = responseEntity;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OneOfBinaryResponseWrapper)) {
                return false;
            }
            OneOfBinaryResponseWrapper other = (OneOfBinaryResponseWrapper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$jsonObject = this.getJsonObject();
            String other$jsonObject = other.getJsonObject();
            if (this$jsonObject == null ? other$jsonObject != null : !this$jsonObject.equals(other$jsonObject)) {
                return false;
            }
            Resource this$resourceObject = this.getResourceObject();
            Resource other$resourceObject = other.getResourceObject();
            if (this$resourceObject == null ? other$resourceObject != null : !this$resourceObject.equals(other$resourceObject)) {
                return false;
            }
            if (this.isBinary() != other.isBinary()) {
                return false;
            }
            ResponseEntity this$responseEntity = this.getResponseEntity();
            ResponseEntity other$responseEntity = other.getResponseEntity();
            return !(this$responseEntity == null ? other$responseEntity != null : !this$responseEntity.equals(other$responseEntity));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OneOfBinaryResponseWrapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $jsonObject = this.getJsonObject();
            result = result * 59 + ($jsonObject == null ? 43 : $jsonObject.hashCode());
            Resource $resourceObject = this.getResourceObject();
            result = result * 59 + ($resourceObject == null ? 43 : $resourceObject.hashCode());
            result = result * 59 + (this.isBinary() ? 79 : 97);
            ResponseEntity $responseEntity = this.getResponseEntity();
            result = result * 59 + ($responseEntity == null ? 43 : $responseEntity.hashCode());
            return result;
        }

        public String toString() {
            return "ApiClient.OneOfBinaryResponseWrapper(jsonObject=" + this.getJsonObject() + ", resourceObject=" + this.getResourceObject() + ", isBinary=" + this.isBinary() + ", responseEntity=" + this.getResponseEntity() + ")";
        }

        public OneOfBinaryResponseWrapper(String jsonObject, Resource resourceObject, boolean isBinary, ResponseEntity responseEntity) {
            this.jsonObject = jsonObject;
            this.resourceObject = resourceObject;
            this.isBinary = isBinary;
            this.responseEntity = responseEntity;
        }
    }

    public static class CustomTextHttpMessageConverter<T>
    extends AbstractHttpMessageConverter<T> {
        private final Class<T> clazz;

        public CustomTextHttpMessageConverter(ParameterizedTypeReference<T> typeRef, Set<String> supportedTextMediaTypes) {
            List supportedMediaTypes = supportedTextMediaTypes.stream().map(type -> MediaType.parseMediaType((String)type)).collect(Collectors.toList());
            this.setSupportedMediaTypes(supportedMediaTypes);
            this.clazz = (Class)typeRef.getType();
        }

        protected boolean supports(Class<?> clazz) {
            return clazz.isAssignableFrom(this.clazz);
        }

        protected T readInternal(Class<? extends T> clazz, HttpInputMessage inputMessage) throws IOException {
            try {
                byte[] textData = this.readBytesFromBody(inputMessage.getBody());
                T instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Method setDataMethod = instance.getClass().getMethod("setDataInWrapper", Object.class);
                setDataMethod.invoke(instance, new Object[]{textData});
                return instance;
            }
            catch (Exception e) {
                throw new IOException("Error reading text data", e);
            }
        }

        protected void writeInternal(T t, HttpOutputMessage outputMessage) throws IOException {
        }

        /*
         * Exception decompiling
         */
        private byte[] readBytesFromBody(InputStream body) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    public static class CustomBinaryResponseMessageConverter
    extends AbstractHttpMessageConverter<OneOfBinaryResponseWrapper> {
        private static final Logger log = LoggerFactory.getLogger(CustomBinaryResponseMessageConverter.class);
        private final MappingJackson2HttpMessageConverter jackson2HttpMessageConverter;
        private final ResourceHttpMessageConverter resourceHttpMessageConverter;
        private final Set<String> supportedBinaryMediaTypes;

        public CustomBinaryResponseMessageConverter(MappingJackson2HttpMessageConverter jackson2HttpMessageConverter, ResourceHttpMessageConverter resourceHttpMessageConverter, Set<String> supportedBinaryMediaTypes) {
            this.jackson2HttpMessageConverter = jackson2HttpMessageConverter;
            this.resourceHttpMessageConverter = resourceHttpMessageConverter;
            this.supportedBinaryMediaTypes = supportedBinaryMediaTypes;
            List supportedMediaTypes = supportedBinaryMediaTypes.stream().map(type -> MediaType.parseMediaType((String)type)).collect(Collectors.toList());
            supportedMediaTypes.add(MediaType.APPLICATION_JSON);
            this.setSupportedMediaTypes(supportedMediaTypes);
        }

        protected boolean supports(Class<?> clazz) {
            return OneOfBinaryResponseWrapper.class.equals(clazz);
        }

        protected OneOfBinaryResponseWrapper readInternal(Class<? extends OneOfBinaryResponseWrapper> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
            String contentType;
            String string = contentType = CollectionUtils.isNotEmpty((Collection)inputMessage.getHeaders().get((Object)"Content-Type")) ? (String)inputMessage.getHeaders().get((Object)"Content-Type").get(0) : null;
            if (this.supportedBinaryMediaTypes.contains(contentType)) {
                Resource resource = (Resource)this.resourceHttpMessageConverter.read(Resource.class, inputMessage);
                return new OneOfBinaryResponseWrapper(null, resource, true, null);
            }
            if ("application/json".equals(contentType)) {
                String jsonObject = StreamUtils.copyToString((InputStream)inputMessage.getBody(), (Charset)StandardCharsets.UTF_8);
                return new OneOfBinaryResponseWrapper(jsonObject, null, false, null);
            }
            return null;
        }

        protected void writeInternal(OneOfBinaryResponseWrapper oneOfBinaryResponseWrapper, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        }
    }

    private static class ApiClientHttpRequestInterceptor
    implements ClientHttpRequestInterceptor {
        private static final Logger log = LoggerFactory.getLogger(ApiClientHttpRequestInterceptor.class);

        private ApiClientHttpRequestInterceptor() {
        }

        public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
            this.logRequest(request, body);
            ClientHttpResponse response = execution.execute(request, body);
            response = new BufferedClientHttpResponse(response);
            this.logResponse(response);
            return response;
        }

        private void logRequest(HttpRequest request, byte[] body) throws UnsupportedEncodingException {
            log.info("{} {}", (Object)request.getMethod(), (Object)request.getURI());
            log.debug("Request Headers:\n{}", (Object)this.headersToString(request.getHeaders()));
            if (this.isOctetStream(request.getHeaders())) {
                log.debug("Request Body is an octet stream");
            } else {
                log.debug("Request Body:\n{}", (Object)new String(body, StandardCharsets.UTF_8));
            }
        }

        private void logResponse(ClientHttpResponse response) throws IOException {
            log.info("Reply: {} {}", (Object)response.getRawStatusCode(), (Object)response.getStatusText());
            log.debug("Response Headers:\n{}", (Object)this.headersToString(response.getHeaders()));
            if (this.isOctetStream(response.getHeaders())) {
                log.debug("Response Body is an octet stream");
            } else {
                log.debug("Response Body:\n{}", (Object)this.bodyToString(response.getBody()));
            }
        }

        private boolean isOctetStream(HttpHeaders headers) {
            return headers != null && headers.containsKey((Object)"Content-Type") && headers.get((Object)"Content-Type").stream().anyMatch(content -> content.toString().equals("application/octet-stream"));
        }

        private String headersToString(HttpHeaders headers) {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry entry : headers.entrySet()) {
                builder.append((String)entry.getKey()).append("=[");
                for (String value : (List)entry.getValue()) {
                    builder.append(value).append(",");
                }
                builder.setLength(builder.length() - 1);
                builder.append("]\n");
            }
            builder.setLength(builder.length() - 1);
            return builder.toString();
        }

        private String bodyToString(InputStream body) throws IOException {
            StringBuilder builder = new StringBuilder();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(body, StandardCharsets.UTF_8));
            String line = bufferedReader.readLine();
            while (line != null) {
                builder.append(line).append(System.lineSeparator());
                line = bufferedReader.readLine();
            }
            bufferedReader.close();
            return builder.toString();
        }

        private class BufferedClientHttpResponse
        implements ClientHttpResponse {
            private final ClientHttpResponse response;
            private byte[] body;

            public BufferedClientHttpResponse(ClientHttpResponse response) {
                this.response = response;
            }

            public HttpStatus getStatusCode() throws IOException {
                return this.response.getStatusCode();
            }

            public int getRawStatusCode() throws IOException {
                return this.response.getRawStatusCode();
            }

            public String getStatusText() throws IOException {
                return this.response.getStatusText();
            }

            public void close() {
                this.response.close();
            }

            public HttpHeaders getHeaders() {
                return this.response.getHeaders();
            }

            public InputStream getBody() throws IOException {
                if (this.body == null) {
                    this.body = StreamUtils.copyToByteArray((InputStream)this.response.getBody());
                }
                return new ByteArrayInputStream(this.body);
            }
        }
    }

    public static enum CollectionFormat {
        CSV(","),
        TSV("\t"),
        SSV(" "),
        PIPES("|"),
        MULTI(null);

        private final String separator;

        private CollectionFormat(String separator) {
            this.separator = separator;
        }

        private String collectionToString(Collection<? extends CharSequence> collection) {
            return collection == null ? "" : StringUtils.join(collection, (String)this.separator);
        }
    }
}

