/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.iam.iam.v4.authz;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.iam.common.v1.response.ApiLink;
import com.nutanix.dp1.iam.deserializers.IamObjectTypeTypedObject;
import com.nutanix.dp1.iam.iam.v4.authz.BaseRole;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Role
extends BaseRole
implements Serializable,
IamObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(Role.class);
    @Size(min=0, max=50)
    private @Size(min=0, max=50) List<String> accessibleClients = null;
    @Size(min=0, max=500)
    private @Size(min=0, max=500) List<String> accessibleEntityTypes = null;
    private Integer accessibleClientsCount = null;
    private Integer accessibleEntityTypesCount = null;
    private Long assignedUsersCount = null;
    private Long assignedUserGroupsCount = null;
    private OffsetDateTime createdTime = null;
    private OffsetDateTime lastUpdatedTime = null;
    private String createdBy = null;
    private Boolean isSystemDefined = true;
    @Pattern(regexp="^[^<>;()&+%/\\\\\"`]*$")
    @Size(max=1000)
    @JsonProperty(value="description")
    public @Pattern(regexp="^[^<>;()&+%/\\\\\"`]*$") @Size(max=1000) String description = null;
    @Size(min=1, max=2000)
    @JsonProperty(value="operations")
    public @Size(min=1, max=2000) List<String> operations = null;

    public Role() {
    }

    public Role(String tenantId, String extId, List<ApiLink> links, String displayName, String clientName, String description, List<String> operations, List<String> accessibleClients, List<String> accessibleEntityTypes, Integer accessibleClientsCount, Integer accessibleEntityTypesCount, Long assignedUsersCount, Long assignedUserGroupsCount, OffsetDateTime createdTime, OffsetDateTime lastUpdatedTime, String createdBy, Boolean isSystemDefined) {
        super(tenantId, extId, links, displayName, clientName);
        this.setDescription(description);
        this.setOperations(operations);
        this.setAccessibleClients(accessibleClients);
        this.setAccessibleEntityTypes(accessibleEntityTypes);
        this.setAccessibleClientsCount(accessibleClientsCount);
        this.setAccessibleEntityTypesCount(accessibleEntityTypesCount);
        this.setAssignedUsersCount(assignedUsersCount);
        this.setAssignedUserGroupsCount(assignedUserGroupsCount);
        this.setCreatedTime(createdTime);
        this.setLastUpdatedTime(lastUpdatedTime);
        this.setCreatedBy(createdBy);
        this.setIsSystemDefined(isSystemDefined);
    }

    @Override
    protected String initialize$objectType() {
        return "iam.v4.authz.Role";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setAccessibleClients(List<String> accessibleClients) {
        if (this.accessibleClients == null) {
            this.accessibleClients = accessibleClients;
        } else {
            log.warn("Read-only property accessibleClients already contains a non-null value and cannot be set again");
        }
    }

    public void setAccessibleEntityTypes(List<String> accessibleEntityTypes) {
        if (this.accessibleEntityTypes == null) {
            this.accessibleEntityTypes = accessibleEntityTypes;
        } else {
            log.warn("Read-only property accessibleEntityTypes already contains a non-null value and cannot be set again");
        }
    }

    public void setAccessibleClientsCount(Integer accessibleClientsCount) {
        if (this.accessibleClientsCount == null) {
            this.accessibleClientsCount = accessibleClientsCount;
        } else {
            log.warn("Read-only property accessibleClientsCount already contains a non-null value and cannot be set again");
        }
    }

    public void setAccessibleEntityTypesCount(Integer accessibleEntityTypesCount) {
        if (this.accessibleEntityTypesCount == null) {
            this.accessibleEntityTypesCount = accessibleEntityTypesCount;
        } else {
            log.warn("Read-only property accessibleEntityTypesCount already contains a non-null value and cannot be set again");
        }
    }

    public void setAssignedUsersCount(Long assignedUsersCount) {
        if (this.assignedUsersCount == null) {
            this.assignedUsersCount = assignedUsersCount;
        } else {
            log.warn("Read-only property assignedUsersCount already contains a non-null value and cannot be set again");
        }
    }

    public void setAssignedUserGroupsCount(Long assignedUserGroupsCount) {
        if (this.assignedUserGroupsCount == null) {
            this.assignedUserGroupsCount = assignedUserGroupsCount;
        } else {
            log.warn("Read-only property assignedUserGroupsCount already contains a non-null value and cannot be set again");
        }
    }

    public void setCreatedTime(OffsetDateTime createdTime) {
        if (this.createdTime == null) {
            this.createdTime = createdTime;
        } else {
            log.warn("Read-only property createdTime already contains a non-null value and cannot be set again");
        }
    }

    public void setLastUpdatedTime(OffsetDateTime lastUpdatedTime) {
        if (this.lastUpdatedTime == null) {
            this.lastUpdatedTime = lastUpdatedTime;
        } else {
            log.warn("Read-only property lastUpdatedTime already contains a non-null value and cannot be set again");
        }
    }

    public void setCreatedBy(String createdBy) {
        if (this.createdBy == null) {
            this.createdBy = createdBy;
        } else {
            log.warn("Read-only property createdBy already contains a non-null value and cannot be set again");
        }
    }

    public void setIsSystemDefined(Boolean isSystemDefined) {
        if (this.isSystemDefined == null) {
            this.isSystemDefined = isSystemDefined;
        } else {
            log.warn("Read-only property isSystemDefined already contains a non-null value and cannot be set again");
        }
    }

    public static RoleBuilder RoleBuilder() {
        return new RoleBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Role)) {
            return false;
        }
        Role other = (Role)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$accessibleClients = this.getAccessibleClients();
        List<String> other$accessibleClients = other.getAccessibleClients();
        if (this$accessibleClients == null ? other$accessibleClients != null : !((Object)this$accessibleClients).equals(other$accessibleClients)) {
            return false;
        }
        List<String> this$accessibleEntityTypes = this.getAccessibleEntityTypes();
        List<String> other$accessibleEntityTypes = other.getAccessibleEntityTypes();
        if (this$accessibleEntityTypes == null ? other$accessibleEntityTypes != null : !((Object)this$accessibleEntityTypes).equals(other$accessibleEntityTypes)) {
            return false;
        }
        Integer this$accessibleClientsCount = this.getAccessibleClientsCount();
        Integer other$accessibleClientsCount = other.getAccessibleClientsCount();
        if (this$accessibleClientsCount == null ? other$accessibleClientsCount != null : !((Object)this$accessibleClientsCount).equals(other$accessibleClientsCount)) {
            return false;
        }
        Integer this$accessibleEntityTypesCount = this.getAccessibleEntityTypesCount();
        Integer other$accessibleEntityTypesCount = other.getAccessibleEntityTypesCount();
        if (this$accessibleEntityTypesCount == null ? other$accessibleEntityTypesCount != null : !((Object)this$accessibleEntityTypesCount).equals(other$accessibleEntityTypesCount)) {
            return false;
        }
        Long this$assignedUsersCount = this.getAssignedUsersCount();
        Long other$assignedUsersCount = other.getAssignedUsersCount();
        if (this$assignedUsersCount == null ? other$assignedUsersCount != null : !((Object)this$assignedUsersCount).equals(other$assignedUsersCount)) {
            return false;
        }
        Long this$assignedUserGroupsCount = this.getAssignedUserGroupsCount();
        Long other$assignedUserGroupsCount = other.getAssignedUserGroupsCount();
        if (this$assignedUserGroupsCount == null ? other$assignedUserGroupsCount != null : !((Object)this$assignedUserGroupsCount).equals(other$assignedUserGroupsCount)) {
            return false;
        }
        OffsetDateTime this$createdTime = this.getCreatedTime();
        OffsetDateTime other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        OffsetDateTime this$lastUpdatedTime = this.getLastUpdatedTime();
        OffsetDateTime other$lastUpdatedTime = other.getLastUpdatedTime();
        if (this$lastUpdatedTime == null ? other$lastUpdatedTime != null : !((Object)this$lastUpdatedTime).equals(other$lastUpdatedTime)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        Boolean this$isSystemDefined = this.getIsSystemDefined();
        Boolean other$isSystemDefined = other.getIsSystemDefined();
        if (this$isSystemDefined == null ? other$isSystemDefined != null : !((Object)this$isSystemDefined).equals(other$isSystemDefined)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<String> this$operations = this.getOperations();
        List<String> other$operations = other.getOperations();
        return !(this$operations == null ? other$operations != null : !((Object)this$operations).equals(other$operations));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Role;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<String> $accessibleClients = this.getAccessibleClients();
        result = result * 59 + ($accessibleClients == null ? 43 : ((Object)$accessibleClients).hashCode());
        List<String> $accessibleEntityTypes = this.getAccessibleEntityTypes();
        result = result * 59 + ($accessibleEntityTypes == null ? 43 : ((Object)$accessibleEntityTypes).hashCode());
        Integer $accessibleClientsCount = this.getAccessibleClientsCount();
        result = result * 59 + ($accessibleClientsCount == null ? 43 : ((Object)$accessibleClientsCount).hashCode());
        Integer $accessibleEntityTypesCount = this.getAccessibleEntityTypesCount();
        result = result * 59 + ($accessibleEntityTypesCount == null ? 43 : ((Object)$accessibleEntityTypesCount).hashCode());
        Long $assignedUsersCount = this.getAssignedUsersCount();
        result = result * 59 + ($assignedUsersCount == null ? 43 : ((Object)$assignedUsersCount).hashCode());
        Long $assignedUserGroupsCount = this.getAssignedUserGroupsCount();
        result = result * 59 + ($assignedUserGroupsCount == null ? 43 : ((Object)$assignedUserGroupsCount).hashCode());
        OffsetDateTime $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        OffsetDateTime $lastUpdatedTime = this.getLastUpdatedTime();
        result = result * 59 + ($lastUpdatedTime == null ? 43 : ((Object)$lastUpdatedTime).hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        Boolean $isSystemDefined = this.getIsSystemDefined();
        result = result * 59 + ($isSystemDefined == null ? 43 : ((Object)$isSystemDefined).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<String> $operations = this.getOperations();
        result = result * 59 + ($operations == null ? 43 : ((Object)$operations).hashCode());
        return result;
    }

    public List<String> getAccessibleClients() {
        return this.accessibleClients;
    }

    public List<String> getAccessibleEntityTypes() {
        return this.accessibleEntityTypes;
    }

    public Integer getAccessibleClientsCount() {
        return this.accessibleClientsCount;
    }

    public Integer getAccessibleEntityTypesCount() {
        return this.accessibleEntityTypesCount;
    }

    public Long getAssignedUsersCount() {
        return this.assignedUsersCount;
    }

    public Long getAssignedUserGroupsCount() {
        return this.assignedUserGroupsCount;
    }

    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public OffsetDateTime getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Boolean getIsSystemDefined() {
        return this.isSystemDefined;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getOperations() {
        return this.operations;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="operations")
    public void setOperations(List<String> operations) {
        this.operations = operations;
    }

    @Override
    public String toString() {
        return "Role(accessibleClients=" + this.getAccessibleClients() + ", accessibleEntityTypes=" + this.getAccessibleEntityTypes() + ", accessibleClientsCount=" + this.getAccessibleClientsCount() + ", accessibleEntityTypesCount=" + this.getAccessibleEntityTypesCount() + ", assignedUsersCount=" + this.getAssignedUsersCount() + ", assignedUserGroupsCount=" + this.getAssignedUserGroupsCount() + ", createdTime=" + this.getCreatedTime() + ", lastUpdatedTime=" + this.getLastUpdatedTime() + ", createdBy=" + this.getCreatedBy() + ", isSystemDefined=" + this.getIsSystemDefined() + ", description=" + this.getDescription() + ", operations=" + this.getOperations() + ")";
    }

    public static class RoleBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String displayName;
        private String clientName;
        private String description;
        private List<String> operations;
        private List<String> accessibleClients;
        private List<String> accessibleEntityTypes;
        private Integer accessibleClientsCount;
        private Integer accessibleEntityTypesCount;
        private Long assignedUsersCount;
        private Long assignedUserGroupsCount;
        private OffsetDateTime createdTime;
        private OffsetDateTime lastUpdatedTime;
        private String createdBy;
        private Boolean isSystemDefined;

        RoleBuilder() {
        }

        public RoleBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public RoleBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public RoleBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public RoleBuilder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public RoleBuilder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public RoleBuilder description(String description) {
            this.description = description;
            return this;
        }

        public RoleBuilder operations(List<String> operations) {
            this.operations = operations;
            return this;
        }

        public RoleBuilder accessibleClients(List<String> accessibleClients) {
            this.accessibleClients = accessibleClients;
            return this;
        }

        public RoleBuilder accessibleEntityTypes(List<String> accessibleEntityTypes) {
            this.accessibleEntityTypes = accessibleEntityTypes;
            return this;
        }

        public RoleBuilder accessibleClientsCount(Integer accessibleClientsCount) {
            this.accessibleClientsCount = accessibleClientsCount;
            return this;
        }

        public RoleBuilder accessibleEntityTypesCount(Integer accessibleEntityTypesCount) {
            this.accessibleEntityTypesCount = accessibleEntityTypesCount;
            return this;
        }

        public RoleBuilder assignedUsersCount(Long assignedUsersCount) {
            this.assignedUsersCount = assignedUsersCount;
            return this;
        }

        public RoleBuilder assignedUserGroupsCount(Long assignedUserGroupsCount) {
            this.assignedUserGroupsCount = assignedUserGroupsCount;
            return this;
        }

        public RoleBuilder createdTime(OffsetDateTime createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public RoleBuilder lastUpdatedTime(OffsetDateTime lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public RoleBuilder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public RoleBuilder isSystemDefined(Boolean isSystemDefined) {
            this.isSystemDefined = isSystemDefined;
            return this;
        }

        public Role build() {
            return new Role(this.tenantId, this.extId, this.links, this.displayName, this.clientName, this.description, this.operations, this.accessibleClients, this.accessibleEntityTypes, this.accessibleClientsCount, this.accessibleEntityTypesCount, this.assignedUsersCount, this.assignedUserGroupsCount, this.createdTime, this.lastUpdatedTime, this.createdBy, this.isSystemDefined);
        }

        public String toString() {
            return "Role.RoleBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", displayName=" + this.displayName + ", clientName=" + this.clientName + ", description=" + this.description + ", operations=" + this.operations + ", accessibleClients=" + this.accessibleClients + ", accessibleEntityTypes=" + this.accessibleEntityTypes + ", accessibleClientsCount=" + this.accessibleClientsCount + ", accessibleEntityTypesCount=" + this.accessibleEntityTypesCount + ", assignedUsersCount=" + this.assignedUsersCount + ", assignedUserGroupsCount=" + this.assignedUserGroupsCount + ", createdTime=" + this.createdTime + ", lastUpdatedTime=" + this.lastUpdatedTime + ", createdBy=" + this.createdBy + ", isSystemDefined=" + this.isSystemDefined + ")";
        }
    }
}

