/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.iam.iam.v4.authz;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.iam.common.v1.response.ApiLink;
import com.nutanix.dp1.iam.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.iam.deserializers.IamObjectTypeTypedObject;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client
extends ExternalizableAbstractModel
implements Serializable,
IamObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(Client.class);
    private OffsetDateTime createdTime = null;
    private OffsetDateTime lastUpdatedTime = null;
    private String createdBy = null;
    @Size(min=1, max=255)
    @JsonProperty(value="name")
    public @Size(min=1, max=255) String name = null;
    @Pattern(regexp="^[^<>;()&+%/\\\\\"`]*$")
    @Size(max=1000)
    @JsonProperty(value="description")
    public @Pattern(regexp="^[^<>;()&+%/\\\\\"`]*$") @Size(max=1000) String description = null;
    @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$")
    @Size(min=1, max=255)
    @JsonProperty(value="displayName")
    public @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$") @Size(min=1, max=255) String displayName = null;
    @Size(min=1, max=5)
    @JsonProperty(value="deploymentList")
    public @Size(min=1, max=5) List<String> deploymentList = null;

    public Client() {
    }

    public Client(String tenantId, String extId, List<ApiLink> links, String name, String description, String displayName, OffsetDateTime createdTime, OffsetDateTime lastUpdatedTime, String createdBy, List<String> deploymentList) {
        super(tenantId, extId, links);
        this.setName(name);
        this.setDescription(description);
        this.setDisplayName(displayName);
        this.setCreatedTime(createdTime);
        this.setLastUpdatedTime(lastUpdatedTime);
        this.setCreatedBy(createdBy);
        this.setDeploymentList(deploymentList);
    }

    @Override
    protected String initialize$objectType() {
        return "iam.v4.authz.Client";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setCreatedTime(OffsetDateTime createdTime) {
        if (this.createdTime == null) {
            this.createdTime = createdTime;
        } else {
            log.warn("Read-only property createdTime already contains a non-null value and cannot be set again");
        }
    }

    public void setLastUpdatedTime(OffsetDateTime lastUpdatedTime) {
        if (this.lastUpdatedTime == null) {
            this.lastUpdatedTime = lastUpdatedTime;
        } else {
            log.warn("Read-only property lastUpdatedTime already contains a non-null value and cannot be set again");
        }
    }

    public void setCreatedBy(String createdBy) {
        if (this.createdBy == null) {
            this.createdBy = createdBy;
        } else {
            log.warn("Read-only property createdBy already contains a non-null value and cannot be set again");
        }
    }

    public static ClientBuilder ClientBuilder() {
        return new ClientBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Client)) {
            return false;
        }
        Client other = (Client)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OffsetDateTime this$createdTime = this.getCreatedTime();
        OffsetDateTime other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        OffsetDateTime this$lastUpdatedTime = this.getLastUpdatedTime();
        OffsetDateTime other$lastUpdatedTime = other.getLastUpdatedTime();
        if (this$lastUpdatedTime == null ? other$lastUpdatedTime != null : !((Object)this$lastUpdatedTime).equals(other$lastUpdatedTime)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        List<String> this$deploymentList = this.getDeploymentList();
        List<String> other$deploymentList = other.getDeploymentList();
        return !(this$deploymentList == null ? other$deploymentList != null : !((Object)this$deploymentList).equals(other$deploymentList));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Client;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        OffsetDateTime $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        OffsetDateTime $lastUpdatedTime = this.getLastUpdatedTime();
        result = result * 59 + ($lastUpdatedTime == null ? 43 : ((Object)$lastUpdatedTime).hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        List<String> $deploymentList = this.getDeploymentList();
        result = result * 59 + ($deploymentList == null ? 43 : ((Object)$deploymentList).hashCode());
        return result;
    }

    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public OffsetDateTime getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<String> getDeploymentList() {
        return this.deploymentList;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @JsonProperty(value="deploymentList")
    public void setDeploymentList(List<String> deploymentList) {
        this.deploymentList = deploymentList;
    }

    @Override
    public String toString() {
        return "Client(createdTime=" + this.getCreatedTime() + ", lastUpdatedTime=" + this.getLastUpdatedTime() + ", createdBy=" + this.getCreatedBy() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", displayName=" + this.getDisplayName() + ", deploymentList=" + this.getDeploymentList() + ")";
    }

    public static class ClientBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String name;
        private String description;
        private String displayName;
        private OffsetDateTime createdTime;
        private OffsetDateTime lastUpdatedTime;
        private String createdBy;
        private List<String> deploymentList;

        ClientBuilder() {
        }

        public ClientBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public ClientBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public ClientBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public ClientBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ClientBuilder description(String description) {
            this.description = description;
            return this;
        }

        public ClientBuilder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public ClientBuilder createdTime(OffsetDateTime createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public ClientBuilder lastUpdatedTime(OffsetDateTime lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public ClientBuilder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public ClientBuilder deploymentList(List<String> deploymentList) {
            this.deploymentList = deploymentList;
            return this;
        }

        public Client build() {
            return new Client(this.tenantId, this.extId, this.links, this.name, this.description, this.displayName, this.createdTime, this.lastUpdatedTime, this.createdBy, this.deploymentList);
        }

        public String toString() {
            return "Client.ClientBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", name=" + this.name + ", description=" + this.description + ", displayName=" + this.displayName + ", createdTime=" + this.createdTime + ", lastUpdatedTime=" + this.lastUpdatedTime + ", createdBy=" + this.createdBy + ", deploymentList=" + this.deploymentList + ")";
        }
    }
}

