/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.iam.iam.v4.authn;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.iam.common.v1.response.ApiLink;
import com.nutanix.dp1.iam.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.iam.deserializers.IamObjectTypeTypedObject;
import com.nutanix.dp1.iam.iam.v4.authn.GroupType;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserGroup
extends ExternalizableAbstractModel
implements Serializable,
IamObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(UserGroup.class);
    private OffsetDateTime createdTime = null;
    private OffsetDateTime lastUpdatedTime = null;
    private String createdBy = null;
    @JsonProperty(value="groupType")
    public GroupType groupType = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="idpId")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String idpId = null;
    @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$")
    @Size(max=255)
    @JsonProperty(value="name")
    public @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$") @Size(max=255) String name = null;
    @Size(max=255)
    @JsonProperty(value="distinguishedName")
    public @Size(max=255) String distinguishedName = null;

    public UserGroup() {
    }

    public UserGroup(String tenantId, String extId, List<ApiLink> links, GroupType groupType, String idpId, String name, String distinguishedName, OffsetDateTime createdTime, OffsetDateTime lastUpdatedTime, String createdBy) {
        super(tenantId, extId, links);
        this.setGroupType(groupType);
        this.setIdpId(idpId);
        this.setName(name);
        this.setDistinguishedName(distinguishedName);
        this.setCreatedTime(createdTime);
        this.setLastUpdatedTime(lastUpdatedTime);
        this.setCreatedBy(createdBy);
    }

    @Override
    protected String initialize$objectType() {
        return "iam.v4.authn.UserGroup";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setCreatedTime(OffsetDateTime createdTime) {
        if (this.createdTime == null) {
            this.createdTime = createdTime;
        } else {
            log.warn("Read-only property createdTime already contains a non-null value and cannot be set again");
        }
    }

    public void setLastUpdatedTime(OffsetDateTime lastUpdatedTime) {
        if (this.lastUpdatedTime == null) {
            this.lastUpdatedTime = lastUpdatedTime;
        } else {
            log.warn("Read-only property lastUpdatedTime already contains a non-null value and cannot be set again");
        }
    }

    public void setCreatedBy(String createdBy) {
        if (this.createdBy == null) {
            this.createdBy = createdBy;
        } else {
            log.warn("Read-only property createdBy already contains a non-null value and cannot be set again");
        }
    }

    public static UserGroupBuilder UserGroupBuilder() {
        return new UserGroupBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserGroup)) {
            return false;
        }
        UserGroup other = (UserGroup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OffsetDateTime this$createdTime = this.getCreatedTime();
        OffsetDateTime other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        OffsetDateTime this$lastUpdatedTime = this.getLastUpdatedTime();
        OffsetDateTime other$lastUpdatedTime = other.getLastUpdatedTime();
        if (this$lastUpdatedTime == null ? other$lastUpdatedTime != null : !((Object)this$lastUpdatedTime).equals(other$lastUpdatedTime)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        GroupType this$groupType = this.getGroupType();
        GroupType other$groupType = other.getGroupType();
        if (this$groupType == null ? other$groupType != null : !((Object)((Object)this$groupType)).equals((Object)other$groupType)) {
            return false;
        }
        String this$idpId = this.getIdpId();
        String other$idpId = other.getIdpId();
        if (this$idpId == null ? other$idpId != null : !this$idpId.equals(other$idpId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$distinguishedName = this.getDistinguishedName();
        String other$distinguishedName = other.getDistinguishedName();
        return !(this$distinguishedName == null ? other$distinguishedName != null : !this$distinguishedName.equals(other$distinguishedName));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UserGroup;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        OffsetDateTime $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        OffsetDateTime $lastUpdatedTime = this.getLastUpdatedTime();
        result = result * 59 + ($lastUpdatedTime == null ? 43 : ((Object)$lastUpdatedTime).hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        GroupType $groupType = this.getGroupType();
        result = result * 59 + ($groupType == null ? 43 : ((Object)((Object)$groupType)).hashCode());
        String $idpId = this.getIdpId();
        result = result * 59 + ($idpId == null ? 43 : $idpId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $distinguishedName = this.getDistinguishedName();
        result = result * 59 + ($distinguishedName == null ? 43 : $distinguishedName.hashCode());
        return result;
    }

    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public OffsetDateTime getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public GroupType getGroupType() {
        return this.groupType;
    }

    public String getIdpId() {
        return this.idpId;
    }

    public String getName() {
        return this.name;
    }

    public String getDistinguishedName() {
        return this.distinguishedName;
    }

    @JsonProperty(value="groupType")
    public void setGroupType(GroupType groupType) {
        this.groupType = groupType;
    }

    @JsonProperty(value="idpId")
    public void setIdpId(String idpId) {
        this.idpId = idpId;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="distinguishedName")
    public void setDistinguishedName(String distinguishedName) {
        this.distinguishedName = distinguishedName;
    }

    @Override
    public String toString() {
        return "UserGroup(createdTime=" + this.getCreatedTime() + ", lastUpdatedTime=" + this.getLastUpdatedTime() + ", createdBy=" + this.getCreatedBy() + ", groupType=" + (Object)((Object)this.getGroupType()) + ", idpId=" + this.getIdpId() + ", name=" + this.getName() + ", distinguishedName=" + this.getDistinguishedName() + ")";
    }

    public static class UserGroupBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private GroupType groupType;
        private String idpId;
        private String name;
        private String distinguishedName;
        private OffsetDateTime createdTime;
        private OffsetDateTime lastUpdatedTime;
        private String createdBy;

        UserGroupBuilder() {
        }

        public UserGroupBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public UserGroupBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public UserGroupBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public UserGroupBuilder groupType(GroupType groupType) {
            this.groupType = groupType;
            return this;
        }

        public UserGroupBuilder idpId(String idpId) {
            this.idpId = idpId;
            return this;
        }

        public UserGroupBuilder name(String name) {
            this.name = name;
            return this;
        }

        public UserGroupBuilder distinguishedName(String distinguishedName) {
            this.distinguishedName = distinguishedName;
            return this;
        }

        public UserGroupBuilder createdTime(OffsetDateTime createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public UserGroupBuilder lastUpdatedTime(OffsetDateTime lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public UserGroupBuilder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public UserGroup build() {
            return new UserGroup(this.tenantId, this.extId, this.links, this.groupType, this.idpId, this.name, this.distinguishedName, this.createdTime, this.lastUpdatedTime, this.createdBy);
        }

        public String toString() {
            return "UserGroup.UserGroupBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", groupType=" + (Object)((Object)this.groupType) + ", idpId=" + this.idpId + ", name=" + this.name + ", distinguishedName=" + this.distinguishedName + ", createdTime=" + this.createdTime + ", lastUpdatedTime=" + this.lastUpdatedTime + ", createdBy=" + this.createdBy + ")";
        }
    }
}

