/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.iam.iam.v4.authn;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.nutanix.devplatform.models.PrettyModeViews;
import com.nutanix.dp1.iam.deserializers.IamObjectTypeTypedObject;
import com.nutanix.dp1.iam.iam.v4.authn.NameIdPolicyFormat;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdpMetadata
implements Serializable,
IamObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(IdpMetadata.class);
    @Size(min=3, max=2000)
    @JsonProperty(value="entityId")
    public @Size(min=3, max=2000) String entityId = null;
    @Pattern(regexp="^((http[s]?|nfs):/)?/?([^:/\\s]*)((/\\w+)*(:[0-9]+)*?/)([\\w\\-\\.]+[^#?\\s]+)(.*)?(#[\\w\\-]+)?$")
    @Size(min=3, max=2000)
    @JsonProperty(value="loginUrl")
    public @Pattern(regexp="^((http[s]?|nfs):/)?/?([^:/\\s]*)((/\\w+)*(:[0-9]+)*?/)([\\w\\-\\.]+[^#?\\s]+)(.*)?(#[\\w\\-]+)?$") @Size(min=3, max=2000) String loginUrl = null;
    @Pattern(regexp="^((http[s]?|nfs):/)?/?([^:/\\s]*)((/\\w+)*(:[0-9]+)*?/)([\\w\\-\\.]+[^#?\\s]+)(.*)?(#[\\w\\-]+)?$")
    @Size(min=3, max=2000)
    @JsonProperty(value="logoutUrl")
    public @Pattern(regexp="^((http[s]?|nfs):/)?/?([^:/\\s]*)((/\\w+)*(:[0-9]+)*?/)([\\w\\-\\.]+[^#?\\s]+)(.*)?(#[\\w\\-]+)?$") @Size(min=3, max=2000) String logoutUrl = null;
    @Pattern(regexp="^((http[s]?|nfs):/)?/?([^:/\\s]*)((/\\w+)*(:[0-9]+)*?/)([\\w\\-\\.]+[^#?\\s]+)(.*)?(#[\\w\\-]+)?$")
    @Size(min=3, max=2000)
    @JsonProperty(value="errorUrl")
    public @Pattern(regexp="^((http[s]?|nfs):/)?/?([^:/\\s]*)((/\\w+)*(:[0-9]+)*?/)([\\w\\-\\.]+[^#?\\s]+)(.*)?(#[\\w\\-]+)?$") @Size(min=3, max=2000) String errorUrl = null;
    @Size(min=64)
    @JsonProperty(value="certificate")
    public @Size(min=64) String certificate = null;
    @JsonProperty(value="nameIdPolicyFormat")
    public NameIdPolicyFormat nameIdPolicyFormat = null;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $reserved;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final String $objectType = this.initialize$objectType();
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $unknownFields;

    public IdpMetadata() {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
    }

    public IdpMetadata(String entityId, String loginUrl, String logoutUrl, String errorUrl, String certificate, NameIdPolicyFormat nameIdPolicyFormat) {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
        this.setEntityId(entityId);
        this.setLoginUrl(loginUrl);
        this.setLogoutUrl(logoutUrl);
        this.setErrorUrl(errorUrl);
        this.setCertificate(certificate);
        this.setNameIdPolicyFormat(nameIdPolicyFormat);
    }

    protected String initialize$objectType() {
        return "iam.v4.authn.IdpMetadata";
    }

    protected String initialize$fv() {
        return "v4.r0";
    }

    @JsonAnySetter
    private void setUndeserializedFields(String name, Object value) {
        this.$unknownFields.put(name, value);
    }

    public static IdpMetadataBuilder IdpMetadataBuilder() {
        return new IdpMetadataBuilder();
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public String getLogoutUrl() {
        return this.logoutUrl;
    }

    public String getErrorUrl() {
        return this.errorUrl;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public NameIdPolicyFormat getNameIdPolicyFormat() {
        return this.nameIdPolicyFormat;
    }

    @JsonProperty(value="entityId")
    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    @JsonProperty(value="loginUrl")
    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    @JsonProperty(value="logoutUrl")
    public void setLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
    }

    @JsonProperty(value="errorUrl")
    public void setErrorUrl(String errorUrl) {
        this.errorUrl = errorUrl;
    }

    @JsonProperty(value="certificate")
    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    @JsonProperty(value="nameIdPolicyFormat")
    public void setNameIdPolicyFormat(NameIdPolicyFormat nameIdPolicyFormat) {
        this.nameIdPolicyFormat = nameIdPolicyFormat;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IdpMetadata)) {
            return false;
        }
        IdpMetadata other = (IdpMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$entityId = this.getEntityId();
        String other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) {
            return false;
        }
        String this$loginUrl = this.getLoginUrl();
        String other$loginUrl = other.getLoginUrl();
        if (this$loginUrl == null ? other$loginUrl != null : !this$loginUrl.equals(other$loginUrl)) {
            return false;
        }
        String this$logoutUrl = this.getLogoutUrl();
        String other$logoutUrl = other.getLogoutUrl();
        if (this$logoutUrl == null ? other$logoutUrl != null : !this$logoutUrl.equals(other$logoutUrl)) {
            return false;
        }
        String this$errorUrl = this.getErrorUrl();
        String other$errorUrl = other.getErrorUrl();
        if (this$errorUrl == null ? other$errorUrl != null : !this$errorUrl.equals(other$errorUrl)) {
            return false;
        }
        String this$certificate = this.getCertificate();
        String other$certificate = other.getCertificate();
        if (this$certificate == null ? other$certificate != null : !this$certificate.equals(other$certificate)) {
            return false;
        }
        NameIdPolicyFormat this$nameIdPolicyFormat = this.getNameIdPolicyFormat();
        NameIdPolicyFormat other$nameIdPolicyFormat = other.getNameIdPolicyFormat();
        return !(this$nameIdPolicyFormat == null ? other$nameIdPolicyFormat != null : !((Object)((Object)this$nameIdPolicyFormat)).equals((Object)other$nameIdPolicyFormat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IdpMetadata;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        String $loginUrl = this.getLoginUrl();
        result = result * 59 + ($loginUrl == null ? 43 : $loginUrl.hashCode());
        String $logoutUrl = this.getLogoutUrl();
        result = result * 59 + ($logoutUrl == null ? 43 : $logoutUrl.hashCode());
        String $errorUrl = this.getErrorUrl();
        result = result * 59 + ($errorUrl == null ? 43 : $errorUrl.hashCode());
        String $certificate = this.getCertificate();
        result = result * 59 + ($certificate == null ? 43 : $certificate.hashCode());
        NameIdPolicyFormat $nameIdPolicyFormat = this.getNameIdPolicyFormat();
        result = result * 59 + ($nameIdPolicyFormat == null ? 43 : ((Object)((Object)$nameIdPolicyFormat)).hashCode());
        return result;
    }

    public String toString() {
        return "IdpMetadata(entityId=" + this.getEntityId() + ", loginUrl=" + this.getLoginUrl() + ", logoutUrl=" + this.getLogoutUrl() + ", errorUrl=" + this.getErrorUrl() + ", certificate=" + this.getCertificate() + ", nameIdPolicyFormat=" + (Object)((Object)this.getNameIdPolicyFormat()) + ")";
    }

    @Override
    public Map<String, Object> get$reserved() {
        return this.$reserved;
    }

    @Override
    public String get$objectType() {
        return this.$objectType;
    }

    public Map<String, Object> get$unknownFields() {
        return this.$unknownFields;
    }

    public static class IdpMetadataBuilder {
        private String entityId;
        private String loginUrl;
        private String logoutUrl;
        private String errorUrl;
        private String certificate;
        private NameIdPolicyFormat nameIdPolicyFormat;

        IdpMetadataBuilder() {
        }

        public IdpMetadataBuilder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public IdpMetadataBuilder loginUrl(String loginUrl) {
            this.loginUrl = loginUrl;
            return this;
        }

        public IdpMetadataBuilder logoutUrl(String logoutUrl) {
            this.logoutUrl = logoutUrl;
            return this;
        }

        public IdpMetadataBuilder errorUrl(String errorUrl) {
            this.errorUrl = errorUrl;
            return this;
        }

        public IdpMetadataBuilder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public IdpMetadataBuilder nameIdPolicyFormat(NameIdPolicyFormat nameIdPolicyFormat) {
            this.nameIdPolicyFormat = nameIdPolicyFormat;
            return this;
        }

        public IdpMetadata build() {
            return new IdpMetadata(this.entityId, this.loginUrl, this.logoutUrl, this.errorUrl, this.certificate, this.nameIdPolicyFormat);
        }

        public String toString() {
            return "IdpMetadata.IdpMetadataBuilder(entityId=" + this.entityId + ", loginUrl=" + this.loginUrl + ", logoutUrl=" + this.logoutUrl + ", errorUrl=" + this.errorUrl + ", certificate=" + this.certificate + ", nameIdPolicyFormat=" + (Object)((Object)this.nameIdPolicyFormat) + ")";
        }
    }
}

