/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.iam.iam.v4.authn;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.iam.common.v1.response.ApiLink;
import com.nutanix.dp1.iam.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.iam.deserializers.IamObjectTypeTypedObject;
import com.nutanix.dp1.iam.iam.v4.authn.FederationClaims;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Federation
extends ExternalizableAbstractModel
implements Serializable,
IamObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(Federation.class);
    private OffsetDateTime createdTime = null;
    private OffsetDateTime lastUpdatedTime = null;
    private String createdBy = null;
    @Pattern(regexp="^((http[s]?|nfs):/)?/?([^:/\\s]*)((/\\w+)*(:[0-9]+)*?/)([\\w\\-\\.]+[^#?\\s]+)(.*)?(#[\\w\\-]+)?$")
    @Size(min=3, max=2000)
    @JsonProperty(value="wellKnownConfig")
    public @Pattern(regexp="^((http[s]?|nfs):/)?/?([^:/\\s]*)((/\\w+)*(:[0-9]+)*?/)([\\w\\-\\.]+[^#?\\s]+)(.*)?(#[\\w\\-]+)?$") @Size(min=3, max=2000) String wellKnownConfig = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="idpId")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String idpId = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="cloudTenant")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String cloudTenant = null;
    @Size(max=128)
    @JsonProperty(value="cloudApiKey")
    public @Size(max=128) String cloudApiKey = null;
    @JsonProperty(value="claimMap")
    public FederationClaims claimMap = null;

    public Federation() {
    }

    public Federation(String tenantId, String extId, List<ApiLink> links, String wellKnownConfig, String idpId, String cloudTenant, String cloudApiKey, FederationClaims claimMap, OffsetDateTime createdTime, OffsetDateTime lastUpdatedTime, String createdBy) {
        super(tenantId, extId, links);
        this.setWellKnownConfig(wellKnownConfig);
        this.setIdpId(idpId);
        this.setCloudTenant(cloudTenant);
        this.setCloudApiKey(cloudApiKey);
        this.setClaimMap(claimMap);
        this.setCreatedTime(createdTime);
        this.setLastUpdatedTime(lastUpdatedTime);
        this.setCreatedBy(createdBy);
    }

    @Override
    protected String initialize$objectType() {
        return "iam.v4.authn.Federation";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setCreatedTime(OffsetDateTime createdTime) {
        if (this.createdTime == null) {
            this.createdTime = createdTime;
        } else {
            log.warn("Read-only property createdTime already contains a non-null value and cannot be set again");
        }
    }

    public void setLastUpdatedTime(OffsetDateTime lastUpdatedTime) {
        if (this.lastUpdatedTime == null) {
            this.lastUpdatedTime = lastUpdatedTime;
        } else {
            log.warn("Read-only property lastUpdatedTime already contains a non-null value and cannot be set again");
        }
    }

    public void setCreatedBy(String createdBy) {
        if (this.createdBy == null) {
            this.createdBy = createdBy;
        } else {
            log.warn("Read-only property createdBy already contains a non-null value and cannot be set again");
        }
    }

    public static FederationBuilder FederationBuilder() {
        return new FederationBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Federation)) {
            return false;
        }
        Federation other = (Federation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OffsetDateTime this$createdTime = this.getCreatedTime();
        OffsetDateTime other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        OffsetDateTime this$lastUpdatedTime = this.getLastUpdatedTime();
        OffsetDateTime other$lastUpdatedTime = other.getLastUpdatedTime();
        if (this$lastUpdatedTime == null ? other$lastUpdatedTime != null : !((Object)this$lastUpdatedTime).equals(other$lastUpdatedTime)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        String this$wellKnownConfig = this.getWellKnownConfig();
        String other$wellKnownConfig = other.getWellKnownConfig();
        if (this$wellKnownConfig == null ? other$wellKnownConfig != null : !this$wellKnownConfig.equals(other$wellKnownConfig)) {
            return false;
        }
        String this$idpId = this.getIdpId();
        String other$idpId = other.getIdpId();
        if (this$idpId == null ? other$idpId != null : !this$idpId.equals(other$idpId)) {
            return false;
        }
        String this$cloudTenant = this.getCloudTenant();
        String other$cloudTenant = other.getCloudTenant();
        if (this$cloudTenant == null ? other$cloudTenant != null : !this$cloudTenant.equals(other$cloudTenant)) {
            return false;
        }
        String this$cloudApiKey = this.getCloudApiKey();
        String other$cloudApiKey = other.getCloudApiKey();
        if (this$cloudApiKey == null ? other$cloudApiKey != null : !this$cloudApiKey.equals(other$cloudApiKey)) {
            return false;
        }
        FederationClaims this$claimMap = this.getClaimMap();
        FederationClaims other$claimMap = other.getClaimMap();
        return !(this$claimMap == null ? other$claimMap != null : !((Object)this$claimMap).equals(other$claimMap));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Federation;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        OffsetDateTime $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        OffsetDateTime $lastUpdatedTime = this.getLastUpdatedTime();
        result = result * 59 + ($lastUpdatedTime == null ? 43 : ((Object)$lastUpdatedTime).hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        String $wellKnownConfig = this.getWellKnownConfig();
        result = result * 59 + ($wellKnownConfig == null ? 43 : $wellKnownConfig.hashCode());
        String $idpId = this.getIdpId();
        result = result * 59 + ($idpId == null ? 43 : $idpId.hashCode());
        String $cloudTenant = this.getCloudTenant();
        result = result * 59 + ($cloudTenant == null ? 43 : $cloudTenant.hashCode());
        String $cloudApiKey = this.getCloudApiKey();
        result = result * 59 + ($cloudApiKey == null ? 43 : $cloudApiKey.hashCode());
        FederationClaims $claimMap = this.getClaimMap();
        result = result * 59 + ($claimMap == null ? 43 : ((Object)$claimMap).hashCode());
        return result;
    }

    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public OffsetDateTime getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getWellKnownConfig() {
        return this.wellKnownConfig;
    }

    public String getIdpId() {
        return this.idpId;
    }

    public String getCloudTenant() {
        return this.cloudTenant;
    }

    public String getCloudApiKey() {
        return this.cloudApiKey;
    }

    public FederationClaims getClaimMap() {
        return this.claimMap;
    }

    @JsonProperty(value="wellKnownConfig")
    public void setWellKnownConfig(String wellKnownConfig) {
        this.wellKnownConfig = wellKnownConfig;
    }

    @JsonProperty(value="idpId")
    public void setIdpId(String idpId) {
        this.idpId = idpId;
    }

    @JsonProperty(value="cloudTenant")
    public void setCloudTenant(String cloudTenant) {
        this.cloudTenant = cloudTenant;
    }

    @JsonProperty(value="cloudApiKey")
    public void setCloudApiKey(String cloudApiKey) {
        this.cloudApiKey = cloudApiKey;
    }

    @JsonProperty(value="claimMap")
    public void setClaimMap(FederationClaims claimMap) {
        this.claimMap = claimMap;
    }

    @Override
    public String toString() {
        return "Federation(createdTime=" + this.getCreatedTime() + ", lastUpdatedTime=" + this.getLastUpdatedTime() + ", createdBy=" + this.getCreatedBy() + ", wellKnownConfig=" + this.getWellKnownConfig() + ", idpId=" + this.getIdpId() + ", cloudTenant=" + this.getCloudTenant() + ", cloudApiKey=" + this.getCloudApiKey() + ", claimMap=" + this.getClaimMap() + ")";
    }

    public static class FederationBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String wellKnownConfig;
        private String idpId;
        private String cloudTenant;
        private String cloudApiKey;
        private FederationClaims claimMap;
        private OffsetDateTime createdTime;
        private OffsetDateTime lastUpdatedTime;
        private String createdBy;

        FederationBuilder() {
        }

        public FederationBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public FederationBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public FederationBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public FederationBuilder wellKnownConfig(String wellKnownConfig) {
            this.wellKnownConfig = wellKnownConfig;
            return this;
        }

        public FederationBuilder idpId(String idpId) {
            this.idpId = idpId;
            return this;
        }

        public FederationBuilder cloudTenant(String cloudTenant) {
            this.cloudTenant = cloudTenant;
            return this;
        }

        public FederationBuilder cloudApiKey(String cloudApiKey) {
            this.cloudApiKey = cloudApiKey;
            return this;
        }

        public FederationBuilder claimMap(FederationClaims claimMap) {
            this.claimMap = claimMap;
            return this;
        }

        public FederationBuilder createdTime(OffsetDateTime createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public FederationBuilder lastUpdatedTime(OffsetDateTime lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public FederationBuilder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public Federation build() {
            return new Federation(this.tenantId, this.extId, this.links, this.wellKnownConfig, this.idpId, this.cloudTenant, this.cloudApiKey, this.claimMap, this.createdTime, this.lastUpdatedTime, this.createdBy);
        }

        public String toString() {
            return "Federation.FederationBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", wellKnownConfig=" + this.wellKnownConfig + ", idpId=" + this.idpId + ", cloudTenant=" + this.cloudTenant + ", cloudApiKey=" + this.cloudApiKey + ", claimMap=" + this.claimMap + ", createdTime=" + this.createdTime + ", lastUpdatedTime=" + this.lastUpdatedTime + ", createdBy=" + this.createdBy + ")";
        }
    }
}

