/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.iam.iam.v4.authn;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.iam.common.v1.response.ApiLink;
import com.nutanix.dp1.iam.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.iam.deserializers.IamObjectTypeTypedObject;
import com.nutanix.dp1.iam.iam.v4.authn.DirectoryType;
import com.nutanix.dp1.iam.iam.v4.authn.DsServiceAccount;
import com.nutanix.dp1.iam.iam.v4.authn.GroupSearchType;
import com.nutanix.dp1.iam.iam.v4.authn.OpenLdapConfig;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryService
extends ExternalizableAbstractModel
implements Serializable,
IamObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(DirectoryService.class);
    private OffsetDateTime createdTime = null;
    private OffsetDateTime lastUpdatedTime = null;
    private String createdBy = null;
    @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$")
    @Size(min=1, max=255)
    @JsonProperty(value="name")
    public @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$") @Size(min=1, max=255) String name = null;
    @Size(min=3, max=2000)
    @JsonProperty(value="url")
    public @Size(min=3, max=2000) String url = null;
    @Size(min=0, max=5)
    @JsonProperty(value="secondaryUrls")
    public @Size(min=0, max=5) List<String> secondaryUrls = null;
    @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$")
    @Size(min=3, max=255)
    @JsonProperty(value="domainName")
    public @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$") @Size(min=3, max=255) String domainName = null;
    @JsonProperty(value="directoryType")
    public DirectoryType directoryType = null;
    @JsonProperty(value="serviceAccount")
    public DsServiceAccount serviceAccount = null;
    @JsonProperty(value="openLdapConfiguration")
    public OpenLdapConfig openLdapConfiguration = null;
    @JsonProperty(value="groupSearchType")
    public GroupSearchType groupSearchType = null;
    @Size(min=0, max=1000)
    @JsonProperty(value="whiteListedGroups")
    public @Size(min=0, max=1000) List<String> whiteListedGroups = null;

    public DirectoryService() {
    }

    public DirectoryService(String tenantId, String extId, List<ApiLink> links, String name, String url, List<String> secondaryUrls, String domainName, DirectoryType directoryType, DsServiceAccount serviceAccount, OpenLdapConfig openLdapConfiguration, GroupSearchType groupSearchType, List<String> whiteListedGroups, OffsetDateTime createdTime, OffsetDateTime lastUpdatedTime, String createdBy) {
        super(tenantId, extId, links);
        this.setName(name);
        this.setUrl(url);
        this.setSecondaryUrls(secondaryUrls);
        this.setDomainName(domainName);
        this.setDirectoryType(directoryType);
        this.setServiceAccount(serviceAccount);
        this.setOpenLdapConfiguration(openLdapConfiguration);
        this.setGroupSearchType(groupSearchType);
        this.setWhiteListedGroups(whiteListedGroups);
        this.setCreatedTime(createdTime);
        this.setLastUpdatedTime(lastUpdatedTime);
        this.setCreatedBy(createdBy);
    }

    @Override
    protected String initialize$objectType() {
        return "iam.v4.authn.DirectoryService";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setCreatedTime(OffsetDateTime createdTime) {
        if (this.createdTime == null) {
            this.createdTime = createdTime;
        } else {
            log.warn("Read-only property createdTime already contains a non-null value and cannot be set again");
        }
    }

    public void setLastUpdatedTime(OffsetDateTime lastUpdatedTime) {
        if (this.lastUpdatedTime == null) {
            this.lastUpdatedTime = lastUpdatedTime;
        } else {
            log.warn("Read-only property lastUpdatedTime already contains a non-null value and cannot be set again");
        }
    }

    public void setCreatedBy(String createdBy) {
        if (this.createdBy == null) {
            this.createdBy = createdBy;
        } else {
            log.warn("Read-only property createdBy already contains a non-null value and cannot be set again");
        }
    }

    public static DirectoryServiceBuilder DirectoryServiceBuilder() {
        return new DirectoryServiceBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DirectoryService)) {
            return false;
        }
        DirectoryService other = (DirectoryService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OffsetDateTime this$createdTime = this.getCreatedTime();
        OffsetDateTime other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        OffsetDateTime this$lastUpdatedTime = this.getLastUpdatedTime();
        OffsetDateTime other$lastUpdatedTime = other.getLastUpdatedTime();
        if (this$lastUpdatedTime == null ? other$lastUpdatedTime != null : !((Object)this$lastUpdatedTime).equals(other$lastUpdatedTime)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        List<String> this$secondaryUrls = this.getSecondaryUrls();
        List<String> other$secondaryUrls = other.getSecondaryUrls();
        if (this$secondaryUrls == null ? other$secondaryUrls != null : !((Object)this$secondaryUrls).equals(other$secondaryUrls)) {
            return false;
        }
        String this$domainName = this.getDomainName();
        String other$domainName = other.getDomainName();
        if (this$domainName == null ? other$domainName != null : !this$domainName.equals(other$domainName)) {
            return false;
        }
        DirectoryType this$directoryType = this.getDirectoryType();
        DirectoryType other$directoryType = other.getDirectoryType();
        if (this$directoryType == null ? other$directoryType != null : !((Object)((Object)this$directoryType)).equals((Object)other$directoryType)) {
            return false;
        }
        DsServiceAccount this$serviceAccount = this.getServiceAccount();
        DsServiceAccount other$serviceAccount = other.getServiceAccount();
        if (this$serviceAccount == null ? other$serviceAccount != null : !((Object)this$serviceAccount).equals(other$serviceAccount)) {
            return false;
        }
        OpenLdapConfig this$openLdapConfiguration = this.getOpenLdapConfiguration();
        OpenLdapConfig other$openLdapConfiguration = other.getOpenLdapConfiguration();
        if (this$openLdapConfiguration == null ? other$openLdapConfiguration != null : !((Object)this$openLdapConfiguration).equals(other$openLdapConfiguration)) {
            return false;
        }
        GroupSearchType this$groupSearchType = this.getGroupSearchType();
        GroupSearchType other$groupSearchType = other.getGroupSearchType();
        if (this$groupSearchType == null ? other$groupSearchType != null : !((Object)((Object)this$groupSearchType)).equals((Object)other$groupSearchType)) {
            return false;
        }
        List<String> this$whiteListedGroups = this.getWhiteListedGroups();
        List<String> other$whiteListedGroups = other.getWhiteListedGroups();
        return !(this$whiteListedGroups == null ? other$whiteListedGroups != null : !((Object)this$whiteListedGroups).equals(other$whiteListedGroups));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DirectoryService;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        OffsetDateTime $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        OffsetDateTime $lastUpdatedTime = this.getLastUpdatedTime();
        result = result * 59 + ($lastUpdatedTime == null ? 43 : ((Object)$lastUpdatedTime).hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        List<String> $secondaryUrls = this.getSecondaryUrls();
        result = result * 59 + ($secondaryUrls == null ? 43 : ((Object)$secondaryUrls).hashCode());
        String $domainName = this.getDomainName();
        result = result * 59 + ($domainName == null ? 43 : $domainName.hashCode());
        DirectoryType $directoryType = this.getDirectoryType();
        result = result * 59 + ($directoryType == null ? 43 : ((Object)((Object)$directoryType)).hashCode());
        DsServiceAccount $serviceAccount = this.getServiceAccount();
        result = result * 59 + ($serviceAccount == null ? 43 : ((Object)$serviceAccount).hashCode());
        OpenLdapConfig $openLdapConfiguration = this.getOpenLdapConfiguration();
        result = result * 59 + ($openLdapConfiguration == null ? 43 : ((Object)$openLdapConfiguration).hashCode());
        GroupSearchType $groupSearchType = this.getGroupSearchType();
        result = result * 59 + ($groupSearchType == null ? 43 : ((Object)((Object)$groupSearchType)).hashCode());
        List<String> $whiteListedGroups = this.getWhiteListedGroups();
        result = result * 59 + ($whiteListedGroups == null ? 43 : ((Object)$whiteListedGroups).hashCode());
        return result;
    }

    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public OffsetDateTime getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public List<String> getSecondaryUrls() {
        return this.secondaryUrls;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public DirectoryType getDirectoryType() {
        return this.directoryType;
    }

    public DsServiceAccount getServiceAccount() {
        return this.serviceAccount;
    }

    public OpenLdapConfig getOpenLdapConfiguration() {
        return this.openLdapConfiguration;
    }

    public GroupSearchType getGroupSearchType() {
        return this.groupSearchType;
    }

    public List<String> getWhiteListedGroups() {
        return this.whiteListedGroups;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="url")
    public void setUrl(String url) {
        this.url = url;
    }

    @JsonProperty(value="secondaryUrls")
    public void setSecondaryUrls(List<String> secondaryUrls) {
        this.secondaryUrls = secondaryUrls;
    }

    @JsonProperty(value="domainName")
    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    @JsonProperty(value="directoryType")
    public void setDirectoryType(DirectoryType directoryType) {
        this.directoryType = directoryType;
    }

    @JsonProperty(value="serviceAccount")
    public void setServiceAccount(DsServiceAccount serviceAccount) {
        this.serviceAccount = serviceAccount;
    }

    @JsonProperty(value="openLdapConfiguration")
    public void setOpenLdapConfiguration(OpenLdapConfig openLdapConfiguration) {
        this.openLdapConfiguration = openLdapConfiguration;
    }

    @JsonProperty(value="groupSearchType")
    public void setGroupSearchType(GroupSearchType groupSearchType) {
        this.groupSearchType = groupSearchType;
    }

    @JsonProperty(value="whiteListedGroups")
    public void setWhiteListedGroups(List<String> whiteListedGroups) {
        this.whiteListedGroups = whiteListedGroups;
    }

    @Override
    public String toString() {
        return "DirectoryService(createdTime=" + this.getCreatedTime() + ", lastUpdatedTime=" + this.getLastUpdatedTime() + ", createdBy=" + this.getCreatedBy() + ", name=" + this.getName() + ", url=" + this.getUrl() + ", secondaryUrls=" + this.getSecondaryUrls() + ", domainName=" + this.getDomainName() + ", directoryType=" + (Object)((Object)this.getDirectoryType()) + ", serviceAccount=" + this.getServiceAccount() + ", openLdapConfiguration=" + this.getOpenLdapConfiguration() + ", groupSearchType=" + (Object)((Object)this.getGroupSearchType()) + ", whiteListedGroups=" + this.getWhiteListedGroups() + ")";
    }

    public static class DirectoryServiceBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String name;
        private String url;
        private List<String> secondaryUrls;
        private String domainName;
        private DirectoryType directoryType;
        private DsServiceAccount serviceAccount;
        private OpenLdapConfig openLdapConfiguration;
        private GroupSearchType groupSearchType;
        private List<String> whiteListedGroups;
        private OffsetDateTime createdTime;
        private OffsetDateTime lastUpdatedTime;
        private String createdBy;

        DirectoryServiceBuilder() {
        }

        public DirectoryServiceBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public DirectoryServiceBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public DirectoryServiceBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public DirectoryServiceBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DirectoryServiceBuilder url(String url) {
            this.url = url;
            return this;
        }

        public DirectoryServiceBuilder secondaryUrls(List<String> secondaryUrls) {
            this.secondaryUrls = secondaryUrls;
            return this;
        }

        public DirectoryServiceBuilder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public DirectoryServiceBuilder directoryType(DirectoryType directoryType) {
            this.directoryType = directoryType;
            return this;
        }

        public DirectoryServiceBuilder serviceAccount(DsServiceAccount serviceAccount) {
            this.serviceAccount = serviceAccount;
            return this;
        }

        public DirectoryServiceBuilder openLdapConfiguration(OpenLdapConfig openLdapConfiguration) {
            this.openLdapConfiguration = openLdapConfiguration;
            return this;
        }

        public DirectoryServiceBuilder groupSearchType(GroupSearchType groupSearchType) {
            this.groupSearchType = groupSearchType;
            return this;
        }

        public DirectoryServiceBuilder whiteListedGroups(List<String> whiteListedGroups) {
            this.whiteListedGroups = whiteListedGroups;
            return this;
        }

        public DirectoryServiceBuilder createdTime(OffsetDateTime createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public DirectoryServiceBuilder lastUpdatedTime(OffsetDateTime lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public DirectoryServiceBuilder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public DirectoryService build() {
            return new DirectoryService(this.tenantId, this.extId, this.links, this.name, this.url, this.secondaryUrls, this.domainName, this.directoryType, this.serviceAccount, this.openLdapConfiguration, this.groupSearchType, this.whiteListedGroups, this.createdTime, this.lastUpdatedTime, this.createdBy);
        }

        public String toString() {
            return "DirectoryService.DirectoryServiceBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", name=" + this.name + ", url=" + this.url + ", secondaryUrls=" + this.secondaryUrls + ", domainName=" + this.domainName + ", directoryType=" + (Object)((Object)this.directoryType) + ", serviceAccount=" + this.serviceAccount + ", openLdapConfiguration=" + this.openLdapConfiguration + ", groupSearchType=" + (Object)((Object)this.groupSearchType) + ", whiteListedGroups=" + this.whiteListedGroups + ", createdTime=" + this.createdTime + ", lastUpdatedTime=" + this.lastUpdatedTime + ", createdBy=" + this.createdBy + ")";
        }
    }
}

