/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client;

import com.ning.http.client.AsyncCompletionHandlerBase;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Param;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.RequestBuilderBase;
import com.ning.http.client.Response;
import com.ning.http.client.SignatureCalculator;
import com.ning.http.client.cookie.Cookie;
import com.ning.http.client.filter.FilterContext;
import com.ning.http.client.filter.FilterException;
import com.ning.http.client.filter.RequestFilter;
import com.ning.http.client.multipart.Part;
import com.ning.http.client.providers.jdk.JDKAsyncHttpProvider;
import com.ning.http.client.resumable.ResumableAsyncHandler;
import java.io.Closeable;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncHttpClient
implements Closeable {
    private static final String DEFAULT_PROVIDER = "com.ning.http.client.providers.netty.NettyAsyncHttpProvider";
    private final AsyncHttpProvider httpProvider;
    private final AsyncHttpClientConfig config;
    private static final Logger logger = LoggerFactory.getLogger(AsyncHttpClient.class);
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    protected SignatureCalculator signatureCalculator;

    public AsyncHttpClient() {
        this(new AsyncHttpClientConfig.Builder().build());
    }

    public AsyncHttpClient(AsyncHttpProvider provider) {
        this(provider, new AsyncHttpClientConfig.Builder().build());
    }

    public AsyncHttpClient(AsyncHttpClientConfig config) {
        this(AsyncHttpClient.loadDefaultProvider(DEFAULT_PROVIDER, config), config);
    }

    public AsyncHttpClient(AsyncHttpProvider httpProvider, AsyncHttpClientConfig config) {
        this.config = config;
        this.httpProvider = httpProvider;
    }

    public AsyncHttpClient(String providerClass, AsyncHttpClientConfig config) {
        this.config = new AsyncHttpClientConfig.Builder().build();
        this.httpProvider = AsyncHttpClient.loadDefaultProvider(providerClass, config);
    }

    public AsyncHttpProvider getProvider() {
        return this.httpProvider;
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            this.httpProvider.close();
        }
    }

    public void closeAsynchronously() {
        final ExecutorService e = Executors.newSingleThreadExecutor();
        e.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    AsyncHttpClient.this.close();
                }
                catch (Throwable t) {
                    logger.warn("", t);
                }
                finally {
                    e.shutdown();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.isClosed.get()) {
                logger.debug("AsyncHttpClient.close() hasn't been invoked, which may produce file descriptor leaks");
            }
        }
        finally {
            super.finalize();
        }
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    public AsyncHttpClientConfig getConfig() {
        return this.config;
    }

    public AsyncHttpClient setSignatureCalculator(SignatureCalculator signatureCalculator) {
        this.signatureCalculator = signatureCalculator;
        return this;
    }

    public BoundRequestBuilder prepareGet(String url) {
        return this.requestBuilder("GET", url);
    }

    public BoundRequestBuilder prepareConnect(String url) {
        return this.requestBuilder("CONNECT", url);
    }

    public BoundRequestBuilder prepareOptions(String url) {
        return this.requestBuilder("OPTIONS", url);
    }

    public BoundRequestBuilder prepareHead(String url) {
        return this.requestBuilder("HEAD", url);
    }

    public BoundRequestBuilder preparePost(String url) {
        return this.requestBuilder("POST", url);
    }

    public BoundRequestBuilder preparePut(String url) {
        return this.requestBuilder("PUT", url);
    }

    public BoundRequestBuilder prepareDelete(String url) {
        return this.requestBuilder("DELETE", url);
    }

    public BoundRequestBuilder preparePatch(String url) {
        return this.requestBuilder("PATCH", url);
    }

    public BoundRequestBuilder prepareTrace(String url) {
        return this.requestBuilder("TRACE", url);
    }

    public BoundRequestBuilder prepareRequest(Request request) {
        return this.requestBuilder(request);
    }

    public <T> ListenableFuture<T> executeRequest(Request request, AsyncHandler<T> handler) {
        if (this.config.getRequestFilters().isEmpty()) {
            return this.httpProvider.execute(request, handler);
        }
        FilterContext fc = new FilterContext.FilterContextBuilder<T>().asyncHandler(handler).request(request).build();
        try {
            fc = this.preProcessRequest(fc);
        }
        catch (Exception e) {
            handler.onThrowable(e);
            return new ListenableFuture.CompletedFailure("preProcessRequest failed", e);
        }
        return this.httpProvider.execute(fc.getRequest(), fc.getAsyncHandler());
    }

    public ListenableFuture<Response> executeRequest(Request request) {
        return this.executeRequest(request, new AsyncCompletionHandlerBase());
    }

    private <T> FilterContext<T> preProcessRequest(FilterContext<T> fc) throws FilterException {
        for (RequestFilter asyncFilter : this.config.getRequestFilters()) {
            fc = asyncFilter.filter(fc);
            if (fc != null) continue;
            throw new NullPointerException("FilterContext is null");
        }
        Request request = fc.getRequest();
        if (fc.getAsyncHandler() instanceof ResumableAsyncHandler) {
            request = ((ResumableAsyncHandler)ResumableAsyncHandler.class.cast(fc.getAsyncHandler())).adjustRequestRange(request);
        }
        if (request.getRangeOffset() != 0L) {
            RequestBuilder builder = new RequestBuilder(request);
            builder.setHeader("Range", "bytes=" + request.getRangeOffset() + "-");
            request = builder.build();
        }
        fc = new FilterContext.FilterContextBuilder<T>(fc).request(request).build();
        return fc;
    }

    private static final AsyncHttpProvider loadDefaultProvider(String className, AsyncHttpClientConfig config) {
        try {
            Class<?> providerClass = Thread.currentThread().getContextClassLoader().loadClass(className);
            return (AsyncHttpProvider)providerClass.getDeclaredConstructor(AsyncHttpClientConfig.class).newInstance(config);
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException) {
                InvocationTargetException ite = (InvocationTargetException)t;
                if (logger.isErrorEnabled()) {
                    logger.error("Unable to instantiate provider {}.  Trying other providers.", (Object)className);
                    logger.error(ite.getCause().toString(), ite.getCause());
                }
            }
            try {
                Class<?> providerClass = AsyncHttpClient.class.getClassLoader().loadClass(className);
                return (AsyncHttpProvider)providerClass.getDeclaredConstructor(AsyncHttpClientConfig.class).newInstance(config);
            }
            catch (Throwable throwable) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Default provider not found {}. Using the {}", (Object)DEFAULT_PROVIDER, (Object)JDKAsyncHttpProvider.class.getName());
                }
                return new JDKAsyncHttpProvider(config);
            }
        }
    }

    protected BoundRequestBuilder requestBuilder(String method, String url) {
        return new BoundRequestBuilder(method, this.config.isDisableUrlEncodingForBoundedRequests()).setUrl(url).setSignatureCalculator(this.signatureCalculator);
    }

    protected BoundRequestBuilder requestBuilder(Request prototype) {
        return new BoundRequestBuilder(prototype).setSignatureCalculator(this.signatureCalculator);
    }

    public class BoundRequestBuilder
    extends RequestBuilderBase<BoundRequestBuilder> {
        private BoundRequestBuilder(String method, boolean isDisableUrlEncoding) {
            super(BoundRequestBuilder.class, method, isDisableUrlEncoding);
        }

        private BoundRequestBuilder(Request prototype) {
            super(BoundRequestBuilder.class, prototype);
        }

        public <T> ListenableFuture<T> execute(AsyncHandler<T> handler) {
            return AsyncHttpClient.this.executeRequest(this.build(), handler);
        }

        public ListenableFuture<Response> execute() {
            return AsyncHttpClient.this.executeRequest(this.build(), new AsyncCompletionHandlerBase());
        }

        @Override
        public BoundRequestBuilder addBodyPart(Part part) {
            return (BoundRequestBuilder)super.addBodyPart(part);
        }

        @Override
        public BoundRequestBuilder addCookie(Cookie cookie) {
            return (BoundRequestBuilder)super.addCookie(cookie);
        }

        @Override
        public BoundRequestBuilder addHeader(String name, String value) {
            return (BoundRequestBuilder)super.addHeader(name, value);
        }

        @Override
        public BoundRequestBuilder addFormParam(String key, String value) {
            return (BoundRequestBuilder)super.addFormParam(key, value);
        }

        @Override
        public BoundRequestBuilder addQueryParam(String name, String value) {
            return (BoundRequestBuilder)super.addQueryParam(name, value);
        }

        @Override
        public Request build() {
            return super.build();
        }

        @Override
        public BoundRequestBuilder setBody(byte[] data) {
            return (BoundRequestBuilder)super.setBody(data);
        }

        @Override
        public BoundRequestBuilder setBody(InputStream stream) {
            return (BoundRequestBuilder)super.setBody(stream);
        }

        @Override
        public BoundRequestBuilder setBody(String data) {
            return (BoundRequestBuilder)super.setBody(data);
        }

        @Override
        public BoundRequestBuilder setHeader(String name, String value) {
            return (BoundRequestBuilder)super.setHeader(name, value);
        }

        @Override
        public BoundRequestBuilder setHeaders(FluentCaseInsensitiveStringsMap headers) {
            return (BoundRequestBuilder)super.setHeaders(headers);
        }

        @Override
        public BoundRequestBuilder setHeaders(Map<String, Collection<String>> headers) {
            return (BoundRequestBuilder)super.setHeaders(headers);
        }

        @Override
        public BoundRequestBuilder setFormParams(Map<String, List<String>> params) {
            return (BoundRequestBuilder)super.setFormParams(params);
        }

        @Override
        public BoundRequestBuilder setFormParams(List<Param> params) {
            return (BoundRequestBuilder)super.setFormParams(params);
        }

        @Override
        public BoundRequestBuilder setUrl(String url) {
            return (BoundRequestBuilder)super.setUrl(url);
        }

        @Override
        public BoundRequestBuilder setVirtualHost(String virtualHost) {
            return (BoundRequestBuilder)super.setVirtualHost(virtualHost);
        }

        @Override
        public BoundRequestBuilder setSignatureCalculator(SignatureCalculator signatureCalculator) {
            return (BoundRequestBuilder)super.setSignatureCalculator(signatureCalculator);
        }
    }
}

