/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client;

import com.ning.http.client.AsyncHttpClientConfigDefaults;
import com.ning.http.client.AsyncHttpProviderConfig;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.ProxyServerSelector;
import com.ning.http.client.Realm;
import com.ning.http.client.date.TimeConverter;
import com.ning.http.client.filter.IOExceptionFilter;
import com.ning.http.client.filter.RequestFilter;
import com.ning.http.client.filter.ResponseFilter;
import com.ning.http.util.ProxyUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;

public class AsyncHttpClientConfig {
    protected int connectionTimeout;
    protected int maxConnections;
    protected int maxConnectionsPerHost;
    protected int requestTimeout;
    protected int readTimeout;
    protected int webSocketTimeout;
    protected boolean allowPoolingConnections;
    protected boolean allowPoolingSslConnections;
    protected int pooledConnectionIdleTimeout;
    protected int connectionTTL;
    protected SSLContext sslContext;
    protected HostnameVerifier hostnameVerifier;
    protected boolean acceptAnyCertificate;
    protected boolean followRedirect;
    protected int maxRedirects;
    protected boolean removeQueryParamOnRedirect;
    protected boolean strict302Handling;
    protected ProxyServerSelector proxyServerSelector;
    protected boolean useRelativeURIsWithSSLProxies;
    protected boolean compressionEnabled;
    protected String userAgent;
    protected ExecutorService applicationThreadPool;
    protected Realm realm;
    protected List<RequestFilter> requestFilters;
    protected List<ResponseFilter> responseFilters;
    protected List<IOExceptionFilter> ioExceptionFilters;
    protected int maxRequestRetry;
    protected boolean disableUrlEncodingForBoundRequests;
    protected int ioThreadMultiplier;
    protected TimeConverter timeConverter;
    protected AsyncHttpProviderConfig<?, ?> providerConfig;

    protected AsyncHttpClientConfig() {
    }

    private AsyncHttpClientConfig(int connectionTimeout, int maxConnections, int maxConnectionsPerHost, int requestTimeout, int readTimeout, int webSocketIdleTimeout, boolean allowPoolingConnection, boolean allowSslConnectionPool, int idleConnectionInPoolTimeout, int maxConnectionLifeTime, SSLContext sslContext, HostnameVerifier hostnameVerifier, boolean acceptAnyCertificate, boolean followRedirect, int maxRedirects, boolean removeQueryParamOnRedirect, boolean strict302Handling, ExecutorService applicationThreadPool, ProxyServerSelector proxyServerSelector, boolean useRelativeURIsWithSSLProxies, boolean compressionEnabled, String userAgent, Realm realm, List<RequestFilter> requestFilters, List<ResponseFilter> responseFilters, List<IOExceptionFilter> ioExceptionFilters, int maxRequestRetry, boolean disableUrlEncodingForBoundedRequests, int ioThreadMultiplier, TimeConverter timeConverter, AsyncHttpProviderConfig<?, ?> providerConfig) {
        this.connectionTimeout = connectionTimeout;
        this.maxConnections = maxConnections;
        this.maxConnectionsPerHost = maxConnectionsPerHost;
        this.requestTimeout = requestTimeout;
        this.readTimeout = readTimeout;
        this.webSocketTimeout = webSocketIdleTimeout;
        this.allowPoolingConnections = allowPoolingConnection;
        this.allowPoolingSslConnections = allowSslConnectionPool;
        this.pooledConnectionIdleTimeout = idleConnectionInPoolTimeout;
        this.connectionTTL = maxConnectionLifeTime;
        this.sslContext = sslContext;
        this.hostnameVerifier = hostnameVerifier;
        this.acceptAnyCertificate = acceptAnyCertificate;
        this.followRedirect = followRedirect;
        this.maxRedirects = maxRedirects;
        this.removeQueryParamOnRedirect = removeQueryParamOnRedirect;
        this.strict302Handling = strict302Handling;
        this.proxyServerSelector = proxyServerSelector;
        this.useRelativeURIsWithSSLProxies = useRelativeURIsWithSSLProxies;
        this.compressionEnabled = compressionEnabled;
        this.userAgent = userAgent;
        this.applicationThreadPool = applicationThreadPool == null ? Executors.newCachedThreadPool() : applicationThreadPool;
        this.realm = realm;
        this.requestFilters = requestFilters;
        this.responseFilters = responseFilters;
        this.ioExceptionFilters = ioExceptionFilters;
        this.maxRequestRetry = maxRequestRetry;
        this.disableUrlEncodingForBoundRequests = disableUrlEncodingForBoundedRequests;
        this.ioThreadMultiplier = ioThreadMultiplier;
        this.timeConverter = timeConverter;
        this.providerConfig = providerConfig;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getMaxConnectionsPerHost() {
        return this.maxConnectionsPerHost;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getWebSocketTimeout() {
        return this.webSocketTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getPooledConnectionIdleTimeout() {
        return this.pooledConnectionIdleTimeout;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public boolean isFollowRedirect() {
        return this.followRedirect;
    }

    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    public boolean isAllowPoolingConnections() {
        return this.allowPoolingConnections;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    public ExecutorService executorService() {
        return this.applicationThreadPool;
    }

    public ProxyServerSelector getProxyServerSelector() {
        return this.proxyServerSelector;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public AsyncHttpProviderConfig<?, ?> getAsyncHttpProviderConfig() {
        return this.providerConfig;
    }

    public Realm getRealm() {
        return this.realm;
    }

    public List<RequestFilter> getRequestFilters() {
        return Collections.unmodifiableList(this.requestFilters);
    }

    public List<ResponseFilter> getResponseFilters() {
        return Collections.unmodifiableList(this.responseFilters);
    }

    public List<IOExceptionFilter> getIOExceptionFilters() {
        return Collections.unmodifiableList(this.ioExceptionFilters);
    }

    public int getMaxRequestRetry() {
        return this.maxRequestRetry;
    }

    public boolean isAllowPoolingSslConnections() {
        return this.allowPoolingSslConnections;
    }

    public boolean isDisableUrlEncodingForBoundedRequests() {
        return this.disableUrlEncodingForBoundRequests;
    }

    public boolean isRemoveQueryParamOnRedirect() {
        return this.removeQueryParamOnRedirect;
    }

    public boolean isValid() {
        try {
            return this.applicationThreadPool.isShutdown();
        }
        catch (Exception ignore) {
            return true;
        }
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public int getIoThreadMultiplier() {
        return this.ioThreadMultiplier;
    }

    public boolean isStrict302Handling() {
        return this.strict302Handling;
    }

    public boolean isUseRelativeURIsWithSSLProxies() {
        return this.useRelativeURIsWithSSLProxies;
    }

    public int getConnectionTTL() {
        return this.connectionTTL;
    }

    public TimeConverter getTimeConverter() {
        return this.timeConverter;
    }

    public boolean isAcceptAnyCertificate() {
        return this.acceptAnyCertificate;
    }

    public static class Builder {
        private int connectionTimeout = AsyncHttpClientConfigDefaults.defaultConnectionTimeout();
        private int maxConnections = AsyncHttpClientConfigDefaults.defaultMaxConnections();
        private int maxConnectionsPerHost = AsyncHttpClientConfigDefaults.defaultMaxConnectionsPerHost();
        private int requestTimeout = AsyncHttpClientConfigDefaults.defaultRequestTimeout();
        private int readTimeout = AsyncHttpClientConfigDefaults.defaultReadTimeout();
        private int webSocketTimeout = AsyncHttpClientConfigDefaults.defaultWebSocketTimeout();
        private boolean allowPoolingConnections = AsyncHttpClientConfigDefaults.defaultAllowPoolingConnections();
        private boolean allowPoolingSslConnections = AsyncHttpClientConfigDefaults.defaultAllowPoolingSslConnections();
        private int pooledConnectionIdleTimeout = AsyncHttpClientConfigDefaults.defaultPooledConnectionIdleTimeout();
        private int connectionTTL = AsyncHttpClientConfigDefaults.defaultConnectionTTL();
        private SSLContext sslContext;
        private HostnameVerifier hostnameVerifier = AsyncHttpClientConfigDefaults.defaultHostnameVerifier();
        private boolean acceptAnyCertificate = AsyncHttpClientConfigDefaults.defaultAcceptAnyCertificate();
        private boolean followRedirect = AsyncHttpClientConfigDefaults.defaultFollowRedirect();
        private int maxRedirects = AsyncHttpClientConfigDefaults.defaultMaxRedirects();
        private boolean removeQueryParamOnRedirect = AsyncHttpClientConfigDefaults.defaultRemoveQueryParamOnRedirect();
        private boolean strict302Handling = AsyncHttpClientConfigDefaults.defaultStrict302Handling();
        private ProxyServerSelector proxyServerSelector = null;
        private boolean useProxySelector = AsyncHttpClientConfigDefaults.defaultUseProxySelector();
        private boolean useProxyProperties = AsyncHttpClientConfigDefaults.defaultUseProxyProperties();
        private boolean useRelativeURIsWithSSLProxies = AsyncHttpClientConfigDefaults.defaultUseRelativeURIsWithSSLProxies();
        private boolean compressionEnabled = AsyncHttpClientConfigDefaults.defaultCompressionEnabled();
        private String userAgent = AsyncHttpClientConfigDefaults.defaultUserAgent();
        private ExecutorService applicationThreadPool;
        private Realm realm;
        private final List<RequestFilter> requestFilters = new LinkedList<RequestFilter>();
        private final List<ResponseFilter> responseFilters = new LinkedList<ResponseFilter>();
        private final List<IOExceptionFilter> ioExceptionFilters = new LinkedList<IOExceptionFilter>();
        private int maxRequestRetry = AsyncHttpClientConfigDefaults.defaultMaxRequestRetry();
        private boolean disableUrlEncodingForBoundedRequests = AsyncHttpClientConfigDefaults.defaultDisableUrlEncodingForBoundRequests();
        private int ioThreadMultiplier = AsyncHttpClientConfigDefaults.defaultIoThreadMultiplier();
        private TimeConverter timeConverter;
        private AsyncHttpProviderConfig<?, ?> providerConfig;

        public Builder() {
        }

        public Builder setMaxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder setMaxConnectionsPerHost(int maxConnectionsPerHost) {
            this.maxConnectionsPerHost = maxConnectionsPerHost;
            return this;
        }

        public Builder setConnectionTimeout(int connectionTimeOut) {
            this.connectionTimeout = connectionTimeOut;
            return this;
        }

        public Builder setWebSocketTimeout(int webSocketTimeout) {
            this.webSocketTimeout = webSocketTimeout;
            return this;
        }

        public Builder setReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder setPooledConnectionIdleTimeout(int pooledConnectionIdleTimeout) {
            this.pooledConnectionIdleTimeout = pooledConnectionIdleTimeout;
            return this;
        }

        public Builder setRequestTimeout(int requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this;
        }

        public Builder setFollowRedirect(boolean followRedirect) {
            this.followRedirect = followRedirect;
            return this;
        }

        public Builder setMaxRedirects(int maxRedirects) {
            this.maxRedirects = maxRedirects;
            return this;
        }

        public Builder setCompressionEnabled(boolean compressionEnabled) {
            this.compressionEnabled = compressionEnabled;
            return this;
        }

        public Builder setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder setAllowPoolingConnections(boolean allowPoolingConnections) {
            this.allowPoolingConnections = allowPoolingConnections;
            return this;
        }

        public Builder setExecutorService(ExecutorService applicationThreadPool) {
            this.applicationThreadPool = applicationThreadPool;
            return this;
        }

        public Builder setProxyServerSelector(ProxyServerSelector proxyServerSelector) {
            this.proxyServerSelector = proxyServerSelector;
            return this;
        }

        public Builder setProxyServer(ProxyServer proxyServer) {
            this.proxyServerSelector = ProxyUtils.createProxyServerSelector(proxyServer);
            return this;
        }

        public Builder setSSLContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder setAsyncHttpClientProviderConfig(AsyncHttpProviderConfig<?, ?> providerConfig) {
            this.providerConfig = providerConfig;
            return this;
        }

        public Builder setRealm(Realm realm) {
            this.realm = realm;
            return this;
        }

        public Builder addRequestFilter(RequestFilter requestFilter) {
            this.requestFilters.add(requestFilter);
            return this;
        }

        public Builder removeRequestFilter(RequestFilter requestFilter) {
            this.requestFilters.remove(requestFilter);
            return this;
        }

        public Builder addResponseFilter(ResponseFilter responseFilter) {
            this.responseFilters.add(responseFilter);
            return this;
        }

        public Builder removeResponseFilter(ResponseFilter responseFilter) {
            this.responseFilters.remove(responseFilter);
            return this;
        }

        public Builder addIOExceptionFilter(IOExceptionFilter ioExceptionFilter) {
            this.ioExceptionFilters.add(ioExceptionFilter);
            return this;
        }

        public Builder removeIOExceptionFilter(IOExceptionFilter ioExceptionFilter) {
            this.ioExceptionFilters.remove(ioExceptionFilter);
            return this;
        }

        public Builder setMaxRequestRetry(int maxRequestRetry) {
            this.maxRequestRetry = maxRequestRetry;
            return this;
        }

        public Builder setAllowPoolingSslConnections(boolean allowPoolingSslConnections) {
            this.allowPoolingSslConnections = allowPoolingSslConnections;
            return this;
        }

        public Builder setDisableUrlEncodingForBoundedRequests(boolean disableUrlEncodingForBoundedRequests) {
            this.disableUrlEncodingForBoundedRequests = disableUrlEncodingForBoundedRequests;
            return this;
        }

        public Builder setRemoveQueryParamsOnRedirect(boolean removeQueryParamOnRedirect) {
            this.removeQueryParamOnRedirect = removeQueryParamOnRedirect;
            return this;
        }

        public Builder setUseProxySelector(boolean useProxySelector) {
            this.useProxySelector = useProxySelector;
            return this;
        }

        public Builder setUseProxyProperties(boolean useProxyProperties) {
            this.useProxyProperties = useProxyProperties;
            return this;
        }

        public Builder setIOThreadMultiplier(int multiplier) {
            this.ioThreadMultiplier = multiplier;
            return this;
        }

        public Builder setHostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        public Builder setStrict302Handling(boolean strict302Handling) {
            this.strict302Handling = strict302Handling;
            return this;
        }

        public Builder setUseRelativeURIsWithSSLProxies(boolean useRelativeURIsWithSSLProxies) {
            this.useRelativeURIsWithSSLProxies = useRelativeURIsWithSSLProxies;
            return this;
        }

        public Builder setConnectionTTL(int connectionTTL) {
            this.connectionTTL = connectionTTL;
            return this;
        }

        public Builder setTimeConverter(TimeConverter timeConverter) {
            this.timeConverter = timeConverter;
            return this;
        }

        public Builder setAcceptAnyCertificate(boolean acceptAnyCertificate) {
            this.acceptAnyCertificate = acceptAnyCertificate;
            return this;
        }

        public Builder(AsyncHttpClientConfig prototype) {
            this.allowPoolingConnections = prototype.isAllowPoolingConnections();
            this.providerConfig = prototype.getAsyncHttpProviderConfig();
            this.connectionTimeout = prototype.getConnectionTimeout();
            this.pooledConnectionIdleTimeout = prototype.getPooledConnectionIdleTimeout();
            this.readTimeout = prototype.getReadTimeout();
            this.maxConnectionsPerHost = prototype.getMaxConnectionsPerHost();
            this.connectionTTL = prototype.getConnectionTTL();
            this.maxRedirects = prototype.getMaxRedirects();
            this.maxConnections = prototype.getMaxConnections();
            this.proxyServerSelector = prototype.getProxyServerSelector();
            this.realm = prototype.getRealm();
            this.requestTimeout = prototype.getRequestTimeout();
            this.sslContext = prototype.getSSLContext();
            this.userAgent = prototype.getUserAgent();
            this.followRedirect = prototype.isFollowRedirect();
            this.compressionEnabled = prototype.isCompressionEnabled();
            this.applicationThreadPool = prototype.executorService();
            this.requestFilters.clear();
            this.responseFilters.clear();
            this.ioExceptionFilters.clear();
            this.requestFilters.addAll(prototype.getRequestFilters());
            this.responseFilters.addAll(prototype.getResponseFilters());
            this.ioExceptionFilters.addAll(prototype.getIOExceptionFilters());
            this.disableUrlEncodingForBoundedRequests = prototype.isDisableUrlEncodingForBoundedRequests();
            this.ioThreadMultiplier = prototype.getIoThreadMultiplier();
            this.maxRequestRetry = prototype.getMaxRequestRetry();
            this.allowPoolingSslConnections = prototype.isAllowPoolingConnections();
            this.removeQueryParamOnRedirect = prototype.isRemoveQueryParamOnRedirect();
            this.hostnameVerifier = prototype.getHostnameVerifier();
            this.strict302Handling = prototype.isStrict302Handling();
            this.timeConverter = prototype.timeConverter;
            this.acceptAnyCertificate = prototype.acceptAnyCertificate;
        }

        public AsyncHttpClientConfig build() {
            if (this.applicationThreadPool == null) {
                this.applicationThreadPool = Executors.newCachedThreadPool(new ThreadFactory(){

                    @Override
                    public Thread newThread(Runnable r) {
                        Thread t = new Thread(r, "AsyncHttpClient-Callback");
                        t.setDaemon(true);
                        return t;
                    }
                });
            }
            if (this.proxyServerSelector == null && this.useProxySelector) {
                this.proxyServerSelector = ProxyUtils.getJdkDefaultProxyServerSelector();
            }
            if (this.proxyServerSelector == null && this.useProxyProperties) {
                this.proxyServerSelector = ProxyUtils.createProxyServerSelector(System.getProperties());
            }
            if (this.proxyServerSelector == null) {
                this.proxyServerSelector = ProxyServerSelector.NO_PROXY_SELECTOR;
            }
            return new AsyncHttpClientConfig(this.connectionTimeout, this.maxConnections, this.maxConnectionsPerHost, this.requestTimeout, this.readTimeout, this.webSocketTimeout, this.allowPoolingConnections, this.allowPoolingSslConnections, this.pooledConnectionIdleTimeout, this.connectionTTL, this.sslContext, this.hostnameVerifier, this.acceptAnyCertificate, this.followRedirect, this.maxRedirects, this.removeQueryParamOnRedirect, this.strict302Handling, this.applicationThreadPool, this.proxyServerSelector, this.useRelativeURIsWithSSLProxies, this.compressionEnabled, this.userAgent, this.realm, this.requestFilters, this.responseFilters, this.ioExceptionFilters, this.maxRequestRetry, this.disableUrlEncodingForBoundedRequests, this.ioThreadMultiplier, this.timeConverter, this.providerConfig);
        }
    }
}

