/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.util;

import com.ning.http.util.Base64;
import com.ning.http.util.HostnameChecker;
import com.ning.http.util.ProxyHostnameChecker;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.kerberos.KerberosPrincipal;

public class DefaultHostnameVerifier
implements HostnameVerifier {
    private HostnameChecker checker;
    private HostnameVerifier extraHostnameVerifier;
    private static final Logger log = Logger.getLogger(DefaultHostnameVerifier.class.getName());

    public DefaultHostnameVerifier() {
        this.checker = new ProxyHostnameChecker();
    }

    public DefaultHostnameVerifier(HostnameChecker checker) {
        this.checker = checker;
    }

    public DefaultHostnameVerifier(HostnameVerifier extraHostnameVerifier) {
        this.checker = new ProxyHostnameChecker();
        this.extraHostnameVerifier = extraHostnameVerifier;
    }

    public DefaultHostnameVerifier(HostnameChecker checker, HostnameVerifier extraHostnameVerifier) {
        this.checker = checker;
        this.extraHostnameVerifier = extraHostnameVerifier;
    }

    private boolean hostnameMatches(String hostname, SSLSession session) {
        log.log(Level.FINE, "hostname = {0}, session = {1}", new Object[]{hostname, Base64.encode(session.getId())});
        try {
            Certificate[] peerCertificates = session.getPeerCertificates();
            if (peerCertificates.length == 0) {
                log.log(Level.FINE, "No peer certificates");
                return false;
            }
            if (peerCertificates[0] instanceof X509Certificate) {
                X509Certificate peerCertificate = (X509Certificate)peerCertificates[0];
                log.log(Level.FINE, "peerCertificate = {0}", peerCertificate);
                try {
                    this.checker.match(hostname, peerCertificate);
                    return true;
                }
                catch (CertificateException ex) {
                    log.log(Level.FINE, "Certificate does not match hostname", ex);
                }
            } else {
                log.log(Level.FINE, "Peer does not have any certificates or they aren't X.509");
            }
            return false;
        }
        catch (SSLPeerUnverifiedException ex) {
            log.log(Level.FINE, "Not using certificates for peers, try verifying the principal");
            try {
                Principal peerPrincipal = session.getPeerPrincipal();
                log.log(Level.FINE, "peerPrincipal = {0}", peerPrincipal);
                if (peerPrincipal instanceof KerberosPrincipal) {
                    return this.checker.match(hostname, (KerberosPrincipal)peerPrincipal);
                }
                log.log(Level.FINE, "Can't verify principal, not Kerberos");
            }
            catch (SSLPeerUnverifiedException ex2) {
                log.log(Level.FINE, "Can't verify principal, no principal", ex2);
            }
            return false;
        }
    }

    public boolean verify(String hostname, SSLSession session) {
        if (this.hostnameMatches(hostname, session)) {
            return true;
        }
        return this.extraHostnameVerifier != null && this.extraHostnameVerifier.verify(hostname, session);
    }
}

