/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty.pool;

import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.providers.netty.Channels;
import com.ning.http.client.providers.netty.NettyResponseFuture;
import com.ning.http.client.providers.netty.pool.ChannelPool;
import com.ning.http.util.DateUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultChannelPool
implements ChannelPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultChannelPool.class);
    private final ConcurrentHashMap<String, ConcurrentLinkedQueue<IdleChannel>> poolsPerKey = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, ChannelCreation> channelId2Creation = new ConcurrentHashMap();
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final Timer nettyTimer;
    private final boolean sslConnectionPoolEnabled;
    private final int maxConnectionTTL;
    private final boolean maxConnectionTTLDisabled;
    private final long maxIdleTime;
    private final boolean maxIdleTimeDisabled;
    private final long cleanerPeriod;

    public DefaultChannelPool(AsyncHttpClientConfig config, Timer hashedWheelTimer) {
        this(config.getMaxConnectionsPerHost(), config.getPooledConnectionIdleTimeout(), config.getConnectionTTL(), config.isAllowPoolingSslConnections(), hashedWheelTimer);
    }

    public DefaultChannelPool(int maxConnectionPerHost, long maxIdleTime, int maxConnectionTTL, boolean sslConnectionPoolEnabled, Timer nettyTimer) {
        this.sslConnectionPoolEnabled = sslConnectionPoolEnabled;
        this.maxIdleTime = maxIdleTime;
        this.maxConnectionTTL = maxConnectionTTL;
        this.maxConnectionTTLDisabled = maxConnectionTTL <= 0;
        this.nettyTimer = nettyTimer;
        this.maxIdleTimeDisabled = maxIdleTime <= 0L;
        this.cleanerPeriod = Math.min(this.maxConnectionTTLDisabled ? Long.MAX_VALUE : (long)maxConnectionTTL, this.maxIdleTimeDisabled ? Long.MAX_VALUE : maxIdleTime);
        if (!this.maxConnectionTTLDisabled || !this.maxIdleTimeDisabled) {
            this.scheduleNewIdleChannelDetector(new IdleChannelDetector());
        }
    }

    private void scheduleNewIdleChannelDetector(TimerTask task) {
        this.nettyTimer.newTimeout(task, this.cleanerPeriod, TimeUnit.MILLISECONDS);
    }

    private boolean isTTLExpired(Channel channel, long now) {
        if (this.maxConnectionTTLDisabled) {
            return false;
        }
        ChannelCreation creation = this.channelId2Creation.get(channel.getId());
        return creation == null || now - creation.creationTime >= (long)this.maxConnectionTTL;
    }

    private boolean isRemotelyClosed(Channel channel) {
        return !channel.isConnected() || !channel.isOpen();
    }

    private ConcurrentLinkedQueue<IdleChannel> getPoolForKey(String key) {
        ConcurrentLinkedQueue newPool;
        ConcurrentLinkedQueue<IdleChannel> pool = this.poolsPerKey.get(key);
        if (pool == null && (pool = this.poolsPerKey.putIfAbsent(key, newPool = new ConcurrentLinkedQueue())) == null) {
            pool = newPool;
        }
        return pool;
    }

    @Override
    public boolean offer(Channel channel, String poolKey) {
        if (this.isClosed.get() || !this.sslConnectionPoolEnabled && poolKey.startsWith("https")) {
            return false;
        }
        long now = DateUtils.millisTime();
        if (this.isTTLExpired(channel, now)) {
            return false;
        }
        boolean added = this.getPoolForKey(poolKey).add(new IdleChannel(channel, now));
        if (added) {
            this.channelId2Creation.putIfAbsent(channel.getId(), new ChannelCreation(now, poolKey));
        }
        return added;
    }

    @Override
    public Channel poll(String poolKey) {
        if (!this.sslConnectionPoolEnabled && poolKey.startsWith("https")) {
            return null;
        }
        IdleChannel idleChannel = null;
        ConcurrentLinkedQueue<IdleChannel> pooledConnectionForKey = this.poolsPerKey.get(poolKey);
        if (pooledConnectionForKey != null) {
            while (idleChannel == null && (idleChannel = pooledConnectionForKey.poll()) != null) {
                if (!this.isRemotelyClosed(idleChannel.channel)) continue;
                idleChannel = null;
                LOGGER.trace("Channel not connected or not opened, probably remotely closed!");
            }
        }
        return idleChannel != null ? idleChannel.channel : null;
    }

    @Override
    public boolean removeAll(Channel channel) {
        ChannelCreation creation = this.channelId2Creation.remove(channel.getId());
        return !this.isClosed.get() && creation != null && this.poolsPerKey.get(creation.poolKey).remove(channel);
    }

    @Override
    public boolean isOpen() {
        return !this.isClosed.get();
    }

    @Override
    public void destroy() {
        if (this.isClosed.getAndSet(true)) {
            return;
        }
        for (ConcurrentLinkedQueue<IdleChannel> pool : this.poolsPerKey.values()) {
            for (IdleChannel idleChannel : pool) {
                this.close(idleChannel.channel);
            }
        }
        this.poolsPerKey.clear();
        this.channelId2Creation.clear();
    }

    private void close(Channel channel) {
        try {
            Channels.setDiscard(channel);
            this.channelId2Creation.remove(channel.getId());
            channel.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class IdleChannelDetector
    implements TimerTask {
        private IdleChannelDetector() {
        }

        private boolean isIdleTimeoutExpired(IdleChannel idleChannel, long now) {
            return !DefaultChannelPool.this.maxIdleTimeDisabled && now - idleChannel.start >= DefaultChannelPool.this.maxIdleTime;
        }

        private List<IdleChannel> expiredChannels(ConcurrentLinkedQueue<IdleChannel> pool, long now) {
            List<IdleChannel> idleTimeoutChannels = null;
            for (IdleChannel idleChannel : pool) {
                if (!DefaultChannelPool.this.isTTLExpired(idleChannel.channel, now) && !this.isIdleTimeoutExpired(idleChannel, now) && !DefaultChannelPool.this.isRemotelyClosed(idleChannel.channel)) continue;
                LOGGER.debug("Adding Candidate expired Channel {}", (Object)idleChannel.channel);
                if (idleTimeoutChannels == null) {
                    idleTimeoutChannels = new ArrayList<IdleChannel>();
                }
                idleTimeoutChannels.add(idleChannel);
            }
            return idleTimeoutChannels != null ? idleTimeoutChannels : Collections.emptyList();
        }

        private boolean isChannelCloseable(Channel channel) {
            NettyResponseFuture future;
            Object attachment = Channels.getAttachment(channel);
            if (attachment instanceof NettyResponseFuture && !(future = (NettyResponseFuture)attachment).isDone()) {
                LOGGER.error("Future not in appropriate state %s, not closing", (Object)future);
            }
            return true;
        }

        private final List<IdleChannel> closeChannels(List<IdleChannel> candidates) {
            List<IdleChannel> closedChannels = null;
            for (int i = 0; i < candidates.size(); ++i) {
                IdleChannel idleChannel = candidates.get(i);
                if (this.isChannelCloseable(idleChannel.channel)) continue;
                if (closedChannels == null) {
                    closedChannels = new ArrayList<IdleChannel>(candidates.size());
                    for (int j = 0; j < i; ++j) {
                        closedChannels.add(candidates.get(j));
                    }
                    continue;
                }
                LOGGER.debug("Closing Idle Channel {}", (Object)idleChannel.channel);
                DefaultChannelPool.this.close(idleChannel.channel);
                if (closedChannels == null) continue;
                closedChannels.add(idleChannel);
            }
            return closedChannels != null ? closedChannels : candidates;
        }

        public void run(Timeout timeout) throws Exception {
            if (DefaultChannelPool.this.isClosed.get()) {
                return;
            }
            try {
                if (LOGGER.isDebugEnabled()) {
                    for (String key : DefaultChannelPool.this.poolsPerKey.keySet()) {
                        LOGGER.debug("Entry count for : {} : {}", (Object)key, (Object)((ConcurrentLinkedQueue)DefaultChannelPool.this.poolsPerKey.get(key)).size());
                    }
                }
                long start = DateUtils.millisTime();
                int closedCount = 0;
                int totalCount = 0;
                for (ConcurrentLinkedQueue pool : DefaultChannelPool.this.poolsPerKey.values()) {
                    if (LOGGER.isDebugEnabled()) {
                        totalCount += pool.size();
                    }
                    List<IdleChannel> closedChannels = this.closeChannels(this.expiredChannels(pool, start));
                    pool.removeAll(closedChannels);
                    int poolClosedCount = closedChannels.size();
                    closedCount += poolClosedCount;
                }
                long duration = DateUtils.millisTime() - start;
                LOGGER.debug("Closed {} connections out of {} in {}ms", new Object[]{closedCount, totalCount, duration});
            }
            catch (Throwable t) {
                LOGGER.error("uncaught exception!", t);
            }
            DefaultChannelPool.this.scheduleNewIdleChannelDetector(timeout.getTask());
        }
    }

    private static final class IdleChannel {
        final Channel channel;
        final long start;

        IdleChannel(Channel channel, long start) {
            if (channel == null) {
                throw new NullPointerException("channel");
            }
            this.channel = channel;
            this.start = start;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof IdleChannel && this.channel.equals(((IdleChannel)IdleChannel.class.cast((Object)o)).channel);
        }

        public int hashCode() {
            return this.channel.hashCode();
        }
    }

    private static final class ChannelCreation {
        final long creationTime;
        final String poolKey;

        ChannelCreation(long creationTime, String poolKey) {
            this.creationTime = creationTime;
            this.poolKey = poolKey;
        }
    }
}

