/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty.pool;

import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.providers.netty.Channels;
import com.ning.http.client.providers.netty.CleanupChannelGroup;
import com.ning.http.client.providers.netty.NettyResponseFuture;
import com.ning.http.client.providers.netty.pool.ChannelPool;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.group.ChannelGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelManager.class);
    private final ChannelPool channelPool;
    private final boolean maxTotalConnectionsEnabled;
    private final Semaphore freeChannels;
    private final ChannelGroup openChannels;
    private final int maxConnectionsPerHost;
    private final boolean maxConnectionsPerHostEnabled;
    private final ConcurrentHashMap<String, Semaphore> freeChannelsPerHost;
    private final ConcurrentHashMap<Integer, String> channelId2KeyPool;

    public ChannelManager(AsyncHttpClientConfig config, ChannelPool channelPool) {
        this.channelPool = channelPool;
        boolean bl = this.maxTotalConnectionsEnabled = config.getMaxConnections() > 0;
        if (this.maxTotalConnectionsEnabled) {
            this.openChannels = new CleanupChannelGroup("asyncHttpClient"){

                public boolean remove(Object o) {
                    boolean removed = super.remove(o);
                    if (removed) {
                        Semaphore freeChannelsForHost;
                        String poolKey;
                        ChannelManager.this.freeChannels.release();
                        if (ChannelManager.this.maxConnectionsPerHostEnabled && (poolKey = (String)ChannelManager.this.channelId2KeyPool.remove(((Channel)Channel.class.cast(o)).getId())) != null && (freeChannelsForHost = (Semaphore)ChannelManager.this.freeChannelsPerHost.get(poolKey)) != null) {
                            freeChannelsForHost.release();
                        }
                    }
                    return removed;
                }
            };
            this.freeChannels = new Semaphore(config.getMaxConnections());
        } else {
            this.openChannels = new CleanupChannelGroup("asyncHttpClient");
            this.freeChannels = null;
        }
        this.maxConnectionsPerHost = config.getMaxConnectionsPerHost();
        boolean bl2 = this.maxConnectionsPerHostEnabled = config.getMaxConnectionsPerHost() > 0;
        if (this.maxConnectionsPerHostEnabled) {
            this.freeChannelsPerHost = new ConcurrentHashMap();
            this.channelId2KeyPool = new ConcurrentHashMap();
        } else {
            this.freeChannelsPerHost = null;
            this.channelId2KeyPool = null;
        }
    }

    public final void tryToOfferChannelToPool(Channel channel, boolean keepAlive, String poolKey) {
        if (keepAlive && channel.isReadable()) {
            LOGGER.debug("Adding key: {} for channel {}", (Object)poolKey, (Object)channel);
            this.channelPool.offer(channel, poolKey);
            if (this.maxConnectionsPerHostEnabled) {
                this.channelId2KeyPool.putIfAbsent(channel.getId(), poolKey);
            }
            Channels.setDiscard(channel);
        } else {
            this.closeChannel(channel);
        }
    }

    public Channel poll(String uri) {
        return this.channelPool.poll(uri);
    }

    public boolean removeAll(Channel connection) {
        return this.channelPool.removeAll(connection);
    }

    private boolean tryAcquireGlobal() {
        return !this.maxTotalConnectionsEnabled || this.freeChannels.tryAcquire();
    }

    private Semaphore getFreeConnectionsForHost(String poolKey) {
        Semaphore newFreeConnections;
        Semaphore freeConnections = this.freeChannelsPerHost.get(poolKey);
        if (freeConnections == null && (freeConnections = this.freeChannelsPerHost.putIfAbsent(poolKey, newFreeConnections = new Semaphore(this.maxConnectionsPerHost))) == null) {
            freeConnections = newFreeConnections;
        }
        return freeConnections;
    }

    private boolean tryAcquirePerHost(String poolKey) {
        return !this.maxConnectionsPerHostEnabled || this.getFreeConnectionsForHost(poolKey).tryAcquire();
    }

    public boolean preemptChannel(String poolKey) {
        return this.channelPool.isOpen() && this.tryAcquireGlobal() && this.tryAcquirePerHost(poolKey);
    }

    public void destroy() {
        this.channelPool.destroy();
        this.openChannels.close();
        for (Channel channel : this.openChannels) {
            Object attachment = Channels.getAttachment(channel);
            if (!(attachment instanceof NettyResponseFuture)) continue;
            NettyResponseFuture future = (NettyResponseFuture)attachment;
            future.cancelTimeouts();
        }
    }

    public void closeChannel(Channel channel) {
        this.removeAll(channel);
        Channels.setDiscard(channel);
        if (channel != null) {
            LOGGER.debug("Closing Channel {} ", (Object)channel);
            try {
                channel.close();
            }
            catch (Throwable t) {
                LOGGER.debug("Error closing a connection", t);
            }
            this.openChannels.remove((Object)channel);
        }
    }

    public void abortChannelPreemption(String poolKey) {
        if (this.maxTotalConnectionsEnabled) {
            this.freeChannels.release();
        }
        if (this.maxConnectionsPerHostEnabled) {
            this.getFreeConnectionsForHost(poolKey).release();
        }
    }

    public void registerOpenChannel(Channel channel) {
        this.openChannels.add((Object)channel);
    }
}

