/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.apache;

import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.Response;
import com.ning.http.client.cookie.Cookie;
import com.ning.http.client.cookie.CookieDecoder;
import com.ning.http.client.uri.UriComponents;
import com.ning.http.util.AsyncHttpProviderUtils;
import com.ning.http.util.MiscUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApacheResponse
implements Response {
    private static final String DEFAULT_CHARSET = "ISO-8859-1";
    private final UriComponents uri;
    private final List<HttpResponseBodyPart> bodyParts;
    private final HttpResponseHeaders headers;
    private final HttpResponseStatus status;
    private List<Cookie> cookies;

    public ApacheResponse(HttpResponseStatus status, HttpResponseHeaders headers, List<HttpResponseBodyPart> bodyParts) {
        this.bodyParts = bodyParts;
        this.headers = headers;
        this.status = status;
        this.uri = this.status.getUri();
    }

    @Override
    public int getStatusCode() {
        return this.status.getStatusCode();
    }

    @Override
    public String getStatusText() {
        return this.status.getStatusText();
    }

    @Override
    public byte[] getResponseBodyAsBytes() throws IOException {
        return AsyncHttpProviderUtils.contentToByte(this.bodyParts);
    }

    @Override
    public ByteBuffer getResponseBodyAsByteBuffer() throws IOException {
        return ByteBuffer.wrap(this.getResponseBodyAsBytes());
    }

    @Override
    public String getResponseBody() throws IOException {
        return this.getResponseBody(DEFAULT_CHARSET);
    }

    @Override
    public String getResponseBody(String charset) throws IOException {
        return AsyncHttpProviderUtils.contentToString(this.bodyParts, this.computeCharset(charset));
    }

    @Override
    public InputStream getResponseBodyAsStream() throws IOException {
        return AsyncHttpProviderUtils.contentToInputStream(this.bodyParts);
    }

    @Override
    public String getResponseBodyExcerpt(int maxLength) throws IOException {
        return this.getResponseBodyExcerpt(maxLength, DEFAULT_CHARSET);
    }

    @Override
    public String getResponseBodyExcerpt(int maxLength, String charset) throws IOException {
        String response = AsyncHttpProviderUtils.contentToString(this.bodyParts, charset = this.computeCharset(charset));
        return response.length() <= maxLength ? response : response.substring(0, maxLength);
    }

    private String computeCharset(String charset) {
        String contentType;
        if (charset == null && (contentType = this.getContentType()) != null) {
            charset = AsyncHttpProviderUtils.parseCharset(contentType);
        }
        return charset != null ? charset : DEFAULT_CHARSET;
    }

    @Override
    public UriComponents getUri() {
        return this.uri;
    }

    @Override
    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    @Override
    public String getHeader(String name) {
        return this.headers != null ? this.headers.getHeaders().getFirstValue(name) : null;
    }

    @Override
    public List<String> getHeaders(String name) {
        return this.headers != null ? this.headers.getHeaders().get(name) : Collections.emptyList();
    }

    @Override
    public FluentCaseInsensitiveStringsMap getHeaders() {
        return this.headers != null ? this.headers.getHeaders() : new FluentCaseInsensitiveStringsMap();
    }

    @Override
    public boolean isRedirected() {
        switch (this.status.getStatusCode()) {
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                return true;
            }
        }
        return false;
    }

    @Override
    public List<Cookie> getCookies() {
        if (this.headers == null) {
            return Collections.emptyList();
        }
        if (this.cookies == null) {
            ArrayList<Cookie> localCookies = new ArrayList<Cookie>();
            for (Map.Entry<String, List<String>> header : this.headers.getHeaders().entrySet()) {
                if (!header.getKey().equalsIgnoreCase("Set-Cookie")) continue;
                List<String> v = header.getValue();
                for (String value : v) {
                    Cookie cookie = CookieDecoder.decode(value);
                    localCookies.add(cookie);
                }
            }
            this.cookies = Collections.unmodifiableList(localCookies);
        }
        return this.cookies;
    }

    @Override
    public boolean hasResponseStatus() {
        return this.bodyParts != null;
    }

    @Override
    public boolean hasResponseHeaders() {
        return this.headers != null;
    }

    @Override
    public boolean hasResponseBody() {
        return MiscUtils.isNonEmpty(this.bodyParts);
    }
}

