/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.apache;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.AsyncHttpProviderConfig;
import com.ning.http.client.Body;
import com.ning.http.client.ByteArrayPart;
import com.ning.http.client.FilePart;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.MaxRedirectException;
import com.ning.http.client.Param;
import com.ning.http.client.Part;
import com.ning.http.client.ProgressAsyncHandler;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.StringPart;
import com.ning.http.client.cookie.CookieEncoder;
import com.ning.http.client.filter.FilterContext;
import com.ning.http.client.filter.FilterException;
import com.ning.http.client.filter.IOExceptionFilter;
import com.ning.http.client.filter.ResponseFilter;
import com.ning.http.client.listener.TransferCompletionHandler;
import com.ning.http.client.providers.apache.ApacheAsyncHttpProviderConfig;
import com.ning.http.client.providers.apache.ApacheResponse;
import com.ning.http.client.providers.apache.ApacheResponseBodyPart;
import com.ning.http.client.providers.apache.ApacheResponseFuture;
import com.ning.http.client.providers.apache.ApacheResponseHeaders;
import com.ning.http.client.providers.apache.ApacheResponseStatus;
import com.ning.http.client.resumable.ResumableAsyncHandler;
import com.ning.http.client.uri.UriComponents;
import com.ning.http.util.AsyncHttpProviderUtils;
import com.ning.http.util.MiscUtils;
import com.ning.http.util.ProxyUtils;
import com.ning.http.util.UTF8UrlEncoder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.httpclient.CircularRedirectException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NoHttpResponseException;
import org.apache.commons.httpclient.ProxyHost;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.util.IdleConnectionTimeoutThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApacheAsyncHttpProvider
implements AsyncHttpProvider {
    private static final Logger logger = LoggerFactory.getLogger(ApacheAsyncHttpProvider.class);
    private final AsyncHttpClientConfig config;
    private final AtomicBoolean isClose = new AtomicBoolean(false);
    private IdleConnectionTimeoutThread idleConnectionTimeoutThread;
    private final AtomicInteger maxConnections = new AtomicInteger();
    private final MultiThreadedHttpConnectionManager connectionManager;
    private final HttpClientParams params;
    private final ScheduledExecutorService reaper;

    public ApacheAsyncHttpProvider(AsyncHttpClientConfig config) {
        this.config = config;
        this.connectionManager = new MultiThreadedHttpConnectionManager();
        this.params = new HttpClientParams();
        this.params.setParameter("http.protocol.single-cookie-header", (Object)Boolean.TRUE);
        this.params.setCookiePolicy("compatibility");
        this.params.setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler());
        this.reaper = this.getReaper(config.getAsyncHttpProviderConfig());
    }

    private ScheduledExecutorService getReaper(AsyncHttpProviderConfig<?, ?> providerConfig) {
        ScheduledExecutorService reaper = null;
        if (providerConfig instanceof ApacheAsyncHttpProvider) {
            reaper = ((ApacheAsyncHttpProviderConfig)ApacheAsyncHttpProviderConfig.class.cast(providerConfig)).getReaper();
        }
        if (reaper == null) {
            reaper = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors(), new ThreadFactory(){

                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r, "AsyncHttpClient-Reaper");
                    t.setDaemon(true);
                    return t;
                }
            });
        }
        return reaper;
    }

    @Override
    public <T> ListenableFuture<T> execute(Request request, AsyncHandler<T> handler) throws IOException {
        Realm realm;
        if (this.isClose.get()) {
            throw new IOException("Closed");
        }
        if (handler instanceof ResumableAsyncHandler) {
            request = ((ResumableAsyncHandler)ResumableAsyncHandler.class.cast(handler)).adjustRequestRange(request);
        }
        if (this.config.getMaxConnections() > -1 && this.maxConnections.get() + 1 > this.config.getMaxConnections()) {
            throw new IOException(String.format("Too many connections %s", this.config.getMaxConnections()));
        }
        if (this.idleConnectionTimeoutThread != null) {
            this.idleConnectionTimeoutThread.shutdown();
            this.idleConnectionTimeoutThread = null;
        }
        int requestTimeout = AsyncHttpProviderUtils.requestTimeout(this.config, request);
        if (this.config.getReadTimeout() > 0 && requestTimeout != -1 && requestTimeout < this.config.getReadTimeout()) {
            this.idleConnectionTimeoutThread = new IdleConnectionTimeoutThread();
            this.idleConnectionTimeoutThread.setConnectionTimeout((long)this.config.getReadTimeout());
            this.idleConnectionTimeoutThread.addConnectionManager((HttpConnectionManager)this.connectionManager);
            this.idleConnectionTimeoutThread.start();
        }
        HttpClient httpClient = new HttpClient(this.params, (HttpConnectionManager)this.connectionManager);
        Realm realm2 = realm = request.getRealm() != null ? request.getRealm() : this.config.getRealm();
        if (realm != null) {
            httpClient.getParams().setAuthenticationPreemptive(realm.getUsePreemptiveAuth());
            UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(realm.getPrincipal(), realm.getPassword());
            httpClient.getState().setCredentials(new AuthScope(null, -1, AuthScope.ANY_REALM), (Credentials)defaultcreds);
        }
        HttpMethodBase method = this.createMethod(httpClient, request);
        ApacheResponseFuture<T> f = new ApacheResponseFuture<T>(handler, requestTimeout, request, method);
        f.touch();
        f.setInnerFuture(this.config.executorService().submit(new ApacheClientRunnable<T>(request, handler, method, f, httpClient)));
        this.maxConnections.incrementAndGet();
        return f;
    }

    @Override
    public void close() {
        this.reaper.shutdown();
        if (this.idleConnectionTimeoutThread != null) {
            this.idleConnectionTimeoutThread.shutdown();
            this.idleConnectionTimeoutThread = null;
        }
        if (this.connectionManager != null) {
            try {
                this.connectionManager.shutdown();
            }
            catch (Exception e) {
                logger.error("Error shutting down connection manager", (Throwable)e);
            }
        }
    }

    @Override
    public Response prepareResponse(HttpResponseStatus status, HttpResponseHeaders headers, List<HttpResponseBodyPart> bodyParts) {
        return new ApacheResponse(status, headers, bodyParts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpMethodBase createMethod(HttpClient client, Request request) throws IOException, FileNotFoundException {
        String methodName = request.getMethod();
        DeleteMethod method = null;
        if (methodName.equalsIgnoreCase("POST") || methodName.equalsIgnoreCase("PUT")) {
            PostMethod post = methodName.equalsIgnoreCase("POST") ? new PostMethod(request.getURI().toUrl()) : new PutMethod(request.getURI().toUrl());
            String bodyCharset = request.getBodyEncoding() == null ? "ISO-8859-1" : request.getBodyEncoding();
            post.getParams().setContentCharset("ISO-8859-1");
            if (request.getByteData() != null) {
                post.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(request.getByteData()));
                post.setRequestHeader("Content-Length", String.valueOf(request.getByteData().length));
            } else if (request.getStringData() != null) {
                post.setRequestEntity((RequestEntity)new StringRequestEntity(request.getStringData(), "text/xml", bodyCharset));
                post.setRequestHeader("Content-Length", String.valueOf(request.getStringData().getBytes(bodyCharset).length));
            } else if (request.getStreamData() != null) {
                InputStreamRequestEntity r = new InputStreamRequestEntity(request.getStreamData());
                post.setRequestEntity((RequestEntity)r);
                post.setRequestHeader("Content-Length", String.valueOf(r.getContentLength()));
            } else if (MiscUtils.isNonEmpty(request.getFormParams())) {
                StringBuilder sb = new StringBuilder();
                for (Param param : request.getFormParams()) {
                    String name = param.getName();
                    String value = param.getValue();
                    if (sb.length() > 0) {
                        sb.append("&");
                    }
                    UTF8UrlEncoder.appendEncoded(sb, name);
                    sb.append("=");
                    UTF8UrlEncoder.appendEncoded(sb, value);
                }
                post.setRequestHeader("Content-Length", String.valueOf(sb.length()));
                post.setRequestEntity((RequestEntity)new StringRequestEntity(sb.toString(), "text/xml", "ISO-8859-1"));
                if (!request.getHeaders().containsKey("Content-Type")) {
                    post.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
                }
            } else if (MiscUtils.isNonEmpty(request.getParts())) {
                MultipartRequestEntity mre = this.createMultipartRequestEntity(bodyCharset, request.getParts(), post.getParams());
                post.setRequestEntity((RequestEntity)mre);
                post.setRequestHeader("Content-Type", mre.getContentType());
                post.setRequestHeader("Content-Length", String.valueOf(mre.getContentLength()));
            } else {
                if (request.getFile() != null) {
                    File file = request.getFile();
                    if (!file.isFile()) {
                        throw new IOException(String.format(Thread.currentThread() + "File %s is not a file or doesn't exist", file.getAbsolutePath()));
                    }
                    post.setRequestHeader("Content-Length", String.valueOf(file.length()));
                    FileInputStream fis = new FileInputStream(file);
                    try {
                        InputStreamRequestEntity r = new InputStreamRequestEntity((InputStream)fis);
                        post.setRequestEntity((RequestEntity)r);
                        post.setRequestHeader("Content-Length", String.valueOf(r.getContentLength()));
                    }
                    finally {
                        fis.close();
                    }
                }
                if (request.getBodyGenerator() != null) {
                    Body body = request.getBodyGenerator().createBody();
                    try {
                        int length = (int)body.getContentLength();
                        if (length < 0) {
                            length = (int)request.getContentLength();
                        }
                        if (length >= 0) {
                            post.setRequestHeader("Content-Length", String.valueOf(length));
                            byte[] bytes = new byte[length];
                            ByteBuffer buffer = ByteBuffer.wrap(bytes);
                            do {
                                buffer.clear();
                            } while (body.read(buffer) >= 0L);
                            post.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(bytes));
                        }
                    }
                    finally {
                        try {
                            body.close();
                        }
                        catch (IOException e) {
                            logger.warn("Failed to close request body: {}", (Object)e.getMessage(), (Object)e);
                        }
                    }
                }
            }
            if (request.getHeaders().getFirstValue("Expect") != null && request.getHeaders().getFirstValue("Expect").equalsIgnoreCase("100-Continue")) {
                post.setUseExpectHeader(true);
            }
            method = post;
        } else if (methodName.equalsIgnoreCase("DELETE")) {
            method = new DeleteMethod(request.getURI().toUrl());
        } else if (methodName.equalsIgnoreCase("HEAD")) {
            method = new HeadMethod(request.getURI().toUrl());
        } else if (methodName.equalsIgnoreCase("GET")) {
            method = new GetMethod(request.getURI().toUrl());
        } else if (methodName.equalsIgnoreCase("OPTIONS")) {
            method = new OptionsMethod(request.getURI().toUrl());
        } else {
            throw new IllegalStateException(String.format("Invalid Method", methodName));
        }
        ProxyServer proxyServer = ProxyUtils.getProxyServer(this.config, request);
        if (proxyServer != null) {
            if (proxyServer.getPrincipal() != null) {
                UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(proxyServer.getPrincipal(), proxyServer.getPassword());
                client.getState().setProxyCredentials(new AuthScope(null, -1, AuthScope.ANY_REALM), (Credentials)defaultcreds);
            }
            ProxyHost proxyHost = proxyServer == null ? null : new ProxyHost(proxyServer.getHost(), proxyServer.getPort());
            client.getHostConfiguration().setProxyHost(proxyHost);
        }
        if (request.getLocalAddress() != null) {
            client.getHostConfiguration().setLocalAddress(request.getLocalAddress());
        }
        method.setFollowRedirects(false);
        if (MiscUtils.isNonEmpty(request.getCookies())) {
            method.setRequestHeader("Cookie", CookieEncoder.encode(request.getCookies()));
        }
        if (request.getHeaders() != null) {
            for (String name : request.getHeaders().keySet()) {
                if ("host".equalsIgnoreCase(name)) continue;
                Iterator<Param> i$ = request.getHeaders().get(name).iterator();
                while (i$.hasNext()) {
                    String value = (String)((Object)i$.next());
                    method.setRequestHeader(name, value);
                }
            }
        }
        if (request.getHeaders().getFirstValue("User-Agent") != null) {
            method.setRequestHeader("User-Agent", request.getHeaders().getFirstValue("User-Agent"));
        } else if (this.config.getUserAgent() != null) {
            method.setRequestHeader("User-Agent", this.config.getUserAgent());
        } else {
            method.setRequestHeader("User-Agent", AsyncHttpProviderUtils.constructUserAgent(ApacheAsyncHttpProvider.class));
        }
        if (this.config.isCompressionEnabled()) {
            Header acceptableEncodingHeader = method.getRequestHeader("Accept-Encoding");
            if (acceptableEncodingHeader != null) {
                String acceptableEncodings = acceptableEncodingHeader.getValue();
                if (acceptableEncodings.indexOf("gzip") == -1) {
                    StringBuilder buf = new StringBuilder(acceptableEncodings);
                    if (buf.length() > 1) {
                        buf.append(",");
                    }
                    buf.append("gzip");
                    method.setRequestHeader("Accept-Encoding", buf.toString());
                }
            } else {
                method.setRequestHeader("Accept-Encoding", "gzip");
            }
        }
        if (request.getVirtualHost() != null) {
            String vs = request.getVirtualHost();
            int index = vs.indexOf(":");
            if (index > 0) {
                vs = vs.substring(0, index);
            }
            method.getParams().setVirtualHost(vs);
        }
        return method;
    }

    private static final int computeAndSetContentLength(Request request, HttpMethodBase m) {
        int lenght = (int)request.getContentLength();
        if (lenght == -1 && m.getRequestHeader("Content-Length") != null) {
            lenght = Integer.valueOf(m.getRequestHeader("Content-Length").getValue());
        }
        if (lenght != -1) {
            m.setRequestHeader("Content-Length", String.valueOf(lenght));
        }
        return lenght;
    }

    private MultipartRequestEntity createMultipartRequestEntity(String charset, List<Part> params, HttpMethodParams methodParams) throws FileNotFoundException {
        org.apache.commons.httpclient.methods.multipart.Part[] parts = new org.apache.commons.httpclient.methods.multipart.Part[params.size()];
        int i = 0;
        for (Part part : params) {
            if (part instanceof StringPart) {
                parts[i] = new org.apache.commons.httpclient.methods.multipart.StringPart(part.getName(), ((StringPart)part).getValue(), charset);
            } else if (part instanceof FilePart) {
                parts[i] = new org.apache.commons.httpclient.methods.multipart.FilePart(part.getName(), ((FilePart)part).getFile(), ((FilePart)part).getMimeType(), ((FilePart)part).getCharSet());
            } else if (part instanceof ByteArrayPart) {
                ByteArrayPartSource source = new ByteArrayPartSource(((ByteArrayPart)part).getFileName(), ((ByteArrayPart)part).getData());
                parts[i] = new org.apache.commons.httpclient.methods.multipart.FilePart(part.getName(), (PartSource)source, ((ByteArrayPart)part).getMimeType(), ((ByteArrayPart)part).getCharSet());
            } else {
                if (part == null) {
                    throw new NullPointerException("Part cannot be null");
                }
                throw new IllegalArgumentException(String.format("Unsupported part type for multipart parameter %s", part.getName()));
            }
            ++i;
        }
        return new MultipartRequestEntity(parts, methodParams);
    }

    static /* synthetic */ ScheduledExecutorService access$200(ApacheAsyncHttpProvider x0) {
        return x0.reaper;
    }

    static /* synthetic */ HttpMethodBase access$300(ApacheAsyncHttpProvider x0, HttpClient x1, Request x2) throws IOException, FileNotFoundException {
        return x0.createMethod(x1, x2);
    }

    static /* synthetic */ AtomicInteger access$500(ApacheAsyncHttpProvider x0) {
        return x0.maxConnections;
    }

    static {
        final TrustingSSLSocketFactory factory = new TrustingSSLSocketFactory();
        Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", new ProtocolSocketFactory(){

            public Socket createSocket(String string, int i, InetAddress inetAddress, int i1) throws IOException {
                return factory.createSocket(string, i, inetAddress, i1);
            }

            public Socket createSocket(String string, int i, InetAddress inetAddress, int i1, HttpConnectionParams httpConnectionParams) throws IOException {
                return factory.createSocket(string, i, inetAddress, i1);
            }

            public Socket createSocket(String string, int i) throws IOException {
                return factory.createSocket(string, i);
            }
        }, 443));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ReaperFuture
    implements Future,
    Runnable {
        private Future scheduledFuture;
        private ApacheResponseFuture<?> apacheResponseFuture;

        public ReaperFuture(ApacheResponseFuture<?> apacheResponseFuture) {
            this.apacheResponseFuture = apacheResponseFuture;
        }

        public void setScheduledFuture(Future scheduledFuture) {
            this.scheduledFuture = scheduledFuture;
        }

        @Override
        public synchronized boolean cancel(boolean mayInterruptIfRunning) {
            this.apacheResponseFuture = null;
            return this.scheduledFuture.cancel(mayInterruptIfRunning);
        }

        public Object get() throws InterruptedException, ExecutionException {
            return this.scheduledFuture.get();
        }

        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.scheduledFuture.get(timeout, unit);
        }

        @Override
        public boolean isCancelled() {
            return this.scheduledFuture.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.scheduledFuture.isDone();
        }

        @Override
        public synchronized void run() {
            if (this.apacheResponseFuture != null && this.apacheResponseFuture.hasExpired()) {
                logger.debug("Request Timeout expired for " + this.apacheResponseFuture);
                int requestTimeout = AsyncHttpProviderUtils.requestTimeout(ApacheAsyncHttpProvider.this.config, this.apacheResponseFuture.getRequest());
                this.apacheResponseFuture.abort(new TimeoutException(String.format("No response received after %s", requestTimeout)));
                this.apacheResponseFuture = null;
            }
        }
    }

    private static class TrustEveryoneTrustManager
    implements X509TrustManager {
        private TrustEveryoneTrustManager() {
        }

        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    private static class TrustingSSLSocketFactory
    extends SSLSocketFactory {
        private SSLSocketFactory delegate;

        private TrustingSSLSocketFactory() {
            try {
                SSLContext sslcontext = SSLContext.getInstance("SSL");
                sslcontext.init(null, new TrustManager[]{new TrustEveryoneTrustManager()}, new SecureRandom());
                this.delegate = sslcontext.getSocketFactory();
            }
            catch (KeyManagementException e) {
                throw new IllegalStateException();
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException();
            }
        }

        public Socket createSocket(String s, int i) throws IOException, UnknownHostException {
            return this.delegate.createSocket(s, i);
        }

        public Socket createSocket(String s, int i, InetAddress inetAddress, int i1) throws IOException, UnknownHostException {
            return this.delegate.createSocket(s, i, inetAddress, i1);
        }

        public Socket createSocket(InetAddress inetAddress, int i) throws IOException {
            return this.delegate.createSocket(inetAddress, i);
        }

        public Socket createSocket(InetAddress inetAddress, int i, InetAddress inetAddress1, int i1) throws IOException {
            return this.delegate.createSocket(inetAddress, i, inetAddress1, i1);
        }

        public String[] getDefaultCipherSuites() {
            return this.delegate.getDefaultCipherSuites();
        }

        public String[] getSupportedCipherSuites() {
            return this.delegate.getSupportedCipherSuites();
        }

        public Socket createSocket(Socket socket, String s, int i, boolean b) throws IOException {
            return this.delegate.createSocket(socket, s, i, b);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ApacheClientRunnable<T>
    implements Callable<T> {
        private final AsyncHandler<T> asyncHandler;
        private HttpMethodBase method;
        private final ApacheResponseFuture<T> future;
        private Request request;
        private final HttpClient httpClient;
        private int currentRedirectCount;
        private AtomicBoolean isAuth = new AtomicBoolean(false);
        private boolean terminate = true;

        public ApacheClientRunnable(Request request, AsyncHandler<T> asyncHandler, HttpMethodBase method, ApacheResponseFuture<T> future, HttpClient httpClient) {
            this.asyncHandler = asyncHandler;
            this.method = method;
            this.future = future;
            this.request = request;
            this.httpClient = httpClient;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        public T call() {
            block50: {
                block45: {
                    block46: {
                        block52: {
                            block42: {
                                block43: {
                                    block44: {
                                        block39: {
                                            block40: {
                                                block41: {
                                                    this.terminate = true;
                                                    state = AsyncHandler.STATE.ABORT;
                                                    uri = this.request.getURI();
                                                    delay = AsyncHttpProviderUtils.requestTimeout(ApacheAsyncHttpProvider.access$100(ApacheAsyncHttpProvider.this), this.future.getRequest());
                                                    if (delay != -1) {
                                                        reaperFuture = new ReaperFuture(this.future);
                                                        scheduledFuture = ApacheAsyncHttpProvider.access$200(ApacheAsyncHttpProvider.this).scheduleAtFixedRate(reaperFuture, delay, 500L, TimeUnit.MILLISECONDS);
                                                        reaperFuture.setScheduledFuture(scheduledFuture);
                                                        this.future.setReaperFuture(reaperFuture);
                                                    }
                                                    if (this.asyncHandler instanceof TransferCompletionHandler) {
                                                        throw new IllegalStateException(TransferCompletionHandler.class.getName() + "not supported by this provider");
                                                    }
                                                    statusCode = 200;
                                                    try {
                                                        statusCode = this.httpClient.executeMethod((HttpMethod)this.method);
                                                    }
                                                    catch (CircularRedirectException ex) {
                                                        statusCode = 302;
                                                        this.currentRedirectCount = ApacheAsyncHttpProvider.access$100(ApacheAsyncHttpProvider.this).getMaxRedirects();
                                                    }
                                                    status = new ApacheResponseStatus(uri, this.method, ApacheAsyncHttpProvider.this);
                                                    fc = new FilterContext.FilterContextBuilder<T>().asyncHandler(this.asyncHandler).request(this.request).responseStatus(status).build();
                                                    for (ResponseFilter asyncFilter : ApacheAsyncHttpProvider.access$100(ApacheAsyncHttpProvider.this).getResponseFilters()) {
                                                        fc = asyncFilter.filter(fc);
                                                        if (fc != null) continue;
                                                        throw new NullPointerException("FilterContext is null");
                                                    }
                                                    if (!fc.replayRequest()) break block39;
                                                    this.request = fc.getRequest();
                                                    this.method = ApacheAsyncHttpProvider.access$300(ApacheAsyncHttpProvider.this, this.httpClient, this.request);
                                                    this.terminate = false;
                                                    i$ /* !! */  = this.call();
                                                    if (!this.terminate) break block40;
                                                    if (ApacheAsyncHttpProvider.access$100(ApacheAsyncHttpProvider.this).getMaxConnections() == -1) break block41;
                                                    ApacheAsyncHttpProvider.access$500(ApacheAsyncHttpProvider.this).decrementAndGet();
                                                }
                                                this.future.done();
                                                ApacheAsyncHttpProvider.access$100(ApacheAsyncHttpProvider.this).executorService().submit(new Runnable(){

                                                    public void run() {
                                                        ApacheClientRunnable.this.method.releaseConnection();
                                                    }
                                                });
                                            }
                                            return (T)i$ /* !! */ ;
                                        }
                                        ApacheAsyncHttpProvider.access$400().debug("\n\nRequest {}\n\nResponse {}\n", (Object)this.request, (Object)this.method);
                                        if (!AsyncHttpProviderUtils.followRedirect(ApacheAsyncHttpProvider.access$100(ApacheAsyncHttpProvider.this), this.request) || statusCode != 302 && statusCode != 301) ** GOTO lbl70
                                        this.isAuth.set(false);
                                        if (this.currentRedirectCount++ >= ApacheAsyncHttpProvider.access$100(ApacheAsyncHttpProvider.this).getMaxRedirects()) ** GOTO lbl69
                                        location = this.method.getResponseHeader("Location").getValue();
                                        rediUri = UriComponents.create(uri, location);
                                        if (rediUri.equals(uri)) break block42;
                                        builder = new RequestBuilder(this.request);
                                        ApacheAsyncHttpProvider.access$400().debug("Redirecting to {}", (Object)rediUri);
                                        this.request = ((RequestBuilder)builder.setURI(rediUri)).build();
                                        this.method = ApacheAsyncHttpProvider.access$300(ApacheAsyncHttpProvider.this, this.httpClient, this.request);
                                        this.terminate = false;
                                        var10_21 = this.call();
                                        if (!this.terminate) break block43;
                                        if (ApacheAsyncHttpProvider.access$100(ApacheAsyncHttpProvider.this).getMaxConnections() == -1) break block44;
                                        ApacheAsyncHttpProvider.access$500(ApacheAsyncHttpProvider.this).decrementAndGet();
                                    }
                                    this.future.done();
                                    ApacheAsyncHttpProvider.access$100(ApacheAsyncHttpProvider.this).executorService().submit(new /* invalid duplicate definition of identical inner class */);
                                }
                                return var10_21;
                            }
                            break block52;
lbl69:
                            // 1 sources

                            throw new MaxRedirectException("Maximum redirect reached: " + ApacheAsyncHttpProvider.access$100(ApacheAsyncHttpProvider.this).getMaxRedirects());
                        }
                        if ((state = this.asyncHandler.onStatusReceived(status)) == AsyncHandler.STATE.CONTINUE) {
                            state = this.asyncHandler.onHeadersReceived(new ApacheResponseHeaders(uri, this.method, ApacheAsyncHttpProvider.this));
                        }
                        if (state == AsyncHandler.STATE.CONTINUE) {
                            is = this.method.getResponseBodyAsStream();
                            if (is != null) {
                                h = this.method.getResponseHeader("Content-Encoding");
                                if (h != null) {
                                    contentEncoding = h.getValue();
                                    v0 = isGZipped = contentEncoding == null ? false : "gzip".equalsIgnoreCase(contentEncoding);
                                    if (isGZipped) {
                                        is = new GZIPInputStream(is);
                                    }
                                }
                                byteToRead = (int)this.method.getResponseContentLength();
                                stream = is;
                                if (byteToRead <= 0) {
                                    lengthWrapper = new int[1];
                                    bytes = AsyncHttpProviderUtils.readFully(is, lengthWrapper);
                                    stream = new ByteArrayInputStream(bytes, 0, lengthWrapper[0]);
                                    byteToRead = lengthWrapper[0];
                                }
                                if (byteToRead > 0) {
                                    minBytes = Math.min(8192, byteToRead);
                                    bytes = new byte[minBytes];
                                    leftBytes = minBytes < 8192 ? minBytes : byteToRead;
                                    read = 0;
                                    while (leftBytes > -1) {
                                        try {
                                            read = stream.read(bytes);
                                        }
                                        catch (IOException ex) {
                                            ApacheAsyncHttpProvider.access$400().warn("Connection closed", (Throwable)ex);
                                            read = -1;
                                        }
                                        if (read == -1) break;
                                        this.future.touch();
                                        b = new byte[read];
                                        System.arraycopy(bytes, 0, b, 0, read);
                                        this.asyncHandler.onBodyPartReceived(new ApacheResponseBodyPart(uri, b, ApacheAsyncHttpProvider.this, (leftBytes -= read) > -1));
                                    }
                                }
                            }
                            if (this.method.getName().equalsIgnoreCase("HEAD")) {
                                this.asyncHandler.onBodyPartReceived(new ApacheResponseBodyPart(uri, "".getBytes(), ApacheAsyncHttpProvider.this, true));
                            }
                        }
                        if (this.asyncHandler instanceof ProgressAsyncHandler) {
                            progressAsyncHandler = (ProgressAsyncHandler)this.asyncHandler;
                            progressAsyncHandler.onHeaderWriteCompleted();
                            progressAsyncHandler.onContentWriteCompleted();
                        }
                        progressAsyncHandler = this.asyncHandler.onCompleted();
                        if (!this.terminate) break block45;
                        if (ApacheAsyncHttpProvider.access$100(ApacheAsyncHttpProvider.this).getMaxConnections() == -1) break block46;
                        ApacheAsyncHttpProvider.access$500(ApacheAsyncHttpProvider.this).decrementAndGet();
                    }
                    this.future.done();
                    ApacheAsyncHttpProvider.access$100(ApacheAsyncHttpProvider.this).executorService().submit(new /* invalid duplicate definition of identical inner class */);
                }
                return (T)progressAsyncHandler;
                {
                    catch (Throwable t) {
                        try {
                            ex = new RuntimeException();
                            ex.initCause(t);
                            throw ex;
                        }
                        catch (Throwable t) {
                            block51: {
                                block47: {
                                    block48: {
                                        block49: {
                                            if (t instanceof IOException && !ApacheAsyncHttpProvider.access$100(ApacheAsyncHttpProvider.this).getIOExceptionFilters().isEmpty()) {
                                                fc = new FilterContext.FilterContextBuilder<T>().asyncHandler(this.asyncHandler).request(this.future.getRequest()).ioException((IOException)IOException.class.cast(t)).build();
                                                try {
                                                    fc = this.handleIoException(fc);
                                                }
                                                catch (FilterException e) {
                                                    if (ApacheAsyncHttpProvider.access$100(ApacheAsyncHttpProvider.this).getMaxConnections() != -1) {
                                                        ApacheAsyncHttpProvider.access$500(ApacheAsyncHttpProvider.this).decrementAndGet();
                                                    }
                                                    this.future.done();
                                                    this.method.releaseConnection();
                                                }
                                                if (fc.replayRequest()) {
                                                    this.request = fc.getRequest();
                                                    var4_11 = this.call();
                                                    if (this.terminate) {
                                                        if (ApacheAsyncHttpProvider.access$100(ApacheAsyncHttpProvider.this).getMaxConnections() != -1) {
                                                            ApacheAsyncHttpProvider.access$500(ApacheAsyncHttpProvider.this).decrementAndGet();
                                                        }
                                                        this.future.done();
                                                        ApacheAsyncHttpProvider.access$100(ApacheAsyncHttpProvider.this).executorService().submit(new /* invalid duplicate definition of identical inner class */);
                                                    }
                                                    return var4_11;
                                                }
                                            }
                                            try {
                                                if (!this.method.isAborted()) break block47;
                                                fc = null;
                                                if (!this.terminate) break block48;
                                                if (ApacheAsyncHttpProvider.access$100(ApacheAsyncHttpProvider.this).getMaxConnections() == -1) break block49;
                                                ApacheAsyncHttpProvider.access$500(ApacheAsyncHttpProvider.this).decrementAndGet();
                                            }
                                            catch (Throwable var16_31) {
                                                if (this.terminate) {
                                                    if (ApacheAsyncHttpProvider.access$100(ApacheAsyncHttpProvider.this).getMaxConnections() != -1) {
                                                        ApacheAsyncHttpProvider.access$500(ApacheAsyncHttpProvider.this).decrementAndGet();
                                                    }
                                                    this.future.done();
                                                    ApacheAsyncHttpProvider.access$100(ApacheAsyncHttpProvider.this).executorService().submit(new /* invalid duplicate definition of identical inner class */);
                                                }
                                                throw var16_31;
                                            }
                                        }
                                        this.future.done();
                                        ApacheAsyncHttpProvider.access$100(ApacheAsyncHttpProvider.this).executorService().submit(new /* invalid duplicate definition of identical inner class */);
                                    }
                                    return fc;
                                }
                                ApacheAsyncHttpProvider.access$400().debug(t.getMessage(), t);
                                try {
                                    this.future.abort(this.filterException(t));
                                }
                                catch (Throwable t2) {
                                    ApacheAsyncHttpProvider.access$400().error(t2.getMessage(), t2);
                                }
                                if (!this.terminate) break block50;
                                if (ApacheAsyncHttpProvider.access$100(ApacheAsyncHttpProvider.this).getMaxConnections() == -1) break block51;
                                ApacheAsyncHttpProvider.access$500(ApacheAsyncHttpProvider.this).decrementAndGet();
                            }
                            this.future.done();
                            ApacheAsyncHttpProvider.access$100(ApacheAsyncHttpProvider.this).executorService().submit(new /* invalid duplicate definition of identical inner class */);
                        }
                    }
                }
            }
            return null;
        }

        private Throwable filterException(Throwable t) {
            if (t instanceof UnknownHostException) {
                t = new ConnectException(t.getMessage());
            } else if (t instanceof NoHttpResponseException) {
                int responseTimeout = AsyncHttpProviderUtils.requestTimeout(ApacheAsyncHttpProvider.this.config, this.request);
                t = new TimeoutException(String.format("No response received after %s", responseTimeout));
            } else if (t instanceof SSLHandshakeException) {
                ConnectException t2 = new ConnectException();
                t2.initCause(t);
                t = t2;
            }
            return t;
        }

        private FilterContext handleIoException(FilterContext fc) throws FilterException {
            for (IOExceptionFilter asyncFilter : ApacheAsyncHttpProvider.this.config.getIOExceptionFilters()) {
                fc = asyncFilter.filter(fc);
                if (fc != null) continue;
                throw new NullPointerException("FilterContext is null");
            }
            return fc;
        }
    }
}

