/*
 * Decompiled with CFR 0.152.
 */
package com.nineoldandroids.view.animation;

import android.graphics.Camera;
import android.graphics.Matrix;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import java.util.WeakHashMap;

public final class AnimatorProxy
extends Animation {
    public static final boolean NEEDS_PROXY = Integer.valueOf(Build.VERSION.SDK) < 11;
    private static final WeakHashMap<View, AnimatorProxy> PROXIES = new WeakHashMap();
    private final View mView;
    private final ViewGroup mViewParent;
    private final Camera mCamera;
    private boolean mHasPivot = false;
    private float mAlpha = 1.0f;
    private float mPivotX = 0.0f;
    private float mPivotY = 0.0f;
    private float mRotationX = 0.0f;
    private float mRotationY = 0.0f;
    private float mRotationZ = 0.0f;
    private float mScaleX = 1.0f;
    private float mScaleY = 1.0f;
    private float mTranslationX = 0.0f;
    private float mTranslationY = 0.0f;

    public static AnimatorProxy wrap(View view) {
        AnimatorProxy proxy = PROXIES.get(view);
        if (proxy == null) {
            proxy = new AnimatorProxy(view);
            PROXIES.put(view, proxy);
        }
        return proxy;
    }

    private AnimatorProxy(View view) {
        this.setDuration(0L);
        this.setFillAfter(true);
        view.setAnimation((Animation)this);
        this.mView = view;
        this.mViewParent = (ViewGroup)view.getParent();
        this.mCamera = new Camera();
    }

    public float getAlpha() {
        return this.mAlpha;
    }

    public void setAlpha(float alpha) {
        this.mAlpha = alpha;
        this.mView.invalidate();
    }

    public float getPivotX() {
        return this.mPivotX;
    }

    public void setPivotX(float pivotX) {
        this.mHasPivot = true;
        if (this.mPivotX != pivotX) {
            this.mPivotX = pivotX;
            this.mViewParent.invalidate();
        }
    }

    public float getPivotY() {
        return this.mPivotY;
    }

    public void setPivotY(float pivotY) {
        this.mHasPivot = true;
        if (this.mPivotY != pivotY) {
            this.mPivotY = pivotY;
            this.mViewParent.invalidate();
        }
    }

    public float getRotation() {
        return this.mRotationZ;
    }

    public void setRotation(float rotation) {
        if (this.mRotationZ != rotation) {
            this.mRotationZ = rotation;
            this.mViewParent.invalidate();
        }
    }

    public float getRotationX() {
        return this.mRotationX;
    }

    public void setRotationX(float rotationX) {
        if (this.mRotationX != rotationX) {
            this.mRotationX = rotationX;
            this.mViewParent.invalidate();
        }
    }

    public float getRotationY() {
        return this.mRotationY;
    }

    public void setRotationY(float rotationY) {
        if (this.mRotationY != rotationY) {
            this.mRotationY = rotationY;
            this.mViewParent.invalidate();
        }
    }

    public float getScaleX() {
        return this.mScaleX;
    }

    public void setScaleX(float scaleX) {
        if (this.mScaleX != scaleX) {
            this.mScaleX = scaleX;
            this.mViewParent.invalidate();
        }
    }

    public float getScaleY() {
        return this.mScaleY;
    }

    public void setScaleY(float scaleY) {
        if (this.mScaleY != scaleY) {
            this.mScaleY = scaleY;
            this.mViewParent.invalidate();
        }
    }

    public int getScrollX() {
        return this.mView.getScrollX();
    }

    public void setScrollX(int value) {
        this.mView.scrollTo(value, this.mView.getScrollY());
    }

    public int getScrollY() {
        return this.mView.getScrollY();
    }

    public void setScrollY(int value) {
        this.mView.scrollTo(this.mView.getScrollY(), value);
    }

    public float getTranslationX() {
        return this.mTranslationX;
    }

    public void setTranslationX(float translationX) {
        if (this.mTranslationX != translationX) {
            this.mTranslationX = translationX;
            this.mViewParent.invalidate();
        }
    }

    public float getTranslationY() {
        return this.mTranslationY;
    }

    public void setTranslationY(float translationY) {
        if (this.mTranslationY != translationY) {
            this.mTranslationY = translationY;
            this.mViewParent.invalidate();
        }
    }

    public float getX() {
        return (float)this.mView.getLeft() + this.mTranslationX;
    }

    public void setX(float x) {
        this.setTranslationX(x - (float)this.mView.getLeft());
    }

    public float getY() {
        return (float)this.mView.getTop() + this.mTranslationY;
    }

    public void setY(float y) {
        this.setTranslationY(y - (float)this.mView.getTop());
    }

    protected void applyTransformation(float interpolatedTime, Transformation t) {
        t.setAlpha(this.mAlpha);
        View view = this.mView;
        float w = view.getWidth();
        float h = view.getHeight();
        Matrix m = t.getMatrix();
        float rX = this.mRotationX;
        float rY = this.mRotationY;
        float rZ = this.mRotationZ;
        if (rX != 0.0f || rY != 0.0f || rZ != 0.0f) {
            Camera camera = this.mCamera;
            boolean hasPivot = this.mHasPivot;
            float pX = hasPivot ? this.mPivotX : w / 2.0f;
            float pY = hasPivot ? this.mPivotY : h / 2.0f;
            camera.save();
            camera.rotateX(rX);
            camera.rotateY(rY);
            camera.rotateZ(-rZ);
            camera.getMatrix(m);
            camera.restore();
            m.preTranslate(-pX, -pY);
            m.postTranslate(pX, pY);
        }
        float sX = this.mScaleX;
        float sY = this.mScaleY;
        if (sX != 0.0f || sX != 0.0f) {
            float deltaSX = (sX * w - w) / 2.0f;
            float deltaSY = (sY * h - h) / 2.0f;
            m.postScale(sX, sY);
            m.postTranslate(-deltaSX, -deltaSY);
        }
        m.postTranslate(this.mTranslationX, this.mTranslationY);
    }
}

