/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.jwk.loader;

import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.util.Base64;
import com.nimbusds.jose.util.X509CertUtils;
import java.security.cert.X509Certificate;
import java.util.Comparator;
import java.util.Date;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class X509CertExpirationComparator
implements Comparator<JWK> {
    @Override
    public int compare(JWK a, JWK b) {
        Base64 certDerEncoded_a = a.getX509CertChain() != null && a.getX509CertChain().size() >= 1 ? (Base64)a.getX509CertChain().get(0) : null;
        Base64 certDerEncoded_b = b.getX509CertChain() != null && b.getX509CertChain().size() >= 1 ? (Base64)b.getX509CertChain().get(0) : null;
        if (certDerEncoded_a == null && certDerEncoded_b == null) {
            return 0;
        }
        if (certDerEncoded_a == null && certDerEncoded_b != null) {
            return -1;
        }
        if (certDerEncoded_a != null && certDerEncoded_b == null) {
            return 1;
        }
        X509Certificate cert_a = X509CertUtils.parse((byte[])certDerEncoded_a.decode());
        if (cert_a == null) {
            throw new IllegalArgumentException("Invalid X.509 certificate for JWK with ID " + a.getKeyID());
        }
        X509Certificate cert_b = X509CertUtils.parse((byte[])certDerEncoded_b.decode());
        if (cert_b == null) {
            throw new IllegalArgumentException("Invalid X.509 certificate for JWK with ID " + b.getKeyID());
        }
        Date exp_a = cert_a.getNotAfter();
        if (exp_a == null) {
            throw new IllegalArgumentException("Missing expiration date in X.509 certificate for JWK with ID " + a.getKeyID());
        }
        Date exp_b = cert_b.getNotAfter();
        if (exp_b == null) {
            throw new IllegalArgumentException("Missing expiration date in X.509 certificate for JWK with ID " + b.getKeyID());
        }
        return exp_a.compareTo(exp_b);
    }
}

