/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.jwk.loader;

import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.loader.Loggers;
import com.nimbusds.jose.jwk.loader.X509CertExpirationComparator;
import com.nimbusds.jose.util.Base64;
import com.nimbusds.jose.util.X509CertUtils;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SigningJWKFeeder<T extends JWK> {
    protected final HashMap<X509Certificate, T> sortedX509Keys = new LinkedHashMap<X509Certificate, T>();
    protected final List<T> plainKeys = new LinkedList<T>();

    private static X509Certificate getCertificate(JWK jwk) {
        if (jwk.getX509CertChain() == null || jwk.getX509CertChain().size() == 0) {
            return null;
        }
        Base64 certBytes = (Base64)jwk.getX509CertChain().get(0);
        if (certBytes == null) {
            throw new IllegalArgumentException("Couldn't parse x.509 certificate from JWK with ID " + jwk.getKeyID() + ": Empty certificate");
        }
        X509Certificate cert = X509CertUtils.parse((byte[])certBytes.decode());
        if (cert == null) {
            throw new IllegalArgumentException("Couldn't parse X.509 certificate from JWK with ID " + jwk.getKeyID());
        }
        if (cert.getNotBefore() == null) {
            throw new IllegalArgumentException("Missing not-before attribute for X.509 certificate for JWK with ID " + jwk.getKeyID());
        }
        if (cert.getNotAfter() == null) {
            throw new IllegalArgumentException("Missing not-after attribute for X.509 certificate for JWK with ID " + jwk.getKeyID());
        }
        return cert;
    }

    public SigningJWKFeeder(List<T> jwkList) {
        if (jwkList.isEmpty()) {
            throw new IllegalArgumentException("The JWK list must not be empty");
        }
        LinkedList<JWK> x509Keys = new LinkedList<JWK>();
        for (JWK jwk : jwkList) {
            if (!KeyUse.SIGNATURE.equals((Object)jwk.getKeyUse())) {
                throw new IllegalArgumentException("The use of JWK with ID " + jwk.getKeyID() + " must be signature");
            }
            if (SigningJWKFeeder.getCertificate(jwk) != null) {
                x509Keys.add(jwk);
                continue;
            }
            this.plainKeys.add(jwk);
        }
        x509Keys.sort(Collections.reverseOrder(new X509CertExpirationComparator()));
        for (JWK jwk : x509Keys) {
            this.sortedX509Keys.put(SigningJWKFeeder.getCertificate(jwk), jwk);
        }
    }

    public T getJWK() {
        if (!this.sortedX509Keys.isEmpty()) {
            Date now = new Date();
            KeyType keyType = null;
            for (Map.Entry<X509Certificate, T> entry : this.sortedX509Keys.entrySet()) {
                X509Certificate cert = entry.getKey();
                if (now.before(cert.getNotBefore())) continue;
                if (now.before(cert.getNotAfter())) {
                    return (T)((JWK)entry.getValue());
                }
                keyType = ((JWK)entry.getValue()).getKeyType();
            }
            Loggers.MAIN_LOG.error("[SE2000] No signing {} key with active (nbf < now < exp) X.509 certificate, using the first available. Add new key(s)!", keyType);
            return (T)((JWK)this.sortedX509Keys.values().iterator().next());
        }
        return (T)((JWK)this.plainKeys.get(0));
    }

    public int size() {
        return this.sortedX509Keys.size() + this.plainKeys.size();
    }
}

