/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.jwk.loader;

import com.nimbusds.jose.jwk.loader.FileInputStreamSource;
import com.nimbusds.jose.util.Base64URL;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Collectors;

class PKCS11ProviderConfigurationLoader {
    PKCS11ProviderConfigurationLoader() {
    }

    static String load(String pkcs11ConfigSpec, FileInputStreamSource fisSource) {
        InputStream is = fisSource.getInputSteam(pkcs11ConfigSpec);
        String inlineConfig = is != null ? new BufferedReader(new InputStreamReader(is)).lines().collect(Collectors.joining("\n")) : (PKCS11ProviderConfigurationLoader.isLikelyInlineConfig(pkcs11ConfigSpec) ? pkcs11ConfigSpec : new Base64URL(pkcs11ConfigSpec).decodeToString());
        return "--" + inlineConfig;
    }

    static boolean isLikelyInlineConfig(String s) {
        return s.contains("\n") || s.contains("{") || s.contains("}") || s.contains("(") || s.contains(")") || s.contains("*") || s.trim().contains(" ");
    }
}

