/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.jwk.loader;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.loader.FileInputStreamSource;
import com.nimbusds.jose.jwk.loader.JOSEConfiguration;
import com.nimbusds.jose.jwk.loader.JWKMetaLogger;
import com.nimbusds.jose.jwk.loader.JWKSetMerge;
import com.nimbusds.jose.jwk.loader.Loggers;
import com.nimbusds.jose.jwk.loader.PKCS11ProviderConfigurationLoader;
import com.nimbusds.jose.jwk.loader.WeakRSAKeyDetector;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.Security;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class JWKSetLoader {
    public static final String DEFAULT_JWK_SET_FILENAME = "/WEB-INF/jwkSet.json";
    public static final String DEFAULT_JWK_SET_PROPERTY_NAME = "jose.jwkSet";

    public static JWKSet loadPKCS11Keys(String pkcs11Config, char[] keyStorePin) throws JOSEException {
        JWKSet pkcsKeys;
        KeyStore keyStore;
        Provider pkcs11Provider = Security.getProvider("SunPKCS11");
        pkcs11Provider = pkcs11Provider.configure(pkcs11Config);
        Loggers.MAIN_LOG.info("[SE1006] Loaded PKCS#11 provider {}", (Object)pkcs11Provider.getName());
        try {
            keyStore = KeyStore.getInstance("PKCS11", pkcs11Provider);
            keyStore.load(null, keyStorePin);
            Loggers.MAIN_LOG.info("[SE1007] Loaded PKCS#11 key store with {} entries", (Object)keyStore.size());
        }
        catch (Exception e) {
            throw new JOSEException("Couldn't load PKCS#11 key store: " + e.getMessage(), (Throwable)e);
        }
        try {
            pkcsKeys = JWKSet.load((KeyStore)keyStore, null);
            Loggers.MAIN_LOG.info("[SE1009] Extracted JWK set with {} keys from PKCS#11 key store {}", (Object)pkcsKeys.getKeys().size(), (Object)keyStore.getProvider().getName());
        }
        catch (KeyStoreException e) {
            throw new JOSEException("Couldn't load JWK set from PKCS#11 key store: " + e.getMessage(), (Throwable)e);
        }
        ArrayList<Object> pkcsKeyList = new ArrayList<Object>();
        for (JWK jwk : pkcsKeys.getKeys()) {
            if (jwk instanceof RSAKey && jwk.getKeyUse() == null) {
                Loggers.MAIN_LOG.warn("[SE1010] Assuming signature key use for RSA PKCS#11 JWK with ID {}", (Object)jwk.getKeyID());
                pkcsKeyList.add(new RSAKey.Builder((RSAKey)jwk).keyUse(KeyUse.SIGNATURE).build());
                continue;
            }
            if (jwk instanceof ECKey && jwk.getKeyUse() == null) {
                Loggers.MAIN_LOG.warn("[SE1011] Assuming signature key use for EC PKCS#11 JWK with ID {}", (Object)jwk.getKeyID());
                pkcsKeyList.add(new ECKey.Builder((ECKey)jwk).keyUse(KeyUse.SIGNATURE).build());
                continue;
            }
            pkcsKeyList.add(jwk);
        }
        assert (pkcsKeys.getKeys().size() == pkcsKeyList.size());
        pkcsKeys = new JWKSet(pkcsKeyList);
        return pkcsKeys;
    }

    public static JWKSet loadFromDefaultSystemProperty() throws JOSEException {
        return JWKSetLoader.loadFromDefaultProperty(System.getProperties());
    }

    public static JWKSet loadFromDefaultProperty(Properties properties) throws JOSEException {
        return JWKSetLoader.loadFromProperty(properties, DEFAULT_JWK_SET_PROPERTY_NAME);
    }

    public static JWKSet loadFromProperty(Properties properties, String propertyName) throws JOSEException {
        String value = properties.getProperty(propertyName);
        if (null == value || value.trim().isEmpty()) {
            return null;
        }
        if (!value.trim().startsWith("{")) {
            value = new Base64URL(value).decodeToString();
        }
        try {
            return JWKSet.parse((String)value);
        }
        catch (ParseException e) {
            throw new JOSEException("Invalid JWK set: " + e.getMessage(), (Throwable)e);
        }
    }

    public static JWKSet loadFromInputStream(InputStream inputStream) throws JOSEException {
        if (inputStream == null) {
            return null;
        }
        try {
            return JWKSet.parse((String)IOUtils.readInputStreamToString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8));
        }
        catch (IOException | ParseException e) {
            throw new JOSEException(e.getMessage(), (Throwable)e);
        }
    }

    public static JWKSet loadWithDefaultSystemPropertyOverrideAndPKCS11Support(FileInputStreamSource fisSource) {
        return JWKSetLoader.loadWithSystemPropertyOverrideAndPKCS11Support(fisSource, DEFAULT_JWK_SET_FILENAME, DEFAULT_JWK_SET_PROPERTY_NAME);
    }

    public static JWKSet loadWithSystemPropertyOverrideAndPKCS11Support(FileInputStreamSource fisSource, String jwkSetFileName, String propertyName) {
        JOSEConfiguration joseConfig;
        boolean loadedFromSysProp;
        JWKSet jwkSet;
        try {
            jwkSet = JWKSetLoader.loadFromProperty(System.getProperties(), propertyName);
        }
        catch (JOSEException e) {
            String msg = "Couldn't load JWK set from system property: " + propertyName + ": " + e.getMessage();
            Loggers.MAIN_LOG.fatal("[SE1020] {}", (Object)msg, (Object)e);
            throw new RuntimeException(msg, e);
        }
        boolean bl = loadedFromSysProp = jwkSet != null;
        if (!loadedFromSysProp) {
            try {
                jwkSet = JWKSetLoader.loadFromInputStream(fisSource.getInputSteam(jwkSetFileName));
            }
            catch (JOSEException e) {
                String msg = "Couldn't load JWK set file: " + jwkSetFileName + ": " + e.getMessage();
                Loggers.MAIN_LOG.fatal("[SE1000] {}", (Object)msg, (Object)e);
                throw new RuntimeException(msg, e);
            }
            if (jwkSet == null) {
                jwkSet = new JWKSet();
            }
        }
        Loggers.MAIN_LOG.info("[SE1021] Loaded JWK set from {} {} with {} keys", (Object)(loadedFromSysProp ? propertyName : jwkSetFileName), (Object)(loadedFromSysProp ? "system property" : "file resource"), (Object)jwkSet.getKeys().size());
        try {
            joseConfig = JOSEConfiguration.load(fisSource);
        }
        catch (IOException e) {
            String msg = "Couldn't load PKCS#11 configuration: " + e.getMessage();
            Loggers.MAIN_LOG.fatal("[SE1001] {}", (Object)msg, (Object)e);
            throw new RuntimeException(msg, e);
        }
        joseConfig.log(Loggers.MAIN_LOG);
        if (joseConfig.isPKCS11Enabled()) {
            JWKSet pkcsKeys;
            String inlineConfig = PKCS11ProviderConfigurationLoader.load(joseConfig.getPKCS11ConfigurationFile(), fisSource);
            if (inlineConfig.trim().isEmpty()) {
                String msg = "Couldn't find PKCS#11 configuration: " + joseConfig.getPKCS11ConfigurationFile();
                Loggers.MAIN_LOG.fatal("[SE1005] {}", (Object)msg);
                throw new RuntimeException(msg);
            }
            try {
                pkcsKeys = JWKSetLoader.loadPKCS11Keys(inlineConfig, joseConfig.getPKCS11KeyStorePassword());
            }
            catch (JOSEException e) {
                Loggers.MAIN_LOG.fatal("[SE1002] {}", (Object)e.getMessage(), (Object)e);
                throw new RuntimeException(e.getMessage(), e);
            }
            jwkSet = JWKSetMerge.merge(jwkSet, pkcsKeys);
            Loggers.MAIN_LOG.info("[SE1003] Merged PKCS#11 based JWK set with {} keys", (Object)pkcsKeys.getKeys().size());
        }
        JWKMetaLogger.log(jwkSet);
        List<String> idsOfWeakKeys = WeakRSAKeyDetector.findWeakRSAKeys(jwkSet);
        if (!idsOfWeakKeys.isEmpty()) {
            String msg = "Found weak RSA key(s) shorter than 2048 bits with IDs: " + idsOfWeakKeys;
            if (!joseConfig.isAllowWeakKeys()) {
                Loggers.MAIN_LOG.fatal("[SE1030] {}", (Object)msg);
                throw new RuntimeException(msg);
            }
            Loggers.MAIN_LOG.warn("[SE1030] {}", (Object)msg);
        }
        return jwkSet;
    }

    private JWKSetLoader() {
    }
}

