/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.jwk.loader;

import com.nimbusds.jose.jwk.loader.FileInputStreamSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import net.jcip.annotations.Immutable;
import org.apache.logging.log4j.Logger;

@Immutable
class JOSEConfiguration {
    static final String FILENAME = "/WEB-INF/jose.properties";
    private final boolean allowWeakKeys;
    private final boolean pkcs11Enabled;
    private final String pkcs11ConfigFile;
    private final char[] pkcs11KeyStorePassword;

    public JOSEConfiguration() {
        this(new Properties());
    }

    public JOSEConfiguration(Properties props) {
        this(props, false);
    }

    public JOSEConfiguration(Properties props, boolean override) {
        Properties finalProps = new Properties();
        if (props != null) {
            finalProps.putAll((Map<?, ?>)props);
        }
        if (override) {
            System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
                if (key.toString().startsWith("jose.") || key.toString().startsWith("pkcs11.")) {
                    finalProps.put(key, value);
                }
            }));
        }
        this.allowWeakKeys = "true".equalsIgnoreCase(finalProps.getProperty("jose.allowWeakKeys"));
        if ("true".equalsIgnoreCase(finalProps.getProperty("pkcs11.enable"))) {
            this.pkcs11Enabled = true;
            this.pkcs11ConfigFile = finalProps.getProperty("pkcs11.configFile");
            if (this.pkcs11ConfigFile == null || this.pkcs11ConfigFile.trim().isEmpty()) {
                throw new RuntimeException("PKCS#11 is enabled by pkcs11.enable, but no PKCS#11 configuration is specified in pkcs11.configFile");
            }
            String pw = finalProps.getProperty("pkcs11.password");
            this.pkcs11KeyStorePassword = pw == null || pw.trim().isEmpty() ? "".toCharArray() : pw.trim().toCharArray();
        } else {
            this.pkcs11Enabled = false;
            this.pkcs11ConfigFile = null;
            this.pkcs11KeyStorePassword = "".toCharArray();
        }
    }

    boolean isAllowWeakKeys() {
        return this.allowWeakKeys;
    }

    boolean isPKCS11Enabled() {
        return this.pkcs11Enabled;
    }

    String getPKCS11ConfigurationFile() {
        return this.pkcs11ConfigFile;
    }

    char[] getPKCS11KeyStorePassword() {
        return this.pkcs11KeyStorePassword;
    }

    boolean hasPKCS11KeyStorePassword() {
        return this.getPKCS11KeyStorePassword().length > 0;
    }

    void log(Logger logger) {
        if (logger == null) {
            return;
        }
        logger.info("[SE0000] JOSE configuration: Allow weak RSA keys: {}", (Object)this.isAllowWeakKeys());
        logger.info("[SE0001] JOSE configuration: PKCS#11 enabled: {}", (Object)this.isPKCS11Enabled());
        if (this.isPKCS11Enabled()) {
            logger.info("[SE0002] JOSE configuration: PKCS#11 configuration file: {}", (Object)this.getPKCS11ConfigurationFile());
            logger.info("[SE0003] JOSE configuration: PKCS#11 password configured: {}", (Object)this.hasPKCS11KeyStorePassword());
        }
    }

    static JOSEConfiguration load(FileInputStreamSource fisSource) throws IOException {
        InputStream is = fisSource.getInputSteam(FILENAME);
        Properties properties = new Properties();
        if (is != null) {
            properties.load(is);
        }
        return new JOSEConfiguration(properties, true);
    }
}

