package com.nimbusds.jose.jwk.loader;


import java.util.LinkedList;
import java.util.List;

import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;


/**
 * Detector of weak RSA keys (shorter than 2048 bits).
 */
public class WeakRSAKeyDetector {
	
	
	/**
	 * Finds weak RSA keys (shorter than 2048 bits) in the specified JWK
	 * set.
	 *
	 * @param jwkSet The JWK set.
	 *
	 * @return The key IDs of the weak keys, empty list if none found. May
	 *         contain null IDs.
	 */
	public static List<String> findWeakRSAKeys(final JWKSet jwkSet) {
		
		List<String> idsOfWeakKeys = new LinkedList<>();
		
		jwkSet.getKeys().forEach(jwk -> {
			if (jwk instanceof RSAKey) {
				RSAKey rsaJWK = (RSAKey)jwk;
				if (rsaJWK.size() < 2048) {
					idsOfWeakKeys.add(rsaJWK.getKeyID());
				}
			}
		});
		
		return idsOfWeakKeys;
	}
}
