package com.nimbusds.jose.jwk.loader;


import java.util.LinkedList;
import java.util.List;

import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;


/**
 * JWK set merge routine.
 */
public class JWKSetMerge {
	
	
	/**
	 * Merges the specified JWK sets by prefixing any PKCS#11 keys to the
	 * file-based JWK set.
	 *
	 * @param fileJWKSet   The file-based JWK set. Must not be
	 *                     {@code null}.
	 * @param pkcs11JWKSet The PKCS#11 JWK set, {@code null} if none.
	 *
	 * @return The JWK set.
	 */
	public static JWKSet merge(final JWKSet fileJWKSet, final JWKSet pkcs11JWKSet) {
		
		List<JWK> keys = new LinkedList<>();
		
		if (pkcs11JWKSet != null) {
			// Prepend the HSM keys
			keys.addAll(pkcs11JWKSet.getKeys());
		}
		
		keys.addAll(fileJWKSet.getKeys());
		
		return new JWKSet(keys);
	}
	
	
	/**
	 * Prevents public instantiation.
	 */
	private JWKSetMerge() {}
}
