/*
 * nimbus-jose-jwt
 *
 * Copyright 2012-2016, Connect2id Ltd and contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use
 * this file except in compliance with the License. You may obtain a copy of the
 * License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed
 * under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */

package com.nimbusds.jose.crypto.opts;


import com.nimbusds.jose.JWEDecrypterOption;
import com.nimbusds.jose.JWSSignerOption;
import net.jcip.annotations.Immutable;


/**
 * JSON Web Signature (JWS) and JSON Web Encryption (JWE) option to allow weak
 * RSA keys shorter than
 * {@link com.nimbusds.jose.jwk.gen.RSAKeyGenerator#MIN_KEY_SIZE_BITS 2048
 * bits}.
 *
 * @author Vladimir Dzhuvinov
 * @version 2025-07-17
 */
@Immutable
public final class AllowWeakRSAKey implements JWSSignerOption, JWEDecrypterOption {
	
	
	private static final AllowWeakRSAKey SINGLETON = new AllowWeakRSAKey();
	
	
	/**
	 * Returns an instance of this class.
	 *
	 * @return The instance.
	 */
	public static AllowWeakRSAKey getInstance() {
		return SINGLETON;
	}
	
	
	private AllowWeakRSAKey() {}
	
	
	@Override
	public String toString() {
		return "AllowWeakRSAKey";
	}
}
