/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.provider.jwkset.validator;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.crypto.ECDSAVerifier;
import com.nimbusds.jose.crypto.Ed25519Signer;
import com.nimbusds.jose.crypto.Ed25519Verifier;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.OctetKeyPair;
import com.nimbusds.jose.jwk.RSAKey;
import java.security.Provider;

public class SigningJWKValidator {
    private static JWSObject createTestJWSObject(JWSAlgorithm alg) {
        JWSHeader header = new JWSHeader(alg);
        Payload payload = new Payload("test");
        return new JWSObject(header, payload);
    }

    @Deprecated
    public static void testSignAndVerify(RSAKey jwk, Provider jcaProvider) throws JOSEException {
        SigningJWKValidator.testSignAndVerify(jwk, jcaProvider, jcaProvider);
    }

    public static void testSignAndVerify(RSAKey jwk, Provider signProvider, Provider verifyProvider) throws JOSEException {
        if (!jwk.isPrivate()) {
            throw new JOSEException("The RSA JWK (kid=" + jwk.getKeyID() + ") has no private part");
        }
        try {
            RSASSASigner signer = new RSASSASigner(jwk.toPrivateKey(), true);
            if (signProvider != null) {
                signer.getJCAContext().setProvider(signProvider);
            }
            JWSObject jwsObject = SigningJWKValidator.createTestJWSObject(JWSAlgorithm.RS256);
            jwsObject.sign((JWSSigner)signer);
            RSASSAVerifier verifier = new RSASSAVerifier(jwk);
            if (verifyProvider != null) {
                verifier.getJCAContext().setProvider(verifyProvider);
            }
            if (!jwsObject.verify((JWSVerifier)verifier)) {
                throw new JOSEException("Test RSA JWK (kid=" + jwk.getKeyID() + ") signature verification failed");
            }
        }
        catch (Exception e) {
            throw new JOSEException("RSA JWK (kid=" + jwk.getKeyID() + ") validation failed: " + e.getMessage(), (Throwable)e);
        }
    }

    @Deprecated
    public static void testSignAndVerify(ECKey jwk, Provider jcaProvider) throws JOSEException {
        SigningJWKValidator.testSignAndVerify(jwk, jcaProvider, jcaProvider);
    }

    public static void testSignAndVerify(ECKey jwk, Provider signProvider, Provider verifyProvider) throws JOSEException {
        if (!jwk.isPrivate()) {
            throw new JOSEException("The EC JWK (crv=" + jwk.getCurve() + " kid=" + jwk.getKeyID() + ") has no private part");
        }
        try {
            JWSAlgorithm alg;
            ECDSASigner signer = new ECDSASigner(jwk.toPrivateKey(), jwk.getCurve());
            if (signProvider != null) {
                signer.getJCAContext().setProvider(signProvider);
            }
            if (Curve.P_256.equals((Object)jwk.getCurve())) {
                alg = JWSAlgorithm.ES256;
            } else if (Curve.P_384.equals((Object)jwk.getCurve())) {
                alg = JWSAlgorithm.ES384;
            } else if (Curve.P_521.equals((Object)jwk.getCurve())) {
                alg = JWSAlgorithm.ES512;
            } else if (Curve.SECP256K1.equals((Object)jwk.getCurve())) {
                alg = JWSAlgorithm.ES256K;
            } else {
                throw new JOSEException("Unsupported EC JWK (kid=" + jwk.getKeyID() + ") curve: " + jwk.getCurve());
            }
            JWSObject jwsObject = SigningJWKValidator.createTestJWSObject(alg);
            jwsObject.sign((JWSSigner)signer);
            ECDSAVerifier verifier = new ECDSAVerifier(jwk);
            if (verifyProvider != null) {
                verifier.getJCAContext().setProvider(verifyProvider);
            }
            if (!jwsObject.verify((JWSVerifier)verifier)) {
                throw new JOSEException("Test EC JWK (crv=" + jwk.getCurve() + " kid=" + jwk.getKeyID() + ") signature verification failed");
            }
        }
        catch (Exception e) {
            throw new JOSEException("EC JWK (crv=" + jwk.getCurve() + " kid=" + jwk.getKeyID() + ") validation failed: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void testSignAndVerify(OctetKeyPair jwk) throws JOSEException {
        if (!jwk.isPrivate()) {
            throw new JOSEException("The OKP JWK (kid=" + jwk.getKeyID() + ") has not private part");
        }
        try {
            Ed25519Signer signer = new Ed25519Signer(jwk);
            JWSObject jwsObject = SigningJWKValidator.createTestJWSObject(JWSAlgorithm.EdDSA);
            jwsObject.sign((JWSSigner)signer);
            if (!jwsObject.verify((JWSVerifier)new Ed25519Verifier(jwk.toPublicJWK()))) {
                throw new JOSEException("Test Ed25519 JWK (kid=" + jwk.getKeyID() + ") signature verification failed");
            }
        }
        catch (Exception e) {
            throw new JOSEException("Ed25519 JWK (kid=" + jwk.getKeyID() + ") validation failed: " + e.getMessage(), (Throwable)e);
        }
    }
}

