/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.provider.jwkset.validator;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.openid.connect.provider.jwkset.JWKSetSpec;
import java.util.List;

public final class JWKSetValidator {
    public static void validateMinimumRequired(JWKSet jwkSet) throws JOSEException {
        List publicKeys = new JWKSelector(new JWKMatcher.Builder().publicOnly(true).build()).select(jwkSet);
        if (publicKeys.size() > 0) {
            throw new JOSEException("The JWK set must not contain public keys, a complete public / private key pair is required for asymmetric keys");
        }
        JWKMatcher rsaSigningKeyMatcher = JWKSetSpec.RotatedRSASigning.createKeyMatcher(JWSAlgorithm.RS256);
        if (new JWKSelector(rsaSigningKeyMatcher).select(jwkSet).isEmpty()) {
            throw new JOSEException("The JWK set must contain at least one signing RSA key pair with properties: " + rsaSigningKeyMatcher);
        }
        if (new JWKSelector(JWKSetSpec.HMAC.KEY_MATCHER).select(jwkSet).isEmpty()) {
            throw new JOSEException("The JWK set must contain one HMAC secret key with properties: " + JWKSetSpec.HMAC.KEY_MATCHER);
        }
        if (new JWKSelector(JWKSetSpec.SubjectEncryption.KEY_MATCHER).select(jwkSet).isEmpty()) {
            throw new JOSEException("The JWK set must contain one subject encryption AES key with properties: " + JWKSetSpec.SubjectEncryption.KEY_MATCHER);
        }
        if (new JWKSelector(JWKSetSpec.RefreshTokenEncryption.KEY_MATCHER).select(jwkSet).isEmpty()) {
            throw new JOSEException("The JWK set must contain one refresh token encryption AES key with properties: " + JWKSetSpec.RefreshTokenEncryption.KEY_MATCHER);
        }
        if (new JWKSelector(JWKSetSpec.DataEncryption.KEY_MATCHER).select(jwkSet).isEmpty()) {
            throw new JOSEException("The JWK set must contain one data encryption AES key with properties: " + JWKSetSpec.DataEncryption.KEY_MATCHER);
        }
    }
}

