/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.provider.jwkset.gen;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.OctetKeyPair;
import com.nimbusds.jose.jwk.OctetSequenceKey;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.JSONObjectUtils;
import com.nimbusds.openid.connect.provider.jwkset.JWKSetSpec;
import com.nimbusds.openid.connect.provider.jwkset.gen.FederationJWKSetGenerator;
import com.nimbusds.openid.connect.provider.jwkset.gen.KeyIDs;
import com.nimbusds.openid.connect.provider.jwkset.gen.NumberedEventPrinter;
import com.thetransactioncompany.json.pretty.PrettyJson;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class JWKSetGenerator {
    public List<JWK> generateRotatingKeys(KeyIDs reservedKeyIDs, Consumer<String> eventMessageSink) throws JOSEException {
        LinkedList<JWK> keys = new LinkedList<JWK>();
        KeyIDs keyIDs = new KeyIDs();
        keyIDs.addAll(reservedKeyIDs);
        RSAKey rsaKey = JWKSetSpec.RotatedRSASigning.generateKey(keyIDs.addRandomUniqueKeyID());
        keys.add((JWK)rsaKey);
        if (eventMessageSink != null) {
            eventMessageSink.accept("Generated new signing RSA 2048 bit key with ID " + rsaKey.getKeyID());
        }
        for (Curve curve : JWKSetSpec.RotatedECSigning.SUPPORTED_CURVES) {
            ECKey ecKey = JWKSetSpec.RotatedECSigning.generateKey(curve, keyIDs.addRandomUniqueKeyID());
            keys.add((JWK)ecKey);
            if (eventMessageSink == null) continue;
            eventMessageSink.accept("Generated new signing EC " + ecKey.getCurve() + " key with ID " + ecKey.getKeyID());
        }
        OctetKeyPair okp = JWKSetSpec.RotatedEdDSASigning.generateKey(keyIDs.addRandomUniqueKeyID());
        keys.add((JWK)okp);
        if (eventMessageSink != null) {
            eventMessageSink.accept("Generated new signing " + okp.getCurve() + " key with ID " + okp.getKeyID());
        }
        rsaKey = JWKSetSpec.RotatedRSAEncryption.generateKey(keyIDs.addRandomUniqueKeyID());
        keys.add((JWK)rsaKey);
        if (eventMessageSink != null) {
            eventMessageSink.accept("Generated new encryption RSA 2048 bit key with ID " + rsaKey.getKeyID());
        }
        for (Curve crv : JWKSetSpec.RotatedECDHEncryption.SUPPORTED_CURVES) {
            ECKey ecKey = JWKSetSpec.RotatedECDHEncryption.generateKey(crv, keyIDs.addRandomUniqueKeyID());
            keys.add((JWK)ecKey);
            if (eventMessageSink == null) continue;
            eventMessageSink.accept("Generated new encryption EC " + ecKey.getCurve() + " key with ID " + ecKey.getKeyID());
        }
        OctetSequenceKey octetSequenceKey = JWKSetSpec.RotatedAccessTokenDirectEncryption.generateKey(keyIDs.addRandomUniqueKeyID());
        keys.add((JWK)octetSequenceKey);
        if (eventMessageSink != null) {
            eventMessageSink.accept("Generated new symmetric encryption " + JWKSetSpec.RotatedAccessTokenDirectEncryption.KEY_BIT_SIZES[0] + " bit key with ID " + octetSequenceKey.getKeyID());
        }
        return keys;
    }

    public List<JWK> generatePermanentKeys(Consumer<String> eventMessageSink) throws JOSEException {
        LinkedList<JWK> keys = new LinkedList<JWK>();
        OctetSequenceKey hmacKey = JWKSetSpec.HMAC.generateKey();
        keys.add((JWK)hmacKey);
        if (eventMessageSink != null) {
            eventMessageSink.accept("Generated new HMAC SHA 256 bit key with ID " + hmacKey.getKeyID());
        }
        OctetSequenceKey subjectKey = JWKSetSpec.SubjectEncryption.generateKey();
        keys.add((JWK)subjectKey);
        if (eventMessageSink != null) {
            eventMessageSink.accept("Generated new subject encryption AES SIV " + JWKSetSpec.SubjectEncryption.KEY_BIT_SIZES[0] + " bit key with ID " + subjectKey.getKeyID());
        }
        OctetSequenceKey refreshTokenKey = JWKSetSpec.RefreshTokenEncryption.generateKey();
        keys.add((JWK)refreshTokenKey);
        if (eventMessageSink != null) {
            eventMessageSink.accept("Generated new refresh token encryption AES SIV 256 bit key with ID " + refreshTokenKey.getKeyID());
        }
        OctetSequenceKey sessionKey = JWKSetSpec.DataEncryption.generateKey();
        keys.add((JWK)sessionKey);
        if (eventMessageSink != null) {
            eventMessageSink.accept("Generated new session encryption AES 128 bit key with ID " + sessionKey.getKeyID());
        }
        return keys;
    }

    public List<JWK> generateMissingPermanentKeys(JWKSet jwkSet, Consumer<String> eventMessageSink) throws JOSEException {
        LinkedList<JWK> keys = new LinkedList<JWK>();
        if (new JWKSelector(JWKSetSpec.HMAC.KEY_MATCHER).select(jwkSet).isEmpty()) {
            OctetSequenceKey hmacKey = JWKSetSpec.HMAC.generateKey();
            keys.add((JWK)hmacKey);
            if (eventMessageSink != null) {
                eventMessageSink.accept("Generated missing HMAC SHA 256 bit key with ID " + hmacKey.getKeyID());
            }
        }
        if (new JWKSelector(JWKSetSpec.SubjectEncryption.KEY_MATCHER).select(jwkSet).isEmpty()) {
            OctetSequenceKey subjectKey = JWKSetSpec.SubjectEncryption.generateKey();
            keys.add((JWK)subjectKey);
            if (eventMessageSink != null) {
                eventMessageSink.accept("Generated missing subject encryption AES SIV " + JWKSetSpec.SubjectEncryption.KEY_BIT_SIZES[0] + " bit key with ID " + subjectKey.getKeyID());
            }
        }
        if (new JWKSelector(JWKSetSpec.RefreshTokenEncryption.KEY_MATCHER).select(jwkSet).isEmpty()) {
            OctetSequenceKey refreshTokenKey = JWKSetSpec.RefreshTokenEncryption.generateKey();
            keys.add((JWK)refreshTokenKey);
            if (eventMessageSink != null) {
                eventMessageSink.accept("Generated missing refresh token encryption AES SIV 256 bit key with ID " + refreshTokenKey.getKeyID());
            }
        }
        if (new JWKSelector(JWKSetSpec.DataEncryption.KEY_MATCHER).select(jwkSet).isEmpty()) {
            OctetSequenceKey sessionKey = JWKSetSpec.DataEncryption.generateKey();
            keys.add((JWK)sessionKey);
            if (eventMessageSink != null) {
                eventMessageSink.accept("Generated missing session encryption AES 128 bit key with ID " + sessionKey.getKeyID());
            }
        }
        return keys;
    }

    public JWKSet generate(Consumer<String> eventMessageSink) throws JOSEException {
        LinkedList<JWK> keys = new LinkedList<JWK>();
        keys.addAll(this.generateRotatingKeys(new KeyIDs(), eventMessageSink));
        keys.addAll(this.generatePermanentKeys(eventMessageSink));
        return new JWKSet(keys);
    }

    public JWKSet generateAndPrefixNewKeys(JWKSet oldJWKSet, Consumer<String> eventMessageSink) throws Exception {
        List<JWK> keys = this.generateRotatingKeys(new KeyIDs(oldJWKSet), eventMessageSink);
        JWKSet jwkSet = JWKSetGenerator.prefixKeys(oldJWKSet, keys);
        if (eventMessageSink != null) {
            eventMessageSink.accept("Prefixed newly generated keys to existing JWK set");
        }
        return jwkSet;
    }

    private static JWKSet prefixKeys(JWKSet jwkSet, List<JWK> keys) {
        LinkedList<JWK> updatedKeyList = new LinkedList<JWK>();
        updatedKeyList.addAll(keys);
        updatedKeyList.addAll(jwkSet.getKeys());
        return new JWKSet(updatedKeyList);
    }

    private static JWKSet postfixKeys(JWKSet jwkSet, List<JWK> keys) {
        LinkedList<JWK> updatedKeyList = new LinkedList<JWK>();
        updatedKeyList.addAll(jwkSet.getKeys());
        updatedKeyList.addAll(keys);
        return new JWKSet(updatedKeyList);
    }

    static void printUsage() {
        System.out.println("Usage:");
        System.out.println("1) Generate a new Connect2id server JWK set: ");
        System.out.println("   java -jar jwkset-gen.jar jwkSet.json");
        System.out.println("2) Generate a new set of rotating keys and add to an existing Connect2id server\n   JWK set; if a required permanent key is found missing it will also be\n   generated and appended to the JWK set (useful when upgrading to a newer\n   Connect2id server release requiring a new type of permanent key):");
        System.out.println("   java -jar jwkset-gen.jar oldJWKSet.json newJWKSet.json");
        System.out.println("3) BASE64URL encode the output JWK set: ");
        System.out.println("   java -jar -b64 jwkset-gen.jar oldJWKSet.json newJWKSet.json.b64");
        System.out.println("4) Generate a new OpenID Connect Federation 1.0 entity JWK set: ");
        System.out.println("   java -jar jwkset-gen.jar -federation federationJWKSet.json");
        System.out.println("5) Generate a new set of rotating keys and add to an existing OpenID Connect\n   Federation 1.0 entity JWK set: ");
        System.out.println("   java -jar jwkset-gen.jar -federation oldFedJWKSet.json newFedJWKSet.json");
    }

    public static void main(String[] args) {
        String output;
        JWKSet newJWKSet;
        File newJWKSetFile;
        File oldJWKSetFile;
        CommandLine commandLine;
        String softwareVersion = JWKSetGenerator.class.getPackage().getImplementationVersion();
        System.out.println("JWK set generator " + (softwareVersion != null ? "v" + softwareVersion + " " : "") + "for Connect2id server v6.x+");
        Options options = new Options();
        options.addOption("b64", false, "BASE64URL encode the output JWK set");
        options.addOption("federation", false, "Create federation entity JWK set");
        DefaultParser parser = new DefaultParser();
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.err.println("Command line parse error: " + e.getMessage());
            JWKSetGenerator.printUsage();
            return;
        }
        boolean b64Encode = commandLine.hasOption("b64");
        boolean federation = commandLine.hasOption("federation");
        List argList = commandLine.getArgList();
        if (argList.size() == 2) {
            oldJWKSetFile = new File((String)argList.get(0));
            newJWKSetFile = new File((String)argList.get(1));
        } else if (argList.size() == 1) {
            oldJWKSetFile = null;
            newJWKSetFile = new File((String)argList.get(0));
        } else {
            JWKSetGenerator.printUsage();
            return;
        }
        JWKSet oldJWKSet = null;
        if (oldJWKSetFile != null) {
            try {
                oldJWKSet = JWKSet.load((File)oldJWKSetFile);
            }
            catch (IOException | java.text.ParseException e) {
                System.err.println("Couldn't read old JWK set file: " + e.getMessage());
                return;
            }
        }
        Consumer<String> eventMessageSink = new Consumer<String>(){
            private final NumberedEventPrinter printer = new NumberedEventPrinter();

            @Override
            public void accept(String eventMessage) {
                this.printer.print(eventMessage);
            }
        };
        try {
            if (oldJWKSet == null) {
                newJWKSet = federation ? new FederationJWKSetGenerator().generate(eventMessageSink) : new JWKSetGenerator().generate(eventMessageSink);
            } else if (federation) {
                newJWKSet = new FederationJWKSetGenerator().generateAndPrefixNewKeys(oldJWKSet, eventMessageSink);
            } else {
                JWKSetGenerator gen = new JWKSetGenerator();
                newJWKSet = gen.generateAndPrefixNewKeys(oldJWKSet, eventMessageSink);
                List<JWK> missingPermanentKeys = gen.generateMissingPermanentKeys(newJWKSet, eventMessageSink);
                if (!missingPermanentKeys.isEmpty()) {
                    newJWKSet = JWKSetGenerator.postfixKeys(newJWKSet, missingPermanentKeys);
                    eventMessageSink.accept("Appended generated permanent keys to existing JWK set");
                }
            }
        }
        catch (Exception e) {
            System.err.println("Couldn't generate JWK key: " + e.getMessage());
            return;
        }
        String json = JSONObjectUtils.toJSONString((Map)newJWKSet.toJSONObject(false));
        if (b64Encode) {
            output = Base64URL.encode((String)json).toString();
        } else {
            try {
                output = new PrettyJson(PrettyJson.Style.COMPACT).parseAndFormat(json);
            }
            catch (java.text.ParseException e) {
                System.err.println("Couldn't format JSON: " + e.getMessage());
                return;
            }
        }
        try {
            PrintWriter writer = new PrintWriter(newJWKSetFile, "UTF-8");
            writer.write(output);
            writer.write("\n");
            writer.close();
        }
        catch (IOException e) {
            System.err.println("Couldn't write new JWK set file: " + e.getMessage());
        }
    }
}

