/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.provider.jwkset;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.crypto.bc.BouncyCastleProviderSingleton;
import com.nimbusds.jose.crypto.impl.RSASSAProvider;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.OctetKeyPair;
import com.nimbusds.jose.jwk.OctetSequenceKey;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.gen.ECKeyGenerator;
import com.nimbusds.jose.jwk.gen.OctetKeyPairGenerator;
import com.nimbusds.jose.jwk.gen.OctetSequenceKeyGenerator;
import com.nimbusds.jose.jwk.gen.RSAKeyGenerator;
import java.security.Provider;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.crypto.SecretKey;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class JWKSetSpec {
    public static final int[] RSA_KEY_BIT_SIZES = new int[]{1024, 2048, 3072, 4096};

    private static void ensureNotEmpty(JWKSet jwkSet) throws JOSEException {
        if (jwkSet == null || jwkSet.getKeys().isEmpty()) {
            throw new JOSEException("Missing or empty JSON Web Key (JWK) set");
        }
    }

    public static class DataEncryption {
        public static final String KEY_ID = "data-encrypt";
        public static final int KEY_BIT_SIZE = 128;
        public static final JWKMatcher KEY_MATCHER = new JWKMatcher.Builder().keyType(KeyType.OCT).keySize(128).privateOnly(true).keyUse(KeyUse.ENCRYPTION).keyID("data-encrypt").build();

        public static OctetSequenceKey generateKey() throws JOSEException {
            return (OctetSequenceKey)new OctetSequenceKeyGenerator(128).keyUse(KeyUse.ENCRYPTION).keyID(KEY_ID).generate();
        }

        public static OctetSequenceKey loadKey(JWKSet jwkSet) throws JOSEException {
            JWKSetSpec.ensureNotEmpty(jwkSet);
            List keyMatches = new JWKSelector(KEY_MATCHER).select(jwkSet);
            if (keyMatches.isEmpty()) {
                throw new JOSEException("Couldn't find eligible secret JSON Web Key (JWK) for data encryption: Required key ID \"data-encrypt\", required key use \"enc\", required key size 128 bits");
            }
            if (keyMatches.size() > 1) {
                throw new JOSEException("Too many data encryption keys, must be one");
            }
            return (OctetSequenceKey)keyMatches.get(0);
        }

        private DataEncryption() {
        }
    }

    public static class RefreshTokenEncryption {
        public static final String KEY_ID = "refresh-token-encrypt";
        public static final int KEY_BIT_SIZE = 256;
        public static final JWKMatcher KEY_MATCHER = new JWKMatcher.Builder().keyType(KeyType.OCT).keySize(256).privateOnly(true).keyUse(KeyUse.ENCRYPTION).keyID("refresh-token-encrypt").build();

        public static OctetSequenceKey generateKey() throws JOSEException {
            return (OctetSequenceKey)new OctetSequenceKeyGenerator(256).keyUse(KeyUse.ENCRYPTION).keyID(KEY_ID).generate();
        }

        public static SecretKey loadKey(JWKSet jwkSet) throws JOSEException {
            JWKSetSpec.ensureNotEmpty(jwkSet);
            List keyMatches = new JWKSelector(KEY_MATCHER).select(jwkSet);
            if (keyMatches.isEmpty()) {
                throw new JOSEException("Couldn't find eligible secret JSON Web Key (JWK) for refresh token encryption: Required key ID \"refresh-token-encrypt\", required key use \"enc\", required key size 256 bits");
            }
            if (keyMatches.size() > 1) {
                throw new JOSEException("Too many refresh token encryption keys, must be one");
            }
            return ((OctetSequenceKey)keyMatches.get(0)).toSecretKey("AES");
        }

        private RefreshTokenEncryption() {
        }
    }

    public static class SubjectEncryption {
        public static final String KEY_ID = "subject-encrypt";
        public static final int[] KEY_BIT_SIZES = new int[]{256, 384, 512};
        public static final JWKMatcher KEY_MATCHER = new JWKMatcher.Builder().keyType(KeyType.OCT).keySizes(KEY_BIT_SIZES).privateOnly(true).keyUse(KeyUse.ENCRYPTION).keyID("subject-encrypt").build();

        public static OctetSequenceKey generateKey() throws JOSEException {
            return (OctetSequenceKey)new OctetSequenceKeyGenerator(KEY_BIT_SIZES[0]).keyUse(KeyUse.ENCRYPTION).keyID(KEY_ID).generate();
        }

        public static SecretKey loadKey(JWKSet jwkSet) throws JOSEException {
            JWKSetSpec.ensureNotEmpty(jwkSet);
            List keyMatches = new JWKSelector(KEY_MATCHER).select(jwkSet);
            if (keyMatches.isEmpty()) {
                throw new JOSEException("Couldn't find eligible secret JSON Web Key (JWK) for pairwise subject encryption: Required key ID \"subject-encrypt\", required key use \"enc\", required key sizes " + Arrays.toString(KEY_BIT_SIZES) + " bits");
            }
            if (keyMatches.size() > 1) {
                throw new JOSEException("Too many pairwise subject encryption keys, must be one");
            }
            return ((OctetSequenceKey)keyMatches.get(0)).toSecretKey("AES");
        }

        private SubjectEncryption() {
        }
    }

    public static class HMAC {
        public static final String KEY_ID = "hmac";
        public static final int KEY_BIT_SIZE = 256;
        public static final JWKMatcher KEY_MATCHER = new JWKMatcher.Builder().keyType(KeyType.OCT).keySize(256).privateOnly(true).keyUse(KeyUse.SIGNATURE).keyID("hmac").build();

        public static OctetSequenceKey generateKey() throws JOSEException {
            return (OctetSequenceKey)new OctetSequenceKeyGenerator(256).keyUse(KeyUse.SIGNATURE).keyID(KEY_ID).generate();
        }

        public static SecretKey loadKey(JWKSet jwkSet) throws JOSEException {
            JWKSetSpec.ensureNotEmpty(jwkSet);
            List matches = new JWKSelector(KEY_MATCHER).select(jwkSet);
            if (matches.isEmpty()) {
                throw new JOSEException("Couldn't find eligible secret JSON Web Key (JWK) for applying HMAC to objects: Required key ID \"hmac\", required key use \"sig\", required key size 256 bits");
            }
            return ((OctetSequenceKey)matches.get(0)).toSecretKey("HmacSha256");
        }

        private HMAC() {
        }
    }

    public static class RotatedAccessTokenDirectEncryption {
        public static final int[] KEY_BIT_SIZES = new int[]{128, 192, 256, 384, 512};
        @Deprecated
        public static final JWKMatcher KEY_MATCHER = new JWKMatcher.Builder().keyType(KeyType.OCT).keySizes(KEY_BIT_SIZES).privateOnly(true).algorithms(new Algorithm[]{JWEAlgorithm.DIR, null}).keyUses(new KeyUse[]{KeyUse.ENCRYPTION}).hasKeyID(true).build();

        public static JWKMatcher createKeyMatcher(EncryptionMethod enc) {
            return new JWKMatcher.Builder().keyType(KeyType.OCT).keySize(enc.cekBitLength()).privateOnly(true).algorithms(new Algorithm[]{JWEAlgorithm.DIR, null}).keyUses(new KeyUse[]{KeyUse.ENCRYPTION}).hasKeyID(true).build();
        }

        public static OctetSequenceKey generateKey(String kid) throws JOSEException {
            return RotatedAccessTokenDirectEncryption.generateKey(kid, KEY_BIT_SIZES[0]);
        }

        public static OctetSequenceKey generateKey(String kid, int bitSize) throws JOSEException {
            return (OctetSequenceKey)new OctetSequenceKeyGenerator(bitSize).keyUse(KeyUse.ENCRYPTION).keyID(kid).generate();
        }

        @Deprecated
        public static List<OctetSequenceKey> loadKeys(JWKSet jwkSet) {
            List jwkMatches = new JWKSelector(KEY_MATCHER).select(jwkSet);
            LinkedList<OctetSequenceKey> aesMatches = new LinkedList<OctetSequenceKey>();
            jwkMatches.forEach(jwk -> aesMatches.add(jwk.toOctetSequenceKey()));
            return aesMatches;
        }

        public static List<OctetSequenceKey> loadKeys(JWKSet jwkSet, EncryptionMethod enc) {
            List jwkMatches = new JWKSelector(RotatedAccessTokenDirectEncryption.createKeyMatcher(enc)).select(jwkSet);
            LinkedList<OctetSequenceKey> aesMatches = new LinkedList<OctetSequenceKey>();
            jwkMatches.forEach(jwk -> aesMatches.add(jwk.toOctetSequenceKey()));
            return aesMatches;
        }

        private RotatedAccessTokenDirectEncryption() {
        }
    }

    public static class RotatedECDHEncryption {
        public static final Set<Curve> SUPPORTED_CURVES = Collections.unmodifiableSet(new LinkedHashSet<Curve>(Arrays.asList(Curve.P_256, Curve.P_384, Curve.P_521)));
        public static final JWKMatcher KEY_MATCHER = new JWKMatcher.Builder().keyType(KeyType.EC).privateOnly(true).keyUse(KeyUse.ENCRYPTION).hasKeyID(true).build();

        public static ECKey generateKey(Curve crv, String kid) throws JOSEException {
            return (ECKey)new ECKeyGenerator(crv).keyUse(KeyUse.ENCRYPTION).keyID(kid).generate();
        }

        private RotatedECDHEncryption() {
        }
    }

    public static class RotatedRSAEncryption {
        public static final int KEY_BIT_SIZE = 2048;
        public static final JWKMatcher KEY_MATCHER = new JWKMatcher.Builder().keyType(KeyType.RSA).privateOnly(true).keyUse(KeyUse.ENCRYPTION).hasKeyID(true).keySizes(RSA_KEY_BIT_SIZES).build();

        public static RSAKey generateKey(String kid) throws JOSEException {
            return (RSAKey)new RSAKeyGenerator(2048).keyUse(KeyUse.ENCRYPTION).keyID(kid).generate();
        }

        private RotatedRSAEncryption() {
        }
    }

    public static class RotatedEdDSASigning {
        public static final JWKMatcher KEY_MATCHER = new JWKMatcher.Builder().keyType(KeyType.OKP).curve(Curve.Ed25519).privateOnly(true).algorithms(new Algorithm[]{JWSAlgorithm.EdDSA, null}).keyUses(new KeyUse[]{KeyUse.SIGNATURE}).hasKeyID(true).build();

        public static OctetKeyPair generateKey(String kid) throws JOSEException {
            return (OctetKeyPair)new OctetKeyPairGenerator(Curve.Ed25519).keyUse(KeyUse.SIGNATURE).keyID(kid).generate();
        }

        public static List<OctetKeyPair> loadKeys(JWKSet jwkSet) {
            List jwkMatches = new JWKSelector(KEY_MATCHER).select(jwkSet);
            LinkedList<OctetKeyPair> okpMatches = new LinkedList<OctetKeyPair>();
            jwkMatches.forEach(jwk -> okpMatches.add(jwk.toOctetKeyPair()));
            return okpMatches;
        }

        private RotatedEdDSASigning() {
        }
    }

    public static class RotatedECSigning {
        public static final Set<Curve> SUPPORTED_CURVES = Collections.unmodifiableSet(new LinkedHashSet<Curve>(Arrays.asList(Curve.P_256, Curve.P_384, Curve.P_521, Curve.SECP256K1)));

        public static JWKMatcher createKeyMatcher(JWSAlgorithm alg) {
            Set curves = Curve.forJWSAlgorithm((JWSAlgorithm)alg);
            if (curves == null) {
                throw new IllegalArgumentException("Invalid / unsupported EC DSA algorithm: " + alg);
            }
            return new JWKMatcher.Builder().keyType(KeyType.EC).curves(curves).privateOnly(true).algorithms(new Algorithm[]{alg, null}).keyUses(new KeyUse[]{KeyUse.SIGNATURE}).hasKeyID(true).build();
        }

        public static ECKey generateKey(Curve crv, String kid) throws JOSEException {
            return (ECKey)new ECKeyGenerator(crv).keyUse(KeyUse.SIGNATURE).keyID(kid).provider((Provider)BouncyCastleProviderSingleton.getInstance()).generate();
        }

        public static List<ECKey> loadKeys(JWKSet jwkSet, JWSAlgorithm jwsAlg) throws JOSEException {
            JWKSelector jwkSelector;
            try {
                jwkSelector = new JWKSelector(RotatedECSigning.createKeyMatcher(jwsAlg));
            }
            catch (IllegalArgumentException e) {
                throw new JOSEException(e.getMessage());
            }
            List jwkMatches = jwkSelector.select(jwkSet);
            LinkedList<ECKey> ecMatches = new LinkedList<ECKey>();
            jwkMatches.forEach(jwk -> ecMatches.add(jwk.toECKey()));
            return ecMatches;
        }

        private RotatedECSigning() {
        }
    }

    public static class RotatedRSASigning {
        public static final int KEY_BIT_SIZE = 2048;

        public static JWKMatcher createKeyMatcher(@Nullable JWSAlgorithm alg) {
            return new JWKMatcher.Builder().keyType(KeyType.RSA).privateOnly(true).algorithms(new Algorithm[]{alg, null}).keyUses(new KeyUse[]{KeyUse.SIGNATURE}).keySizes(RSA_KEY_BIT_SIZES).hasKeyID(true).build();
        }

        public static RSAKey generateKey(String kid) throws JOSEException {
            return RotatedRSASigning.generateKey(kid, 2048);
        }

        public static RSAKey generateKey(String kid, int keyBitSize) throws JOSEException {
            return (RSAKey)new RSAKeyGenerator(keyBitSize).keyUse(KeyUse.SIGNATURE).keyID(kid).generate();
        }

        public static List<RSAKey> loadKeys(JWKSet jwkSet, JWSAlgorithm jwsAlg) throws JOSEException {
            if (!RSASSAProvider.SUPPORTED_ALGORITHMS.contains(jwsAlg)) {
                throw new JOSEException("Invalid / unsupported RSA signature algorithm: " + jwsAlg);
            }
            List jwkMatches = new JWKSelector(RotatedRSASigning.createKeyMatcher(jwsAlg)).select(jwkSet);
            LinkedList<RSAKey> rsaJWKMatches = new LinkedList<RSAKey>();
            jwkMatches.forEach(jwk -> rsaJWKMatches.add(jwk.toRSAKey()));
            return rsaJWKMatches;
        }

        private RotatedRSASigning() {
        }
    }
}

