/*
 * Decompiled with CFR 0.152.
 */
package com.nfx.android.preferencehelper.preferences;

import android.content.SharedPreferences;
import android.support.annotation.NonNull;

public class LongPreference {
    private final SharedPreferences preferences;
    private final String key;
    private final long defaultValue;

    public LongPreference(@NonNull SharedPreferences preferences, @NonNull String key, long defaultValue) {
        this.preferences = preferences;
        this.key = key;
        this.defaultValue = defaultValue;
    }

    public long get() {
        return this.preferences.getLong(this.key, this.defaultValue);
    }

    public boolean isSet() {
        return this.preferences.contains(this.key);
    }

    public void set(long value) {
        this.preferences.edit().putLong(this.key, value).apply();
    }

    public void delete() {
        this.preferences.edit().remove(this.key).apply();
    }
}

