/*
 * Decompiled with CFR 0.152.
 */
package com.neyogiry.android.barcodescanner.barcodedetection;

import android.graphics.Canvas;
import android.graphics.Path;
import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcode;
import com.neyogiry.android.barcodescanner.Utils;
import com.neyogiry.android.barcodescanner.barcodedetection.BarcodeGraphicBase;
import com.neyogiry.android.barcodescanner.camera.GraphicOverlay;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/neyogiry/android/barcodescanner/barcodedetection/BarcodeConfirmingGraphic;", "Lcom/neyogiry/android/barcodescanner/barcodedetection/BarcodeGraphicBase;", "overlay", "Lcom/neyogiry/android/barcodescanner/camera/GraphicOverlay;", "barcode", "Lcom/google/firebase/ml/vision/barcode/FirebaseVisionBarcode;", "(Lcom/neyogiry/android/barcodescanner/camera/GraphicOverlay;Lcom/google/firebase/ml/vision/barcode/FirebaseVisionBarcode;)V", "draw", "", "canvas", "Landroid/graphics/Canvas;", "barcodescanner_release"})
public final class BarcodeConfirmingGraphic
extends BarcodeGraphicBase {
    private final FirebaseVisionBarcode barcode;

    @Override
    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.draw(canvas);
        float sizeProgress = Utils.INSTANCE.getProgressToMeetBarcodeSizeRequirement(this.getOverlay(), this.barcode);
        Path path = new Path();
        if (sizeProgress > 0.95f) {
            path.moveTo(this.getBoxRect().left, this.getBoxRect().top);
            path.lineTo(this.getBoxRect().right, this.getBoxRect().top);
            path.lineTo(this.getBoxRect().right, this.getBoxRect().bottom);
            path.lineTo(this.getBoxRect().left, this.getBoxRect().bottom);
            path.close();
        } else {
            path.moveTo(this.getBoxRect().left, this.getBoxRect().top + this.getBoxRect().height() * sizeProgress);
            path.lineTo(this.getBoxRect().left, this.getBoxRect().top);
            path.lineTo(this.getBoxRect().left + this.getBoxRect().width() * sizeProgress, this.getBoxRect().top);
            path.moveTo(this.getBoxRect().right, this.getBoxRect().bottom - this.getBoxRect().height() * sizeProgress);
            path.lineTo(this.getBoxRect().right, this.getBoxRect().bottom);
            path.lineTo(this.getBoxRect().right - this.getBoxRect().width() * sizeProgress, this.getBoxRect().bottom);
        }
        canvas.drawPath(path, this.getPathPaint());
    }

    public BarcodeConfirmingGraphic(@NotNull GraphicOverlay overlay, @NotNull FirebaseVisionBarcode barcode) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)overlay), (String)"overlay");
        Intrinsics.checkParameterIsNotNull((Object)barcode, (String)"barcode");
        super(overlay);
        this.barcode = barcode;
    }
}

