/*
 * Decompiled with CFR 0.152.
 */
package com.neyogiry.android.barcodescanner;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.RectF;
import android.hardware.Camera;
import android.util.Log;
import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcode;
import com.neyogiry.android.barcodescanner.camera.CameraSizePair;
import com.neyogiry.android.barcodescanner.camera.GraphicOverlay;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/neyogiry/android/barcodescanner/Utils;", "", "()V", "ASPECT_RATIO_TOLERANCE", "", "TAG", "", "generateValidPreviewSizeList", "", "Lcom/neyogiry/android/barcodescanner/camera/CameraSizePair;", "camera", "Landroid/hardware/Camera;", "getBarcodeReticleBox", "Landroid/graphics/RectF;", "overlay", "Lcom/neyogiry/android/barcodescanner/camera/GraphicOverlay;", "getProgressToMeetBarcodeSizeRequirement", "barcode", "Lcom/google/firebase/ml/vision/barcode/FirebaseVisionBarcode;", "isPortraitMode", "", "context", "Landroid/content/Context;", "barcodescanner_release"})
public final class Utils {
    public static final float ASPECT_RATIO_TOLERANCE = 0.01f;
    private static final String TAG = "Utils";
    public static final Utils INSTANCE;

    public final boolean isPortraitMode(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        return resources.getConfiguration().orientation == 1;
    }

    @NotNull
    public final List<CameraSizePair> generateValidPreviewSizeList(@NotNull Camera camera) {
        Camera.Parameters parameters;
        Intrinsics.checkParameterIsNotNull((Object)camera, (String)"camera");
        Camera.Parameters parameters2 = parameters = camera.getParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)parameters2, (String)"parameters");
        List supportedPreviewSizes = parameters2.getSupportedPreviewSizes();
        List supportedPictureSizes = parameters.getSupportedPictureSizes();
        ArrayList<CameraSizePair> validPreviewSizes = new ArrayList<CameraSizePair>();
        block0: for (Camera.Size previewSize : supportedPreviewSizes) {
            float previewAspectRatio = (float)previewSize.width / (float)previewSize.height;
            for (Camera.Size pictureSize : supportedPictureSizes) {
                float pictureAspectRatio = (float)pictureSize.width / (float)pictureSize.height;
                float f = previewAspectRatio - pictureAspectRatio;
                boolean bl = false;
                if (!(Math.abs(f) < 0.01f)) continue;
                Camera.Size size = previewSize;
                Intrinsics.checkExpressionValueIsNotNull((Object)size, (String)"previewSize");
                validPreviewSizes.add(new CameraSizePair(size, pictureSize));
                continue block0;
            }
        }
        if (validPreviewSizes.isEmpty()) {
            Log.w((String)TAG, (String)"No preview sizes have a corresponding same-aspect-ratio picture size.");
            Iterator iterator = supportedPreviewSizes.iterator();
            while (iterator.hasNext()) {
                Camera.Size previewSize;
                Camera.Size size = previewSize = (Camera.Size)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)size, (String)"previewSize");
                validPreviewSizes.add(new CameraSizePair(size, null));
            }
        }
        return validPreviewSizes;
    }

    @NotNull
    public final RectF getBarcodeReticleBox(@NotNull GraphicOverlay overlay) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)overlay), (String)"overlay");
        float overlayWidth = overlay.getWidth();
        float overlayHeight = overlay.getHeight();
        float boxWidth = overlayWidth * (float)80 / (float)100;
        float boxHeight = overlayHeight * (float)35 / (float)100;
        float cx = overlayWidth / (float)2;
        float cy = overlayHeight / (float)2;
        return new RectF(cx - boxWidth / (float)2, cy - boxHeight / (float)2, cx + boxWidth / (float)2, cy + boxHeight / (float)2);
    }

    public final float getProgressToMeetBarcodeSizeRequirement(@NotNull GraphicOverlay overlay, @NotNull FirebaseVisionBarcode barcode) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)overlay), (String)"overlay");
        Intrinsics.checkParameterIsNotNull((Object)barcode, (String)"barcode");
        return 1.0f;
    }

    private Utils() {
    }

    static {
        Utils utils;
        INSTANCE = utils = new Utils();
    }
}

