/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.utils;

import android.text.TextUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public final class FileUtils {
    private static final int COPY_BUFFER_SIZE = 8192;

    private FileUtils() {
    }

    public static File getMergedFile(File[] files, String mergedFilePath, String mergedFileName) throws IOException, IllegalArgumentException {
        if (files == null || files.length == 0) {
            throw new IllegalArgumentException("You must provide at least one input file");
        }
        if (TextUtils.isEmpty((CharSequence)mergedFilePath) || TextUtils.isEmpty((CharSequence)mergedFileName)) {
            throw new IllegalArgumentException("You must provide meaningful path and file name");
        }
        byte[] buffer = new byte[8192];
        File result = new File(mergedFilePath, mergedFileName);
        FileOutputStream fos = new FileOutputStream(result, false);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        for (File file : files) {
            int count;
            FileInputStream fis = new FileInputStream(file);
            BufferedInputStream bis = new BufferedInputStream(fis, buffer.length);
            while ((count = bis.read(buffer, 0, buffer.length)) != -1) {
                bos.write(buffer, 0, count);
            }
            bis.close();
        }
        bos.close();
        return result;
    }
}

