/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.payload;

import com.newrelic.agent.android.util.SafeJsonPrimitive;
import com.newrelic.com.google.gson.JsonObject;
import java.nio.ByteBuffer;
import java.util.UUID;

public class Payload {
    private final long timestamp = System.currentTimeMillis();
    private final String uuid = UUID.randomUUID().toString();
    private ByteBuffer payload;
    private boolean isPersistable = true;

    public Payload() {
    }

    public Payload(byte[] bytes) {
        this();
        this.payload = ByteBuffer.wrap(bytes);
    }

    public byte[] getBytes() {
        return this.payload.array();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getUuid() {
        return this.uuid;
    }

    public boolean isStale(long ttl) {
        return this.timestamp + ttl <= System.currentTimeMillis();
    }

    public void putBytes(byte[] payloadBytes) {
        this.payload = ByteBuffer.wrap(payloadBytes);
    }

    public void setPersisted(boolean isPersistable) {
        this.isPersistable = isPersistable;
    }

    public boolean isPersisted() {
        return this.isPersistable;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Payload) {
            return this.uuid.equalsIgnoreCase(((Payload)object).uuid);
        }
        return false;
    }

    public JsonObject asJsonObject() {
        JsonObject jsonObj = new JsonObject();
        jsonObj.add("timestamp", SafeJsonPrimitive.factory(this.timestamp));
        jsonObj.add("uuid", SafeJsonPrimitive.factory(this.uuid));
        return jsonObj;
    }

    public String asJsonMeta() {
        return this.asJsonObject().toString();
    }
}

