/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.metric;

import com.newrelic.agent.android.metric.Metric;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MetricStore {
    private final Map<String, Map<String, Metric>> metricStore = new ConcurrentHashMap<String, Map<String, Metric>>();

    public void add(Metric metric) {
        String scope = metric.getStringScope();
        String name = metric.getName();
        if (!this.metricStore.containsKey(scope)) {
            this.metricStore.put(scope, new HashMap());
        }
        if (this.metricStore.get(scope).containsKey(name)) {
            this.metricStore.get(scope).get(name).aggregate(metric);
        } else {
            this.metricStore.get(scope).put(name, metric);
        }
    }

    public Metric get(String name) {
        return this.get(name, "");
    }

    public Metric get(String name, String scope) {
        try {
            return this.metricStore.get(scope == null ? "" : scope).get(name);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public List<Metric> getAll() {
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        for (Map.Entry<String, Map<String, Metric>> entry : this.metricStore.entrySet()) {
            for (Map.Entry<String, Metric> metricEntry : entry.getValue().entrySet()) {
                metrics.add(metricEntry.getValue());
            }
        }
        return metrics;
    }

    public List<Metric> getAllByScope(String scope) {
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        try {
            for (Map.Entry<String, Metric> metricEntry : this.metricStore.get(scope).entrySet()) {
                metrics.add(metricEntry.getValue());
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return metrics;
    }

    public List<Metric> getAllUnscoped() {
        return this.getAllByScope("");
    }

    public void remove(Metric metric) {
        String scope = metric.getStringScope();
        String name = metric.getName();
        if (!this.metricStore.containsKey(scope)) {
            return;
        }
        if (!this.metricStore.get(scope).containsKey(name)) {
            return;
        }
        this.metricStore.get(scope).remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(List<Metric> metrics) {
        Map<String, Map<String, Metric>> map = this.metricStore;
        synchronized (map) {
            for (Metric metric : metrics) {
                this.remove(metric);
            }
        }
    }

    public List<Metric> removeAllWithScope(String scope) {
        List<Metric> metrics = this.getAllByScope(scope);
        if (!metrics.isEmpty()) {
            this.removeAll(metrics);
        }
        return metrics;
    }

    public void clear() {
        this.metricStore.clear();
    }

    public boolean isEmpty() {
        return this.metricStore.isEmpty();
    }
}

