/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.measurement.consumer;

import com.newrelic.agent.android.harvest.Harvest;
import com.newrelic.agent.android.harvest.HarvestLifecycleAware;
import com.newrelic.agent.android.measurement.Measurement;
import com.newrelic.agent.android.measurement.MeasurementType;
import com.newrelic.agent.android.measurement.consumer.BaseMeasurementConsumer;
import com.newrelic.agent.android.metric.Metric;
import com.newrelic.agent.android.metric.MetricStore;

public abstract class MetricMeasurementConsumer
extends BaseMeasurementConsumer
implements HarvestLifecycleAware {
    protected MetricStore metrics = new MetricStore();
    protected boolean recordUnscopedMetrics = true;

    public MetricMeasurementConsumer(MeasurementType measurementType) {
        super(measurementType);
        Harvest.addHarvestListener(this);
    }

    protected abstract String formatMetricName(String var1);

    @Override
    public void consumeMeasurement(Measurement measurement) {
        String name = this.formatMetricName(measurement.getName());
        String scope = measurement.getScope();
        double delta = measurement.getEndTimeInSeconds() - measurement.getStartTimeInSeconds();
        if (scope != null) {
            Metric scopedMetric = this.metrics.get(name, scope);
            if (scopedMetric == null) {
                scopedMetric = new Metric(name, scope);
                this.metrics.add(scopedMetric);
            }
            scopedMetric.sample(delta);
            scopedMetric.addExclusive(measurement.getExclusiveTimeInSeconds());
        }
        if (!this.recordUnscopedMetrics) {
            return;
        }
        Metric unscopedMetric = this.metrics.get(name);
        if (unscopedMetric == null) {
            unscopedMetric = new Metric(name);
            this.metrics.add(unscopedMetric);
        }
        unscopedMetric.sample(delta);
        unscopedMetric.addExclusive(measurement.getExclusiveTimeInSeconds());
    }

    protected void addMetric(Metric newMetric) {
        Metric metric = newMetric.getScope() != null ? this.metrics.get(newMetric.getName(), newMetric.getScope()) : this.metrics.get(newMetric.getName());
        if (metric != null) {
            metric.aggregate(newMetric);
        } else {
            this.metrics.add(newMetric);
        }
    }

    @Override
    public void onHarvest() {
        for (Metric metric : this.metrics.getAll()) {
            Harvest.addMetric(metric);
        }
    }

    @Override
    public void onHarvestComplete() {
        this.metrics.clear();
    }

    @Override
    public void onHarvestError() {
        this.metrics.clear();
    }

    @Override
    public void onHarvestSendFailed() {
        this.metrics.clear();
    }
}

