/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation.okhttp3;

import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.Sink;

public class PrebufferedResponseBody
extends ResponseBody {
    private final ResponseBody impl;
    private final BufferedSource source;
    private final long contentLength;

    public PrebufferedResponseBody(ResponseBody impl) {
        BufferedSource source = impl.source();
        if (impl.contentLength() == -1L) {
            Buffer buffer = new Buffer();
            try {
                source.readAll((Sink)buffer);
                source = buffer;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.impl = impl;
        this.source = source;
        this.contentLength = impl.contentLength() >= 0L ? impl.contentLength() : source.buffer().size();
    }

    public MediaType contentType() {
        return this.impl.contentType();
    }

    public long contentLength() {
        long contentLength = this.impl.contentLength();
        switch ((int)contentLength) {
            case -1: {
                break;
            }
            case 0: {
                contentLength = this.source.buffer().size();
            }
        }
        return contentLength;
    }

    public BufferedSource source() {
        return this.source;
    }

    public void close() {
        this.impl.close();
    }
}

