/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation.httpclient;

import com.newrelic.agent.android.TaskQueue;
import com.newrelic.agent.android.api.common.TransactionData;
import com.newrelic.agent.android.instrumentation.TransactionState;
import com.newrelic.agent.android.instrumentation.TransactionStateUtil;
import com.newrelic.agent.android.instrumentation.io.CountingInputStream;
import com.newrelic.agent.android.instrumentation.io.CountingOutputStream;
import com.newrelic.agent.android.instrumentation.io.StreamCompleteEvent;
import com.newrelic.agent.android.instrumentation.io.StreamCompleteListener;
import com.newrelic.agent.android.instrumentation.io.StreamCompleteListenerSource;
import com.newrelic.agent.android.measurement.http.HttpTransactionMeasurement;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;

@Deprecated
public final class HttpRequestEntityImpl
implements HttpEntity,
StreamCompleteListener {
    private final HttpEntity impl;
    private final TransactionState transactionState;

    public HttpRequestEntityImpl(HttpEntity impl, TransactionState transactionState) {
        this.impl = impl;
        this.transactionState = transactionState;
    }

    public void consumeContent() throws IOException {
        try {
            this.impl.consumeContent();
        }
        catch (IOException e) {
            this.handleException(e);
            throw e;
        }
    }

    public InputStream getContent() throws IOException, IllegalStateException {
        try {
            if (!this.transactionState.isSent()) {
                CountingInputStream stream = new CountingInputStream(this.impl.getContent());
                stream.addStreamCompleteListener(this);
                return stream;
            }
            return this.impl.getContent();
        }
        catch (IOException e) {
            this.handleException(e);
            throw e;
        }
        catch (IllegalStateException e) {
            this.handleException(e);
            throw e;
        }
    }

    public Header getContentEncoding() {
        return this.impl.getContentEncoding();
    }

    public long getContentLength() {
        return this.impl.getContentLength();
    }

    public Header getContentType() {
        return this.impl.getContentType();
    }

    public boolean isChunked() {
        return this.impl.isChunked();
    }

    public boolean isRepeatable() {
        return this.impl.isRepeatable();
    }

    public boolean isStreaming() {
        return this.impl.isStreaming();
    }

    public void writeTo(OutputStream outstream) throws IOException {
        try {
            if (!this.transactionState.isSent()) {
                CountingOutputStream stream = new CountingOutputStream(outstream);
                this.impl.writeTo((OutputStream)stream);
                this.transactionState.setBytesSent(stream.getCount());
            } else {
                this.impl.writeTo(outstream);
            }
        }
        catch (IOException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public void streamComplete(StreamCompleteEvent e) {
        StreamCompleteListenerSource source = (StreamCompleteListenerSource)e.getSource();
        source.removeStreamCompleteListener(this);
        this.transactionState.setBytesSent(e.getBytes());
    }

    @Override
    public void streamError(StreamCompleteEvent e) {
        StreamCompleteListenerSource source = (StreamCompleteListenerSource)e.getSource();
        source.removeStreamCompleteListener(this);
        this.handleException(e.getException(), e.getBytes());
    }

    protected void handleException(Exception e) {
        this.handleException(e, null);
    }

    protected void handleException(Exception e, Long streamBytes) {
        TransactionStateUtil.setErrorCodeFromException(this.transactionState, e);
        if (!this.transactionState.isComplete()) {
            TransactionData transactionData;
            if (streamBytes != null) {
                this.transactionState.setBytesSent(streamBytes);
            }
            if ((transactionData = this.transactionState.end()) != null) {
                transactionData.setResponseBody(e.toString());
                TaskQueue.queue(new HttpTransactionMeasurement(transactionData));
            }
        }
    }
}

