/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation;

import com.newrelic.agent.android.TaskQueue;
import com.newrelic.agent.android.api.common.TransactionData;
import com.newrelic.agent.android.instrumentation.HttpURLConnectionExtension;
import com.newrelic.agent.android.instrumentation.HttpsURLConnectionExtension;
import com.newrelic.agent.android.instrumentation.TransactionState;
import com.newrelic.agent.android.instrumentation.TransactionStateUtil;
import com.newrelic.agent.android.instrumentation.WrapReturn;
import com.newrelic.agent.android.measurement.http.HttpTransactionMeasurement;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import javax.net.ssl.HttpsURLConnection;

public final class URLConnectionInstrumentation {
    private URLConnectionInstrumentation() {
    }

    @WrapReturn(className="java/net/URL", methodName="openConnection", methodDesc="()Ljava/net/URLConnection;")
    public static URLConnection openConnection(URLConnection connection) {
        if (connection instanceof HttpsURLConnection) {
            return new HttpsURLConnectionExtension((HttpsURLConnection)connection);
        }
        if (connection instanceof HttpURLConnection) {
            return new HttpURLConnectionExtension((HttpURLConnection)connection);
        }
        return connection;
    }

    @WrapReturn(className="java/net/URL", methodName="openConnection", methodDesc="(Ljava/net/Proxy;)Ljava/net/URLConnection;")
    public static URLConnection openConnectionWithProxy(URLConnection connection) {
        if (connection instanceof HttpsURLConnection) {
            return new HttpsURLConnectionExtension((HttpsURLConnection)connection);
        }
        if (connection instanceof HttpURLConnection) {
            return new HttpURLConnectionExtension((HttpURLConnection)connection);
        }
        return connection;
    }

    protected static void httpClientError(TransactionState transactionState, Exception e) {
        if (!transactionState.isComplete()) {
            TransactionStateUtil.setErrorCodeFromException(transactionState, e);
            TransactionData transactionData = transactionState.end();
            if (transactionData != null) {
                transactionData.setResponseBody(e.toString());
                TaskQueue.queue(new HttpTransactionMeasurement(transactionData));
            }
        }
    }
}

