/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.distributedtracing;

import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.analytics.AnalyticsControllerImpl;
import com.newrelic.agent.android.analytics.AnalyticsEvent;
import com.newrelic.agent.android.analytics.AnalyticsEventCategory;
import com.newrelic.agent.android.distributedtracing.DistributedTracing;
import com.newrelic.agent.android.distributedtracing.TraceFacade;
import com.newrelic.agent.android.distributedtracing.UserActionType;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;

public class UserActionFacade {
    private static TraceFacade traceFacade = DistributedTracing.getInstance();
    private static final AtomicReference<UserActionFacade> instance = new AtomicReference<Object>(null);

    public static UserActionFacade getInstance() {
        instance.compareAndSet(null, new UserActionFacade());
        return instance.get();
    }

    static void setTraceFacade(TraceFacade traceFacade) {
        UserActionFacade.traceFacade = traceFacade;
    }

    public void recordUserAction(UserActionType userActionType) {
        this.recordUserAction(userActionType, null);
    }

    public void recordUserAction(UserActionType userActionType, Map<String, Object> userActionAttributes) {
        if (FeatureFlag.featureEnabled(FeatureFlag.DistributedTracing)) {
            TreeMap<String, Object> attributes = new TreeMap<String, Object>();
            attributes.put("actionType", userActionType.toString());
            if (userActionAttributes != null) {
                attributes.putAll(userActionAttributes);
            }
            AnalyticsControllerImpl.getInstance().internalRecordEvent(AnalyticsEvent.EVENT_NAME_IS_TYPE, AnalyticsEventCategory.UserAction, "MobileUserAction", attributes);
        }
    }
}

