/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.crash;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.AgentConfiguration;
import com.newrelic.agent.android.crash.Crash;
import com.newrelic.agent.android.payload.PayloadSender;
import com.newrelic.agent.android.stats.StatsEngine;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

public class CrashSender
extends PayloadSender {
    public static final int CRASH_COLLECTOR_TIMEOUT = 5000;
    private static final String CRASH_COLLECTOR_PATH = "/mobile_crash";
    private final Crash crash;

    public CrashSender(Crash crash, AgentConfiguration agentConfiguration) {
        super(crash.toJsonString().getBytes(), agentConfiguration);
        this.crash = crash;
    }

    @Override
    protected HttpURLConnection getConnection() throws IOException {
        String urlString = this.getProtocol() + this.agentConfiguration.getCrashCollectorHost() + CRASH_COLLECTOR_PATH;
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty(this.agentConfiguration.getAppTokenHeader(), this.agentConfiguration.getApplicationToken());
        connection.setRequestProperty(this.agentConfiguration.getDeviceOsNameHeader(), Agent.getDeviceInformation().getOsName());
        connection.setRequestProperty(this.agentConfiguration.getAppVersionHeader(), Agent.getApplicationInformation().getAppVersion());
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        return connection;
    }

    @Override
    public PayloadSender call() {
        this.setPayload(this.crash.toJsonString().getBytes());
        this.crash.incrementUploadCount();
        this.agentConfiguration.getCrashStore().store(this.crash);
        try {
            return super.call();
        }
        catch (Exception e) {
            this.onFailedUpload("Unable to report crash to New Relic, will try again later. " + e);
            return this;
        }
    }

    @Override
    protected void onRequestResponse(HttpURLConnection connection) throws IOException {
        int responseCode = connection.getResponseCode();
        switch (responseCode) {
            case 200: {
                StatsEngine.get().sampleTimeMs("Supportability/AgentHealth/Crash/UploadTime", this.timer.peek());
                log.info("CrashSender: Crash " + this.crash.getUuid().toString() + " successfully submitted.");
                break;
            }
            case 500: {
                StatsEngine.get().inc("Supportability/AgentHealth/Crash/Removed/Rejected");
                this.onFailedUpload("The crash was rejected and will be deleted - Response code " + connection.getResponseCode());
                break;
            }
            default: {
                this.onFailedUpload("Something went wrong while submitting a crash (will try again later) - Response code " + connection.getResponseCode());
            }
        }
        log.debug("CrashSender: Crash collection took " + this.timer.toc() + "ms");
    }

    @Override
    protected void onFailedUpload(String errorMsg) {
        log.error("CrashSender: " + errorMsg);
        StatsEngine.get().inc("Supportability/AgentHealth/Crash/FailedUpload");
    }

    @Override
    protected void onRequestException(Exception e) {
        log.error("CrashSender: Crash upload failed: " + e);
    }

    @Override
    protected boolean shouldUploadOpportunistically() {
        return Agent.hasReachableNetworkConnection(null);
    }
}

