/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.analytics;

import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.analytics.AnalyticsAttribute;
import com.newrelic.agent.android.analytics.AnalyticsEvent;
import com.newrelic.agent.android.analytics.AnalyticsEventCategory;
import com.newrelic.agent.android.distributedtracing.TraceContext;
import com.newrelic.agent.android.harvest.HttpTransaction;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;

public class NetworkRequestEvent
extends AnalyticsEvent {
    public NetworkRequestEvent(Set<AnalyticsAttribute> attributeSet) {
        super(null, AnalyticsEventCategory.NetworkRequest, "MobileRequest", attributeSet);
    }

    public static NetworkRequestEvent createNetworkEvent(HttpTransaction txn) {
        Set<AnalyticsAttribute> attributes = NetworkRequestEvent.createDefaultAttributeSet(txn);
        attributes.add(new AnalyticsAttribute("responseTime", txn.getTotalTime()));
        attributes.add(new AnalyticsAttribute("statusCode", txn.getStatusCode()));
        attributes.add(new AnalyticsAttribute("bytesSent", txn.getBytesSent()));
        attributes.add(new AnalyticsAttribute("bytesReceived", txn.getBytesReceived()));
        return new NetworkRequestEvent(attributes);
    }

    static Set<AnalyticsAttribute> createDefaultAttributeSet(HttpTransaction txn) {
        TraceContext traceContext;
        double bytesReceived;
        double bytesSent;
        HashSet<AnalyticsAttribute> attributes = new HashSet<AnalyticsAttribute>();
        try {
            URL url = new URL(txn.getUrl());
            attributes.add(new AnalyticsAttribute("requestDomain", url.getHost()));
            attributes.add(new AnalyticsAttribute("requestPath", url.getPath()));
        }
        catch (MalformedURLException e) {
            log.error(txn.getUrl() + " is not a valid URL. Unable to set host or path attributes.");
        }
        attributes.add(new AnalyticsAttribute("requestUrl", txn.getUrl()));
        attributes.add(new AnalyticsAttribute("connectionType", txn.getWanType()));
        attributes.add(new AnalyticsAttribute("requestMethod", txn.getHttpMethod()));
        double totalTime = txn.getTotalTime();
        if (totalTime != 0.0) {
            attributes.add(new AnalyticsAttribute("responseTime", totalTime));
        }
        if ((bytesSent = (double)txn.getBytesSent()) != 0.0) {
            attributes.add(new AnalyticsAttribute("bytesSent", bytesSent));
        }
        if ((bytesReceived = (double)txn.getBytesReceived()) != 0.0) {
            attributes.add(new AnalyticsAttribute("bytesReceived", bytesReceived));
        }
        if (FeatureFlag.featureEnabled(FeatureFlag.DistributedTracing) && (traceContext = txn.getTraceContext()) != null) {
            try {
                Set<AnalyticsAttribute> validatedTracePayloadAttributes = validator.toValidatedAnalyticsAttributes(traceContext.asTraceAttributes());
                attributes.addAll(validatedTracePayloadAttributes);
            }
            catch (Exception e) {
                log.error("Error occurred parsing the instrinsic attribute set: ", e);
            }
        }
        return attributes;
    }
}

