/*
 * Decompiled with CFR 0.152.
 */
package com.neuromd.javaobserver;

import com.neuromd.javaobserver.INotificationCallback;
import com.neuromd.javaobserver.NotificationDeadlockException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public class SubscribersNotifier<T> {
    private final List<INotificationCallback<T>> mSubscribers = new ArrayList<INotificationCallback<T>>();
    private final ReentrantLock mLock = new ReentrantLock();

    public void subscribe(INotificationCallback<T> callback) {
        if (this.mLock.isHeldByCurrentThread()) {
            throw new NotificationDeadlockException("Attempt to modify notification list from notification thread");
        }
        this.mLock.lock();
        try {
            if (!this.mSubscribers.contains(callback)) {
                this.mSubscribers.add(callback);
            }
        }
        finally {
            this.mLock.unlock();
        }
    }

    public void unsubscribe(INotificationCallback<T> callback) {
        if (this.mLock.isHeldByCurrentThread()) {
            throw new NotificationDeadlockException("Attempt to modify notification list from notification thread");
        }
        this.mLock.lock();
        try {
            this.mSubscribers.remove(callback);
        }
        finally {
            this.mLock.unlock();
        }
    }

    public void unsubscribe() {
        if (this.mLock.isHeldByCurrentThread()) {
            throw new NotificationDeadlockException("Attempt to modify notification list from notification thread");
        }
        this.mLock.lock();
        try {
            this.mSubscribers.clear();
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNotification(Object sender, T param) {
        this.mLock.lock();
        try {
            for (INotificationCallback<T> subscriber : this.mSubscribers) {
                if (subscriber == null) continue;
                subscriber.onNotify(sender, param);
            }
        }
        finally {
            this.mLock.unlock();
        }
    }

    public void sendNotificationAsync(final Object sender, final T param) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SubscribersNotifier.this.sendNotification(sender, param);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }).start();
    }
}

