/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.MessageSourceValidationMessage;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorState;
import com.networknt.schema.ValidatorTypeCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneOfValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(OneOfValidator.class);
    private final List<JsonSchema> schemas = new ArrayList<JsonSchema>();
    private Boolean canShortCircuit = null;

    public OneOfValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.ONE_OF, validationContext);
        int size = schemaNode.size();
        for (int i = 0; i < size; ++i) {
            JsonNode childNode = schemaNode.get(i);
            this.schemas.add(validationContext.newSchema(schemaLocation.append(i), evaluationPath.append(i), childNode, parentSchema));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        OneOfValidator.debug(logger, node, rootNode, instanceLocation);
        ValidatorState state = executionContext.getValidatorState();
        state.setComplexValidator(true);
        int numberOfValidSchema = 0;
        LinkedHashSet childErrors = new LinkedHashSet();
        boolean failFast = executionContext.getExecutionConfig().isFailFast();
        try {
            executionContext.getExecutionConfig().setFailFast(false);
            for (JsonSchema schema : this.schemas) {
                Set<Object> schemaErrors = Collections.emptySet();
                state.setMatchedNode(true);
                schemaErrors = !state.isWalkEnabled() ? schema.validate(executionContext, node, rootNode, instanceLocation) : schema.walk(executionContext, node, rootNode, instanceLocation, state.isValidationEnabled());
                if (schemaErrors.isEmpty()) {
                    if (!state.hasMatchedNode()) continue;
                    ++numberOfValidSchema;
                }
                if (numberOfValidSchema > 1 && this.canShortCircuit()) {
                    break;
                }
                childErrors.addAll(schemaErrors);
            }
        }
        finally {
            executionContext.getExecutionConfig().setFailFast(failFast);
        }
        if (numberOfValidSchema != 1) {
            ValidationMessage message = ((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(node)).instanceLocation(instanceLocation)).locale(executionContext.getExecutionConfig().getLocale())).failFast(executionContext.getExecutionConfig().isFailFast())).arguments(Integer.toString(numberOfValidSchema))).build();
            errors.add(message);
            errors.addAll(childErrors);
        }
        if (errors.isEmpty()) {
            state.setMatchedNode(true);
        }
        OneOfValidator.resetValidatorState(executionContext);
        return Collections.unmodifiableSet(errors);
    }

    protected boolean canShortCircuit() {
        if (this.canShortCircuit == null) {
            boolean canShortCircuit = true;
            for (JsonValidator validator : this.getEvaluationParentSchema().getValidators()) {
                if (!"unevaluatedProperties".equals(validator.getKeyword()) && !"unevaluatedItems".equals(validator.getKeyword())) continue;
                canShortCircuit = false;
            }
            this.canShortCircuit = canShortCircuit;
        }
        return this.canShortCircuit;
    }

    private static void resetValidatorState(ExecutionContext executionContext) {
        ValidatorState state = executionContext.getValidatorState();
        state.setComplexValidator(false);
        state.setMatchedNode(true);
    }

    @Override
    public Set<ValidationMessage> walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema) {
        LinkedHashSet<ValidationMessage> validationMessages = new LinkedHashSet<ValidationMessage>();
        if (shouldValidateSchema) {
            validationMessages.addAll(this.validate(executionContext, node, rootNode, instanceLocation));
        } else {
            for (JsonSchema schema : this.schemas) {
                schema.walk(executionContext, node, rootNode, instanceLocation, shouldValidateSchema);
            }
        }
        return validationMessages;
    }

    @Override
    public void preloadJsonSchema() {
        for (JsonSchema schema : this.schemas) {
            schema.initializeValidators();
        }
        this.canShortCircuit();
    }
}

