/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.walk;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.ValidationContext;

public class WalkEvent {
    private ExecutionContext executionContext;
    private SchemaLocation schemaLocation;
    private JsonNodePath evaluationPath;
    private JsonNode schemaNode;
    private JsonSchema parentSchema;
    private String keyword;
    private JsonNode node;
    private JsonNode rootNode;
    private JsonNodePath instanceLocation;
    private JsonSchemaFactory currentJsonSchemaFactory;
    private ValidationContext validationContext;

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public SchemaLocation getSchemaLocation() {
        return this.schemaLocation;
    }

    public JsonNodePath getEvaluationPath() {
        return this.evaluationPath;
    }

    public JsonNode getSchemaNode() {
        return this.schemaNode;
    }

    public JsonSchema getParentSchema() {
        return this.parentSchema;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public JsonNode getNode() {
        return this.node;
    }

    public JsonNode getRootNode() {
        return this.rootNode;
    }

    public JsonNodePath getInstanceLocation() {
        return this.instanceLocation;
    }

    public JsonSchema getRefSchema(SchemaLocation schemaUri) {
        return this.currentJsonSchemaFactory.getSchema(schemaUri, this.validationContext.getConfig());
    }

    public JsonSchema getRefSchema(SchemaLocation schemaUri, SchemaValidatorsConfig schemaValidatorsConfig) {
        if (schemaValidatorsConfig != null) {
            return this.currentJsonSchemaFactory.getSchema(schemaUri, schemaValidatorsConfig);
        }
        return this.getRefSchema(schemaUri);
    }

    public JsonSchemaFactory getCurrentJsonSchemaFactory() {
        return this.currentJsonSchemaFactory;
    }

    public String toString() {
        return "WalkEvent [evaluationPath=" + this.evaluationPath + ", schemaLocation=" + this.schemaLocation + ", instanceLocation=" + this.instanceLocation + "]";
    }

    public static WalkEventBuilder builder() {
        return new WalkEventBuilder();
    }

    static class WalkEventBuilder {
        private WalkEvent walkEvent = new WalkEvent();

        WalkEventBuilder() {
        }

        public WalkEventBuilder executionContext(ExecutionContext executionContext) {
            this.walkEvent.executionContext = executionContext;
            return this;
        }

        public WalkEventBuilder evaluationPath(JsonNodePath evaluationPath) {
            this.walkEvent.evaluationPath = evaluationPath;
            return this;
        }

        public WalkEventBuilder schemaLocation(SchemaLocation schemaLocation) {
            this.walkEvent.schemaLocation = schemaLocation;
            return this;
        }

        public WalkEventBuilder schemaNode(JsonNode schemaNode) {
            this.walkEvent.schemaNode = schemaNode;
            return this;
        }

        public WalkEventBuilder parentSchema(JsonSchema parentSchema) {
            this.walkEvent.parentSchema = parentSchema;
            return this;
        }

        public WalkEventBuilder keyword(String keyword) {
            this.walkEvent.keyword = keyword;
            return this;
        }

        public WalkEventBuilder node(JsonNode node) {
            this.walkEvent.node = node;
            return this;
        }

        public WalkEventBuilder rootNode(JsonNode rootNode) {
            this.walkEvent.rootNode = rootNode;
            return this;
        }

        public WalkEventBuilder instanceLocation(JsonNodePath instanceLocation) {
            this.walkEvent.instanceLocation = instanceLocation;
            return this;
        }

        public WalkEventBuilder currentJsonSchemaFactory(JsonSchemaFactory currentJsonSchemaFactory) {
            this.walkEvent.currentJsonSchemaFactory = currentJsonSchemaFactory;
            return this;
        }

        public WalkEventBuilder validationContext(ValidationContext validationContext) {
            this.walkEvent.validationContext = validationContext;
            return this;
        }

        public WalkEvent build() {
            return this.walkEvent;
        }
    }
}

