/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.AbstractJsonValidator;
import com.networknt.schema.AbstractKeyword;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.Keyword;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class NonValidationKeyword
extends AbstractKeyword {
    public NonValidationKeyword(String keyword) {
        super(keyword);
    }

    @Override
    public JsonValidator newValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) throws JsonSchemaException, Exception {
        return new Validator(schemaLocation, evaluationPath, schemaNode, parentSchema, validationContext, this);
    }

    private static final class Validator
    extends AbstractJsonValidator {
        public Validator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext, Keyword keyword) {
            super(schemaLocation, evaluationPath, keyword);
            String id = validationContext.resolveSchemaId(schemaNode);
            String anchor = validationContext.getMetaSchema().readAnchor(schemaNode);
            if (id != null || anchor != null) {
                validationContext.newSchema(schemaLocation, evaluationPath, schemaNode, parentSchema);
            }
            if ("$defs".equals(keyword.getValue()) || "definitions".equals(keyword.getValue())) {
                Iterator field = schemaNode.fields();
                while (field.hasNext()) {
                    Map.Entry property = (Map.Entry)field.next();
                    validationContext.newSchema(schemaLocation.append((String)property.getKey()), evaluationPath.append((String)property.getKey()), (JsonNode)property.getValue(), parentSchema);
                }
            }
        }

        @Override
        public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
            return Collections.emptySet();
        }
    }
}

