/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.networknt.schema.JsonMetaSchema;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;

public class Annotations {
    public static final Set<String> UNEVALUATED_PROPERTIES_ANNOTATIONS;
    public static final Set<String> UNEVALUATED_ITEMS_ANNOTATIONS;
    public static final Set<String> EVALUATION_ANNOTATIONS;
    public static final Predicate<String> UNEVALUATED_PROPERTIES_ANNOTATIONS_PREDICATE;
    public static final Predicate<String> UNEVALUATED_ITEMS_ANNOTATIONS_PREDICATE;
    public static final Predicate<String> EVALUATION_ANNOTATIONS_PREDICATE;
    public static final Predicate<String> PREDICATE_FALSE;

    public static Set<String> getDefaultAnnotationAllowList(JsonMetaSchema metaSchema) {
        boolean unevaluatedItems;
        boolean unevaluatedProperties = metaSchema.getKeywords().get("unevaluatedProperties") != null;
        boolean bl = unevaluatedItems = metaSchema.getKeywords().get("unevaluatedItems") != null;
        if (unevaluatedProperties && unevaluatedItems) {
            return EVALUATION_ANNOTATIONS;
        }
        if (unevaluatedProperties && !unevaluatedItems) {
            return UNEVALUATED_PROPERTIES_ANNOTATIONS;
        }
        if (!unevaluatedProperties && unevaluatedItems) {
            return UNEVALUATED_ITEMS_ANNOTATIONS;
        }
        return Collections.emptySet();
    }

    public static Predicate<String> getDefaultAnnotationAllowListPredicate(JsonMetaSchema metaSchema) {
        boolean unevaluatedItems;
        boolean unevaluatedProperties = metaSchema.getKeywords().get("unevaluatedProperties") != null;
        boolean bl = unevaluatedItems = metaSchema.getKeywords().get("unevaluatedItems") != null;
        if (unevaluatedProperties && unevaluatedItems) {
            return EVALUATION_ANNOTATIONS_PREDICATE;
        }
        if (unevaluatedProperties && !unevaluatedItems) {
            return UNEVALUATED_PROPERTIES_ANNOTATIONS_PREDICATE;
        }
        if (!unevaluatedProperties && unevaluatedItems) {
            return UNEVALUATED_ITEMS_ANNOTATIONS_PREDICATE;
        }
        return PREDICATE_FALSE;
    }

    static {
        HashSet<String> unevaluatedProperties = new HashSet<String>();
        unevaluatedProperties.add("unevaluatedProperties");
        unevaluatedProperties.add("properties");
        unevaluatedProperties.add("patternProperties");
        unevaluatedProperties.add("additionalProperties");
        UNEVALUATED_PROPERTIES_ANNOTATIONS = Collections.unmodifiableSet(unevaluatedProperties);
        HashSet<String> unevaluatedItems = new HashSet<String>();
        unevaluatedItems.add("unevaluatedItems");
        unevaluatedItems.add("items");
        unevaluatedItems.add("prefixItems");
        unevaluatedItems.add("additionalItems");
        unevaluatedItems.add("contains");
        UNEVALUATED_ITEMS_ANNOTATIONS = Collections.unmodifiableSet(unevaluatedItems);
        HashSet<String> evaluation = new HashSet<String>();
        evaluation.addAll(unevaluatedProperties);
        evaluation.addAll(unevaluatedItems);
        EVALUATION_ANNOTATIONS = Collections.unmodifiableSet(evaluation);
        UNEVALUATED_PROPERTIES_ANNOTATIONS_PREDICATE = UNEVALUATED_PROPERTIES_ANNOTATIONS::contains;
        UNEVALUATED_ITEMS_ANNOTATIONS_PREDICATE = UNEVALUATED_ITEMS_ANNOTATIONS::contains;
        EVALUATION_ANNOTATIONS_PREDICATE = EVALUATION_ANNOTATIONS::contains;
        PREDICATE_FALSE = keyword -> false;
    }
}

