/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.CollectorContext;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.MessageSourceValidationMessage;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnevaluatedPropertiesValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(UnevaluatedPropertiesValidator.class);
    private final JsonSchema schema;

    public UnevaluatedPropertiesValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.UNEVALUATED_PROPERTIES, validationContext);
        if (!schemaNode.isObject() && !schemaNode.isBoolean()) {
            throw new IllegalArgumentException("The value of 'unevaluatedProperties' MUST be a valid JSON Schema.");
        }
        this.schema = validationContext.newSchema(schemaLocation, evaluationPath, schemaNode, parentSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        if (!executionContext.getExecutionConfig().getAnnotationAllowedPredicate().test(this.getKeyword()) || !node.isObject()) {
            return Collections.emptySet();
        }
        UnevaluatedPropertiesValidator.debug(logger, node, rootNode, instanceLocation);
        CollectorContext collectorContext = executionContext.getCollectorContext();
        collectorContext.exitDynamicScope();
        try {
            Set<JsonNodePath> allPaths = this.allPaths(node, instanceLocation);
            if (this.schemaNode.isBoolean() && this.schemaNode.asBoolean()) {
                collectorContext.getEvaluatedProperties().addAll(allPaths);
                Set<ValidationMessage> set = Collections.emptySet();
                return set;
            }
            Set<JsonNodePath> unevaluatedPaths = UnevaluatedPropertiesValidator.unevaluatedPaths(collectorContext, allPaths);
            if (this.schemaNode.isBoolean() && !this.schemaNode.asBoolean() && !unevaluatedPaths.isEmpty()) {
                Set<ValidationMessage> set = this.reportUnevaluatedPaths(unevaluatedPaths, executionContext);
                return set;
            }
            LinkedHashSet<JsonNodePath> failingPaths = new LinkedHashSet<JsonNodePath>();
            unevaluatedPaths.forEach(path -> {
                String pointer = path.getPathType().convertToJsonPointer(path.toString());
                JsonNode property = rootNode.at(pointer);
                if (!this.schema.validate(executionContext, property, rootNode, (JsonNodePath)path).isEmpty()) {
                    failingPaths.add((JsonNodePath)path);
                }
            });
            if (!failingPaths.isEmpty()) {
                Set<ValidationMessage> set = this.reportUnevaluatedPaths(failingPaths, executionContext);
                return set;
            }
            collectorContext.getEvaluatedProperties().addAll(allPaths);
            Set<ValidationMessage> set = Collections.emptySet();
            return set;
        }
        finally {
            collectorContext.enterDynamicScope();
        }
    }

    private Set<JsonNodePath> allPaths(JsonNode node, JsonNodePath instanceLocation) {
        LinkedHashSet<JsonNodePath> collector = new LinkedHashSet<JsonNodePath>();
        node.fields().forEachRemaining(entry -> collector.add(instanceLocation.append((String)entry.getKey())));
        return collector;
    }

    private Set<ValidationMessage> reportUnevaluatedPaths(Set<JsonNodePath> unevaluatedPaths, ExecutionContext executionContext) {
        return unevaluatedPaths.stream().map(path -> ((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceLocation((JsonNodePath)path)).locale(executionContext.getExecutionConfig().getLocale())).build()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static Set<JsonNodePath> unevaluatedPaths(CollectorContext collectorContext, Set<JsonNodePath> allPaths) {
        LinkedHashSet<JsonNodePath> unevaluatedProperties = new LinkedHashSet<JsonNodePath>(allPaths);
        unevaluatedProperties.removeAll(collectorContext.getEvaluatedProperties());
        return unevaluatedProperties;
    }
}

