/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemsValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(ItemsValidator.class);
    private static final String PROPERTY_ADDITIONAL_ITEMS = "additionalItems";
    private JsonSchema schema;
    private List<JsonSchema> tupleSchema;
    private boolean additionalItems = true;
    private JsonSchema additionalSchema;

    public ItemsValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.ITEMS, validationContext);
        if (schemaNode.isObject() || schemaNode.isBoolean()) {
            this.schema = new JsonSchema(validationContext, schemaPath, parentSchema.getCurrentUri(), schemaNode, parentSchema).initialize();
        } else {
            this.tupleSchema = new ArrayList<JsonSchema>();
            for (JsonNode s : schemaNode) {
                this.tupleSchema.add(new JsonSchema(validationContext, schemaPath, parentSchema.getCurrentUri(), s, parentSchema).initialize());
            }
            JsonNode addItemNode = this.getParentSchema().getSchemaNode().get(PROPERTY_ADDITIONAL_ITEMS);
            if (addItemNode != null) {
                if (addItemNode.isBoolean()) {
                    this.additionalItems = addItemNode.asBoolean();
                } else if (addItemNode.isObject()) {
                    this.additionalSchema = new JsonSchema(validationContext, parentSchema.getCurrentUri(), addItemNode).initialize();
                }
            }
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        if (!node.isArray() && !this.config.isTypeLoose()) {
            return errors;
        }
        if (node.isArray()) {
            int i = 0;
            for (JsonNode n : node) {
                this.doValidate(errors, i, n, rootNode, at);
                ++i;
            }
        } else {
            this.doValidate(errors, 0, node, rootNode, at);
        }
        return Collections.unmodifiableSet(errors);
    }

    private void doValidate(Set<ValidationMessage> errors, int i, JsonNode node, JsonNode rootNode, String at) {
        if (this.schema != null) {
            errors.addAll(this.schema.validate(node, rootNode, at + "[" + i + "]"));
        }
        if (this.tupleSchema != null) {
            if (i < this.tupleSchema.size()) {
                errors.addAll(this.tupleSchema.get(i).validate(node, rootNode, at + "[" + i + "]"));
            } else if (this.additionalSchema != null) {
                errors.addAll(this.additionalSchema.validate(node, rootNode, at + "[" + i + "]"));
            } else if (!this.additionalItems) {
                errors.add(this.buildValidationMessage(at, "" + i));
            }
        }
    }

    @Override
    public Set<ValidationMessage> walk(JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        LinkedHashSet<ValidationMessage> validationMessages = new LinkedHashSet<ValidationMessage>();
        if (node != null && node.isArray()) {
            int i = 0;
            for (JsonNode n : node) {
                this.doWalk(validationMessages, i, n, rootNode, at, shouldValidateSchema);
                ++i;
            }
        } else {
            this.doWalk(validationMessages, 0, node, rootNode, at, shouldValidateSchema);
        }
        return validationMessages;
    }

    private void doWalk(HashSet<ValidationMessage> validationMessages, int i, JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        if (this.schema != null) {
            if (shouldValidateSchema) {
                validationMessages.addAll(this.schema.validate(node, rootNode, at));
            }
            validationMessages.addAll(this.schema.walk(node, rootNode, at + "[" + i + "]", shouldValidateSchema));
        }
        if (this.tupleSchema != null) {
            if (i < this.tupleSchema.size()) {
                if (shouldValidateSchema) {
                    validationMessages.addAll(this.tupleSchema.get(i).validate(node, rootNode, at));
                }
                validationMessages.addAll(this.tupleSchema.get(i).walk(node, rootNode, at + "[" + i + "]", shouldValidateSchema));
            } else if (this.additionalSchema != null) {
                if (shouldValidateSchema) {
                    validationMessages.addAll(this.additionalSchema.validate(node, rootNode, at));
                }
                validationMessages.addAll(this.additionalSchema.walk(node, rootNode, at + "[" + i + "]", shouldValidateSchema));
            }
        }
    }

    public List<JsonSchema> getTupleSchema() {
        return this.tupleSchema;
    }

    public JsonSchema getSchema() {
        return this.schema;
    }
}

